/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.core;

import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.JadeCommonConfig;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.impl.WailaClientRegistration;

public enum ObjectNameProvider implements IBlockComponentProvider,
IEntityComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public static Component getEntityName(Entity entity) {
        if (!entity.m_8077_()) {
            Display.BlockDisplay blockDisplay;
            Display.ItemDisplay itemDisplay;
            ItemStack stack;
            if (WailaClientRegistration.INSTANCE.shouldPick(entity) && (stack = entity.m_142340_()) != null && !stack.m_41619_()) {
                return stack.m_41786_();
            }
            if (entity instanceof Villager) {
                return entity.m_6095_().m_20676_();
            }
            if (entity instanceof ItemEntity) {
                return ((ItemEntity)entity).m_32055_().m_41786_();
            }
            if (entity instanceof Display.ItemDisplay && !(itemDisplay = (Display.ItemDisplay)entity).m_141942_(0).m_142196_().m_41619_()) {
                return itemDisplay.m_141942_(0).m_142196_().m_41786_();
            }
            if (entity instanceof Display.BlockDisplay && !(blockDisplay = (Display.BlockDisplay)entity).m_269134_().m_60795_()) {
                return blockDisplay.m_269134_().m_60734_().m_49954_();
            }
        }
        return entity.m_7755_();
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        Object name = null;
        if (accessor.getServerData().m_128425_("givenName", 8)) {
            name = Component.Serializer.m_130701_((String)accessor.getServerData().m_128461_("givenName"));
        }
        if (name == null && accessor.isFakeBlock()) {
            name = accessor.getFakeBlock().m_41786_();
        }
        if (name == null && WailaClientRegistration.INSTANCE.shouldPick(accessor.getBlockState()) && (pick = accessor.getPickedResult()) != null && !pick.m_41619_()) {
            name = pick.m_41786_();
        }
        if (name == null) {
            ItemStack pick2;
            String key = accessor.getBlock().m_7705_();
            name = I18n.m_118936_((String)key) ? accessor.getBlock().m_49954_() : ((pick2 = accessor.getPickedResult()) != null && !pick2.m_41619_() ? pick2.m_41786_() : Component.m_237113_((String)key));
        }
        tooltip.add((Component)IThemeHelper.get().title(name));
    }

    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Component name = ObjectNameProvider.getEntityName(accessor.getEntity());
        tooltip.add((Component)IThemeHelper.get().title(name));
    }

    @Override
    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof Nameable) {
            Nameable nameable = (Nameable)blockEntity;
            if (JadeCommonConfig.shouldShowCustomName(blockEntity) && nameable.m_8077_()) {
                data.m_128359_("givenName", Component.Serializer.m_130703_((Component)nameable.m_7770_()));
            }
        }
    }

    @Override
    public ResourceLocation getUid() {
        return Identifiers.CORE_OBJECT_NAME;
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public int getDefaultPriority() {
        return -10100;
    }
}

