/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.capability.itemhandler;

import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class ItemItemHandler
implements IItemHandlerModifiable {
    private final ItemStack itemStack;

    public ItemItemHandler(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    protected abstract NonNullList<ItemStack> getItemList();

    protected abstract void setItemList(NonNullList<ItemStack> var1);

    public void setStackInSlot(int slot, ItemStack stack) {
        NonNullList<ItemStack> itemStacks = this.getItemList();
        itemStacks.set(slot, (Object)stack);
        this.setItemList(itemStacks);
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return (ItemStack)this.getItemList().get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        NonNullList<ItemStack> itemStacks = this.getItemList();
        ItemStack existingStack = (ItemStack)itemStacks.get(slot);
        if (!existingStack.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existingStack)) {
                return stack;
            }
            int maxStackSize = Math.min(stack.m_41741_(), this.getSlotLimit(slot)) - existingStack.m_41613_();
            if (stack.m_41613_() <= maxStackSize) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(existingStack.m_41613_());
                    this.setStackInSlot(slot, copy);
                }
                return ItemStack.f_41583_;
            }
            stack = stack.m_41777_();
            if (!simulate) {
                ItemStack copy = stack.m_41620_(maxStackSize);
                copy.m_41769_(existingStack.m_41613_());
                this.setStackInSlot(slot, copy);
                return stack;
            }
            stack.m_41774_(maxStackSize);
            return stack;
        }
        int maxStackSize = Math.min(stack.m_41741_(), this.getSlotLimit(slot));
        if (maxStackSize < stack.m_41613_()) {
            stack = stack.m_41777_();
            if (!simulate) {
                this.setStackInSlot(slot, stack.m_41620_(maxStackSize));
                return stack;
            }
            stack.m_41774_(maxStackSize);
            return stack;
        }
        if (!simulate) {
            this.setStackInSlot(slot, stack);
        }
        return ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existingStack = this.getStackInSlot(slot);
        if (existingStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack extracted = existingStack.m_41620_(amount);
        if (!simulate) {
            this.setStackInSlot(slot, existingStack);
        }
        return extracted;
    }
}

