/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portablemobs;

import com.dremoline.portablemobs.PortableMobTypes;
import com.dremoline.portablemobs.PortableMobs;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseItem;
import com.supermartijn642.core.item.ItemProperties;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class PortableMobItem
extends BaseItem {
    public static final TagKey<EntityType<?>> BLACKLIST = TagKey.m_203882_((ResourceKey)ForgeRegistries.ENTITY_TYPES.getRegistryKey(), (ResourceLocation)new ResourceLocation("portablemobs", "capture_blacklist"));
    public final PortableMobTypes type;

    public PortableMobItem(PortableMobTypes type) {
        super(ItemProperties.create().maxStackSize(1).group((CreativeModeTab)PortableMobs.GROUP));
        this.type = type;
    }

    public BaseItem.InteractionFeedback interactWithBlock(ItemStack stack, Player player, InteractionHand hand, Level level, BlockPos hitPos, Direction hitSide, Vec3 hitLocation) {
        Entity living;
        Optional optional;
        CompoundTag compound = stack.m_41784_();
        if (compound.m_128471_("has_entity") && (optional = EntityType.m_20632_((String)compound.m_128461_("entity_type"))).isPresent() && (living = ((EntityType)optional.get()).m_20615_(level)) != null) {
            living.m_20258_(compound.m_128469_("entity_data"));
            BlockPos pos = hitPos.m_121945_(hitSide);
            living.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.01, (double)pos.m_123343_() + 0.5);
            level.m_7967_(living);
            if (this.type.reusable) {
                compound.m_128379_("has_entity", false);
            } else {
                player.m_21008_(hand, ItemStack.f_41583_);
            }
        }
        return super.interactWithBlock(stack, player, hand, level, hitPos, hitSide, hitLocation);
    }

    public BaseItem.InteractionFeedback interactWithEntity(ItemStack stack, LivingEntity target, Player player, InteractionHand hand) {
        CompoundTag compound = stack.m_41784_();
        if (!compound.m_128471_("has_entity")) {
            if (target instanceof Player) {
                if (player.m_9236_().f_46443_) {
                    player.m_213846_((Component)TextComponents.translation((String)"portablemobs.capture_failed_player").color(ChatFormatting.RED).get());
                } else {
                    PortableMobs.playerCaptureTrigger.m_222618_((ServerPlayer)player);
                }
            } else if (target.m_6095_().m_204039_(BLACKLIST)) {
                if (player.m_9236_().f_46443_) {
                    player.m_213846_((Component)TextComponents.translation((String)"portablemobs.capture_failed").color(ChatFormatting.RED).get());
                }
            } else {
                if (target.m_20159_()) {
                    target.m_8127_();
                }
                target.m_20153_();
                compound.m_128359_("entity_type", ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString());
                compound.m_128365_("entity_data", (Tag)target.m_20240_(new CompoundTag()));
                compound.m_128359_("entity_name", Component.Serializer.m_130703_((Component)TextComponents.entity((Entity)target).get()));
                compound.m_128379_("has_entity", true);
                target.m_142687_(Entity.RemovalReason.UNLOADED_TO_CHUNK);
                player.m_21008_(hand, stack);
                if (player.m_9236_().f_46443_) {
                    player.m_213846_((Component)TextComponents.translation((String)"portablemobs.capture_success").color(ChatFormatting.GREEN).get());
                } else {
                    PortableMobs.captureTrigger.m_222618_((ServerPlayer)player);
                }
                return BaseItem.InteractionFeedback.SUCCESS;
            }
        }
        return super.interactWithEntity(stack, target, player, hand);
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        CompoundTag compound = stack.m_41784_();
        if (compound.m_128471_("has_entity")) {
            MutableComponent entityName = TextComponents.fromTextComponent((MutableComponent)Component.Serializer.m_130701_((String)compound.m_128461_("entity_name"))).color(ChatFormatting.YELLOW).get();
            info.accept((Component)TextComponents.translation((String)"portablemobs.tooltip_name", (Object[])new Object[]{entityName}).color(ChatFormatting.WHITE).get());
        }
    }
}

