/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component;

import java.util.ArrayList;
import java.util.Iterator;
import journeymap.client.Constants;
import journeymap.client.ui.component.Button;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;

public class OnOffButton
extends Button {
    protected Boolean toggled = true;
    protected String labelOn;
    protected String labelOff;
    protected ArrayList<ToggleListener> toggleListeners = new ArrayList(0);

    public OnOffButton(String labelOn, String labelOff, boolean toggled, Button.OnPress onPress) {
        super(toggled ? labelOn : labelOff, onPress);
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.setToggled(toggled);
        this.finishInit();
    }

    public void setLabels(String labelOn, String labelOff) {
        this.labelOn = labelOn;
        this.labelOff = labelOff;
        this.updateLabel();
    }

    @Override
    protected void updateLabel() {
        if (this.labelOn != null && this.labelOff != null) {
            this.m_93666_((Component)Constants.getStringTextComponent(this.getToggled() != false ? this.labelOn : this.labelOff));
        }
    }

    public void toggle() {
        this.setToggled(this.getToggled() == false);
    }

    @Override
    public int getFitWidth(Font fr) {
        int max = fr.m_92895_(this.m_6035_().getString());
        if (this.labelOn != null) {
            max = Math.max(max, fr.m_92895_(this.labelOn));
        }
        if (this.labelOff != null) {
            max = Math.max(max, fr.m_92895_(this.labelOff));
        }
        return max + this.WIDTH_PAD;
    }

    @Override
    public boolean m_142518_() {
        return this.isEnabled() && this.toggled != false;
    }

    public Boolean getToggled() {
        return this.toggled;
    }

    public void setToggled(Boolean toggled) {
        this.setToggled(toggled, true);
    }

    public void setToggled(Boolean toggled, boolean notifyToggleListener) {
        if (this.toggled == toggled || !this.isEnabled() || !this.f_93624_) {
            return;
        }
        boolean allowChange = true;
        try {
            if (notifyToggleListener && !this.toggleListeners.isEmpty()) {
                ToggleListener listener;
                Iterator<ToggleListener> iterator2 = this.toggleListeners.iterator();
                while (iterator2.hasNext() && (allowChange = (listener = iterator2.next()).onToggle(this, toggled))) {
                }
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error trying to toggle button '" + this.m_6035_() + "': " + LogFormatter.toString(t));
            allowChange = false;
        }
        if (allowChange) {
            this.toggled = toggled;
            this.updateLabel();
        }
    }

    public void addToggleListener(ToggleListener toggleListener) {
        this.toggleListeners.add(toggleListener);
    }

    public static interface ToggleListener {
        public boolean onToggle(OnOffButton var1, boolean var2);
    }
}

