/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.network.packets;

import journeymap.common.Journeymap;
import journeymap.common.network.data.PacketContext;
import journeymap.common.network.data.Side;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class ServerAdminSavePropPacket {
    public static final ResourceLocation CHANNEL = new ResourceLocation("journeymap", "admin_save");
    private Integer type;
    private String payload;
    private String dimension;

    public ServerAdminSavePropPacket() {
    }

    public ServerAdminSavePropPacket(Integer type, String payload, String dimension) {
        this.payload = payload;
        this.type = type;
        this.dimension = dimension;
    }

    public int getType() {
        return this.type;
    }

    public String getPayload() {
        return this.payload;
    }

    public static ServerAdminSavePropPacket decode(FriendlyByteBuf buf) {
        ServerAdminSavePropPacket packet = new ServerAdminSavePropPacket();
        try {
            if (buf.readableBytes() > 1) {
                buf.readByte();
                packet.type = buf.readInt();
                packet.dimension = buf.m_130136_(Short.MAX_VALUE);
                packet.payload = buf.m_130136_(Short.MAX_VALUE);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(String.format("Failed to read message for admin save: %s", t));
        }
        return packet;
    }

    public void encode(FriendlyByteBuf buf) {
        try {
            if (this.payload != null && this.type != null && this.dimension != null) {
                buf.writeByte(42);
                buf.writeInt(this.type.intValue());
                buf.m_130070_(this.dimension);
                buf.m_130070_(this.payload);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("[toBytes]Failed to write message for admin save:" + t);
        }
    }

    public static void handle(PacketContext<ServerAdminSavePropPacket> ctx) {
        if (Side.SERVER.equals((Object)ctx.side())) {
            Journeymap.getInstance().getPacketHandler().onServerAdminSave(ctx.sender(), ctx.message().type, ctx.message().payload, ctx.message().dimension);
        }
    }
}

