/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.advancement.criterion;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandler;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;

public class VariableFacadePredicate<V extends IVariableFacade> {
    private static final IVariableFacadeHandlerRegistry VARIABLE_FACADE_HANDLER_REGISTRY = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
    public static final VariableFacadePredicate ANY = new VariableFacadePredicate<IVariableFacade>(IVariableFacade.class);
    private final Class<V> variableClass;

    public VariableFacadePredicate(Class<V> variableClass) {
        this.variableClass = variableClass;
    }

    public final boolean test(IVariableFacade variableFacade) {
        return this.variableClass.isInstance(variableFacade) && this.testTyped(variableFacade);
    }

    protected boolean testTyped(V variableFacade) {
        return true;
    }

    public static VariableFacadePredicate deserialize(ValueDeseralizationContext valueDeseralizationContext, @Nullable JsonElement element) {
        if (element != null && !element.isJsonNull()) {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)element, (String)"variable_facade");
            JsonElement typeElement = jsonobject.get("type");
            if (typeElement != null && !typeElement.isJsonNull()) {
                String type = GsonHelper.m_13906_((JsonObject)jsonobject, (String)"type");
                IVariableFacadeHandler handler = VARIABLE_FACADE_HANDLER_REGISTRY.getHandler(new ResourceLocation(type));
                if (handler == null) {
                    throw new JsonSyntaxException("Unknown variable type '" + type + "', valid types are: " + VARIABLE_FACADE_HANDLER_REGISTRY.getHandlerNames());
                }
                return handler.deserializeVariableFacadePredicate(valueDeseralizationContext, jsonobject);
            }
            return new VariableFacadePredicate<IVariableFacade>(IVariableFacade.class);
        }
        return ANY;
    }
}

