/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import net.minecraft.core.Direction;
import org.cyclops.integrateddynamics.api.part.PartPos;

public class PrioritizedPartPos
implements Comparable<PrioritizedPartPos> {
    private final PartPos partPos;
    private final int priority;

    private PrioritizedPartPos(PartPos partPos, int priority) {
        this.partPos = partPos;
        this.priority = priority;
    }

    @Override
    public int compareTo(PrioritizedPartPos o) {
        int compPriority = -Integer.compare(this.getPriority(), o.getPriority());
        if (compPriority == 0) {
            int compPos = this.getPartPos().getPos().compareTo(o.getPartPos().getPos());
            if (compPos == 0) {
                Direction thisSide = this.getPartPos().getSide();
                Direction otherSide = o.getPartPos().getSide();
                return thisSide == null ? -1 : (otherSide == null ? 1 : thisSide.compareTo((Enum)otherSide));
            }
            return compPos;
        }
        return compPriority;
    }

    public static PrioritizedPartPos of(PartPos pos, int priority) {
        return new PrioritizedPartPos(pos, priority);
    }

    public PartPos getPartPos() {
        return this.partPos;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean equals(Object obj) {
        return obj instanceof PrioritizedPartPos && this.compareTo((PrioritizedPartPos)obj) == 0;
    }

    public int hashCode() {
        return this.getPartPos().hashCode() + this.getPriority() << 1;
    }
}

