/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.blockentity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.CraftingHelpers;
import org.cyclops.cyclopscore.helper.FluidHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.Capabilities;
import org.cyclops.integrateddynamics.RegistryEntries;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezer;
import org.cyclops.integrateddynamics.block.BlockMechanicalSqueezerConfig;
import org.cyclops.integrateddynamics.core.blockentity.BlockEntityMechanicalMachine;
import org.cyclops.integrateddynamics.core.recipe.handler.RecipeHandlerSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeMechanicalSqueezer;
import org.cyclops.integrateddynamics.core.recipe.type.RecipeSqueezer;
import org.cyclops.integrateddynamics.inventory.container.ContainerMechanicalSqueezer;

public class BlockEntityMechanicalSqueezer
extends BlockEntityMechanicalMachine<ItemStack, RecipeMechanicalSqueezer>
implements MenuProvider {
    public static final int INVENTORY_SIZE = 5;
    private static final int SLOT_INPUT = 0;
    private static final int[] SLOTS_OUTPUT = new int[]{1, 2, 3, 4};
    private static final int TANK_SIZE = 100000;
    @NBTPersist
    private boolean autoEjectFluids = false;
    private final SingleUseTank tank = new SingleUseTank(100000);

    public BlockEntityMechanicalSqueezer(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_MECHANICAL_SQUEEZER, blockPos, blockState, 5);
        this.addCapabilityInternal(ForgeCapabilities.FLUID_HANDLER, LazyOptional.of(() -> this.tank));
        this.addCapabilityInternal(Capabilities.RECIPE_HANDLER, LazyOptional.of(() -> new RecipeHandlerSqueezer<RecipeMechanicalSqueezer>(() -> ((BlockEntityMechanicalSqueezer)this).m_58904_(), RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER)));
        this.tank.addDirtyMarkListener(this::onTankChanged);
    }

    @Override
    protected SingleCache.ICacheUpdater<ItemStack, Optional<RecipeMechanicalSqueezer>> createCacheUpdater() {
        return new SingleCache.ICacheUpdater<ItemStack, Optional<RecipeMechanicalSqueezer>>(){

            public Optional<RecipeMechanicalSqueezer> getNewValue(ItemStack key) {
                SimpleContainer recipeInput = new SimpleContainer(new ItemStack[]{key});
                return CraftingHelpers.findServerRecipe(BlockEntityMechanicalSqueezer.this.getRecipeRegistry(), (Container)recipeInput, (Level)BlockEntityMechanicalSqueezer.this.m_58904_());
            }

            public boolean isKeyEqual(ItemStack cacheKey, ItemStack newKey) {
                return ItemStack.m_41728_((ItemStack)cacheKey, (ItemStack)newKey);
            }
        };
    }

    @Override
    public int[] getInputSlots() {
        return new int[]{0};
    }

    @Override
    public int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    public boolean wasWorking() {
        return (Boolean)this.m_58904_().m_8055_(this.m_58899_()).m_61143_((Property)BlockMechanicalSqueezer.LIT);
    }

    @Override
    public void setWorking(boolean working) {
        this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.m_58899_()).m_61124_((Property)BlockMechanicalSqueezer.LIT, (Comparable)Boolean.valueOf(working)));
    }

    public SingleUseTank getTank() {
        return this.tank;
    }

    @Override
    public void read(CompoundTag tag) {
        super.read(tag);
        this.getTank().readFromNBT(tag.m_128469_("tank"));
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        tag.m_128365_("tank", (Tag)this.getTank().writeToNBT(new CompoundTag()));
        super.m_183515_(tag);
    }

    @Override
    protected RecipeType<RecipeMechanicalSqueezer> getRecipeRegistry() {
        return RegistryEntries.RECIPETYPE_MECHANICAL_SQUEEZER;
    }

    @Override
    protected ItemStack getCurrentRecipeCacheKey() {
        return this.getInventory().m_8020_(0).m_41777_();
    }

    @Override
    public int getRecipeDuration(RecipeMechanicalSqueezer recipe) {
        return recipe.getDuration();
    }

    @Override
    protected boolean finalizeRecipe(RecipeMechanicalSqueezer recipe, boolean simulate) {
        NonNullList outputStacks = NonNullList.m_122779_();
        for (RecipeSqueezer.IngredientChance itemStackChance : recipe.getOutputItems()) {
            ItemStack outputStack = itemStackChance.getIngredientFirst().m_41777_();
            if (outputStack.m_41619_() || !simulate && itemStackChance.getChance() != 1.0f && !(itemStackChance.getChance() >= this.m_58904_().f_46441_.m_188501_())) continue;
            InventoryHelpers.addStackToList((NonNullList)outputStacks, (ItemStack)outputStack);
        }
        if (!InventoryHelpers.addToInventory((Container)this.getInventory(), (int[])SLOTS_OUTPUT, (NonNullList)outputStacks, (boolean)simulate).isEmpty()) {
            return false;
        }
        FluidStack outputFluid = recipe.getOutputFluid();
        if (outputFluid != null && this.getTank().fill(outputFluid.copy(), FluidHelpers.simulateBooleanToAction((boolean)simulate)) != outputFluid.getAmount()) {
            return false;
        }
        if (!simulate) {
            this.getInventory().m_7407_(0, 1);
        }
        return true;
    }

    @Override
    public int getEnergyConsumptionRate() {
        return BlockMechanicalSqueezerConfig.consumptionRate;
    }

    public int getMaxEnergyStored() {
        return BlockMechanicalSqueezerConfig.capacity;
    }

    public boolean isAutoEjectFluids() {
        return this.autoEjectFluids;
    }

    public void setAutoEjectFluids(boolean autoEjectFluids) {
        this.autoEjectFluids = autoEjectFluids;
        this.sendUpdate();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerMechanicalSqueezer(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.integrateddynamics.mechanical_squeezer");
    }

    public static class Ticker
    extends BlockEntityMechanicalMachine.Ticker<ItemStack, RecipeMechanicalSqueezer, BlockEntityMechanicalSqueezer> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityMechanicalSqueezer blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            if (blockEntity.isAutoEjectFluids() && !blockEntity.getTank().isEmpty()) {
                for (Direction side : Direction.values()) {
                    IFluidHandler handler = (IFluidHandler)BlockEntityHelpers.getCapability((BlockGetter)level, (BlockPos)pos.m_121945_(side), (Direction)side.m_122424_(), (Capability)ForgeCapabilities.FLUID_HANDLER).orElse(null);
                    if (handler == null) continue;
                    FluidStack fluidStack = blockEntity.getTank().getFluid().copy();
                    fluidStack.setAmount(Math.min(BlockMechanicalSqueezerConfig.autoEjectFluidRate, fluidStack.getAmount()));
                    if (handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE) <= 0) continue;
                    blockEntity.getTank().drain(handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
                    break;
                }
            }
        }
    }
}

