/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.client.render.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.integrateddynamics.blockentity.BlockEntityDryingBasin;
import org.joml.Matrix4f;

public class RenderBlockEntityDryingBasin
implements BlockEntityRenderer<BlockEntityDryingBasin> {
    public RenderBlockEntityDryingBasin(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityDryingBasin tile, float partialTicks, PoseStack matrixStack, MultiBufferSource renderTypeBuffer, int combinedLight, int combinedOverlay) {
        if (tile != null) {
            if (!tile.getInventory().m_8020_(0).m_41619_()) {
                matrixStack.m_85836_();
                matrixStack.m_252880_(-0.5f, -0.5f, -0.5f);
                this.renderItem(matrixStack, renderTypeBuffer, tile.getInventory().m_8020_(0), tile.getRandomRotation(), tile.m_58904_());
                matrixStack.m_85849_();
            }
            FluidStack fluid = tile.getTank().getFluid();
            RenderHelpers.renderFluidContext((FluidStack)fluid, (PoseStack)matrixStack, () -> {
                float height = (float)((double)fluid.getAmount() * 0.7 / 1000.0 + 0.23 + 0.01);
                int brightness = Math.max(combinedLight, fluid.getFluid().getFluidType().getLightLevel(fluid));
                int l2 = brightness >> 16 & 0xFFFF;
                int i3 = brightness & 0xFFFF;
                TextureAtlasSprite icon = RenderHelpers.getFluidIcon((FluidStack)fluid, (Direction)Direction.UP);
                IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluid.getFluid());
                Triple color = Helpers.intToRGB((int)renderProperties.getTintColor(fluid));
                VertexConsumer vb = renderTypeBuffer.m_6299_(RenderType.m_110497_((ResourceLocation)icon.m_247685_()));
                Matrix4f matrix = matrixStack.m_85850_().m_252922_();
                vb.m_252986_(matrix, 0.0625f, height, 0.0625f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.0625f, height, 0.9375f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118409_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.9375f, height, 0.9375f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118411_()).m_7120_(l2, i3).m_5752_();
                vb.m_252986_(matrix, 0.9375f, height, 0.0625f).m_85950_(((Float)color.getLeft()).floatValue(), ((Float)color.getMiddle()).floatValue(), ((Float)color.getRight()).floatValue(), 1.0f).m_7421_(icon.m_118410_(), icon.m_118412_()).m_7120_(l2, i3).m_5752_();
            });
        }
    }

    private void renderItem(PoseStack matrixStack, MultiBufferSource renderTypeBuffer, ItemStack itemStack, float rotation, Level level) {
        BakedModel model = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, null, null, 0);
        if (model.m_7539_()) {
            matrixStack.m_252880_(1.0f, 1.2f, 1.0f);
            matrixStack.m_85841_(1.2f, 1.2f, 1.2f);
        } else {
            matrixStack.m_252880_(1.0f, 1.2f, 1.0f);
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(25.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(25.0f));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        }
        Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.f_118083_, matrixStack, renderTypeBuffer, level, 0);
    }
}

