/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.integrateddynamics.api.client.model.IVariableModelBaked;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.blockentity.BlockEntityProxy;
import org.cyclops.integrateddynamics.core.client.model.VariableModelProviders;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueHelpers;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.item.VariableFacadeBase;

public class ProxyVariableFacade
extends VariableFacadeBase
implements IProxyVariableFacade {
    private final int proxyId;
    private boolean isValidatingVariable = false;
    private boolean isGettingVariable = false;

    public ProxyVariableFacade(boolean generateId, int proxyId) {
        super(generateId);
        this.proxyId = proxyId;
    }

    public ProxyVariableFacade(int id, int proxyId) {
        super(id);
        this.proxyId = proxyId;
    }

    protected Optional<BlockEntityProxy> getProxy(IPartNetwork network) {
        DimPos dimPos = network.getProxy(this.proxyId);
        if (dimPos != null) {
            return BlockEntityHelpers.get((DimPos)dimPos, BlockEntityProxy.class);
        }
        return Optional.empty();
    }

    protected Optional<IVariable> getTargetVariable(IPartNetwork network) {
        return this.getProxy(network).map(tile -> tile.getVariable(network));
    }

    @Override
    public <V extends IValue> IVariable<V> getVariable(IPartNetwork network) {
        if (this.isValid()) {
            if (this.isGettingVariable) {
                throw new VariableRecursionException("Detected infinite recursion for variable references.");
            }
            this.isGettingVariable = true;
            IVariable variable = this.getTargetVariable(network).orElse(null);
            this.isGettingVariable = false;
            return variable;
        }
        return null;
    }

    @Override
    public boolean isValid() {
        return this.proxyId >= 0;
    }

    protected MutableComponent getProxyNotInNetworkError() {
        return Component.m_237110_((String)"proxy.integrateddynamics.error.proxy_not_in_network", (Object[])new Object[]{Integer.toString(this.proxyId)});
    }

    protected MutableComponent getProxyInvalidError() {
        return Component.m_237110_((String)"proxy.integrateddynamics.error.proxy_invalid", (Object[])new Object[]{Integer.toString(this.proxyId)});
    }

    protected MutableComponent getProxyInvalidTypeError(IPartNetwork network, IValueType containingValueType, IValueType actualType) {
        return Component.m_237110_((String)"proxy.integrateddynamics.error.proxy_invalid_type", (Object[])new Object[]{Integer.toString(this.proxyId), Component.m_237115_((String)containingValueType.getTranslationKey()), Component.m_237115_((String)actualType.getTranslationKey())});
    }

    @Override
    public void validate(IPartNetwork network, IVariableFacade.IValidator validator, IValueType containingValueType) {
        Optional<IVariable> targetVariable = this.getTargetVariable(network);
        if (!this.isValid()) {
            validator.addError(Component.m_237115_((String)"variable.integrateddynamics.error.invalid_item"));
        } else if (network.getProxy(this.proxyId) == null) {
            validator.addError(this.getProxyNotInNetworkError());
        } else if (!targetVariable.isPresent()) {
            validator.addError(this.getProxyInvalidError());
        } else if (!ValueHelpers.correspondsTo(containingValueType, targetVariable.get().getType())) {
            validator.addError(this.getProxyInvalidTypeError(network, containingValueType, targetVariable.get().getType()));
        }
        if (this.isValidatingVariable) {
            throw new VariableRecursionException("Detected infinite recursion for variable references.");
        }
        this.isValidatingVariable = true;
        this.getVariable(network);
        this.isValidatingVariable = false;
    }

    @Override
    public IValueType getOutputType() {
        return ValueTypes.CATEGORY_ANY;
    }

    protected Component getProxyTooltip() {
        return Component.m_237110_((String)"proxy.integrateddynamics.tooltip.proxy_id", (Object[])new Object[]{this.proxyId});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(List<Component> list, Level world) {
        if (this.isValid()) {
            list.add(this.getProxyTooltip());
        }
        super.appendHoverText(list, world);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addModelOverlay(IVariableModelBaked variableModelBaked, List<BakedQuad> quads, RandomSource random, ModelData modelData) {
        if (this.isValid()) {
            quads.addAll(variableModelBaked.getSubModels(VariableModelProviders.PROXY).getBakedModel().getQuads(null, null, random, modelData, null));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProxyVariableFacade)) {
            return false;
        }
        ProxyVariableFacade other = (ProxyVariableFacade)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getProxyId() != other.getProxyId()) {
            return false;
        }
        if (this.isValidatingVariable() != other.isValidatingVariable()) {
            return false;
        }
        return this.isGettingVariable() == other.isGettingVariable();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProxyVariableFacade;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getProxyId();
        result = result * 59 + (this.isValidatingVariable() ? 79 : 97);
        result = result * 59 + (this.isGettingVariable() ? 79 : 97);
        return result;
    }

    @Override
    public int getProxyId() {
        return this.proxyId;
    }

    public boolean isValidatingVariable() {
        return this.isValidatingVariable;
    }

    public boolean isGettingVariable() {
        return this.isGettingVariable;
    }

    public void setValidatingVariable(boolean isValidatingVariable) {
        this.isValidatingVariable = isValidatingVariable;
    }

    public void setGettingVariable(boolean isGettingVariable) {
        this.isGettingVariable = isGettingVariable;
    }

    @Override
    public String toString() {
        return "ProxyVariableFacade(proxyId=" + this.getProxyId() + ", isValidatingVariable=" + this.isValidatingVariable() + ", isGettingVariable=" + this.isGettingVariable() + ")";
    }

    public static class VariableRecursionException
    extends IllegalArgumentException {
        public VariableRecursionException(String msg) {
            super(msg);
        }
    }
}

