/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonCheckbox;
import org.cyclops.cyclopscore.client.gui.component.button.ButtonImage;
import org.cyclops.cyclopscore.client.gui.image.IImage;
import org.cyclops.cyclopscore.client.gui.image.Images;
import org.cyclops.cyclopscore.helper.GuiHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.client.gui.container.ContainerScreenLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.client.gui.IDropdownEntry;
import org.cyclops.integrateddynamics.core.client.gui.WidgetTextFieldDropdown;
import org.cyclops.integrateddynamics.core.ingredient.ItemMatchProperties;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeRecipeLPElement;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;

@OnlyIn(value=Dist.CLIENT)
class ValueTypeRecipeLPElementPropertiesSubGui
extends RenderPattern<ValueTypeRecipeLPElement, ContainerScreenLogicProgrammerBase, ContainerLogicProgrammerBase> {
    private final int slotId;
    private ButtonCheckbox inputNbt;
    private ButtonCheckbox inputTags;
    private ButtonCheckbox inputReusable;
    private WidgetTextFieldDropdown<ResourceLocation> inputTagsDropdown;
    private ButtonImage inputSave;

    public ValueTypeRecipeLPElementPropertiesSubGui(ValueTypeRecipeLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, ContainerScreenLogicProgrammerBase gui, ContainerLogicProgrammerBase container, int slotId) {
        super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        this.slotId = slotId;
    }

    @Override
    public void init(int guiLeft, int guiTop) {
        super.init(guiLeft, guiTop);
        this.inputNbt = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 2, 20, 10, (Component)Component.m_237115_((String)"gui.integrateddynamics.recipe.strictnbt"), entry -> {
            if (this.inputNbt.isChecked()) {
                this.inputTags.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
        });
        this.inputReusable = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 12, 20, 10, (Component)Component.m_237115_((String)"gui.integrateddynamics.recipe.reusable"), entry -> {
            this.saveGuiToState();
            this.loadStateToGui();
        });
        this.inputTags = new ButtonCheckbox(guiLeft + this.getX() + 2, guiTop + this.getY() + 22, 20, 10, (Component)Component.m_237115_((String)"gui.integrateddynamics.recipe.tagvariants"), entry -> {
            if (this.inputTags.isChecked()) {
                this.inputNbt.setChecked(false);
            }
            this.saveGuiToState();
            this.loadStateToGui();
            if (this.inputTags.isChecked()) {
                this.inputTagsDropdown.m_93692_(true);
            }
        });
        this.inputTagsDropdown = new WidgetTextFieldDropdown(Minecraft.m_91087_().f_91062_, guiLeft + this.getX() + 2, guiTop + this.getY() + 33, 134, 14, (Component)Component.m_237115_((String)"gui.cyclopscore.search"), true, Sets.newHashSet());
        this.inputTagsDropdown.setDropdownEntryListener(entry -> this.saveGuiToState());
        this.inputTagsDropdown.m_94199_(64);
        this.inputTagsDropdown.setDropdownSize(4);
        this.inputTagsDropdown.m_94182_(false);
        this.inputTagsDropdown.m_94202_(0xFFFFFF);
        this.inputTagsDropdown.m_94190_(true);
        this.inputSave = new ButtonImage(guiLeft + this.getX() + 116, guiTop + this.getY() + 72, (Component)Component.m_237115_((String)"gui.integrateddynamics.button.save"), button -> {
            if (!this.inputTags.isChecked() || this.inputTagsDropdown.getSelectedDropdownPossibility() != null) {
                ((ValueTypeRecipeLPElement)this.element).lastGui.setRecipeSubGui();
            } else {
                this.inputTagsDropdown.m_93692_(true);
            }
        }, (IImage)Images.OK);
        this.loadStateToGui();
        if (this.inputTags.isChecked()) {
            this.inputTagsDropdown.m_93692_(true);
        }
    }

    public ItemStack getSlotContents() {
        return ((Slot)((ContainerLogicProgrammerBase)this.container).f_38839_.get(this.slotId + 4)).m_7993_();
    }

    public ItemMatchProperties getSlotProperties() {
        return (ItemMatchProperties)((ValueTypeRecipeLPElement)this.getElement()).getInputStacks().get(this.slotId);
    }

    private Set<IDropdownEntry<ResourceLocation>> getDropdownEntries() {
        LinkedHashSet set = Sets.newLinkedHashSet();
        if (this.getSlotContents().m_41619_()) {
            ForgeRegistries.ITEMS.tags().getTagNames().forEach(registeredTag -> set.add(new DropdownEntry(registeredTag.f_203868_())));
        } else {
            ForgeRegistries.ITEMS.tags().getReverseTag((Object)this.getSlotContents().m_41720_()).ifPresent(reverseTag -> reverseTag.getTagKeys().forEach(registeredTag -> set.add(new DropdownEntry(registeredTag.f_203868_()))));
        }
        return set;
    }

    public void loadStateToGui() {
        ItemMatchProperties props = this.getSlotProperties();
        this.inputNbt.setChecked(props.isNbt());
        this.inputTags.setChecked(props.getItemTag() != null);
        this.inputReusable.setChecked(props.isReusable());
        this.inputTagsDropdown.m_94194_(this.inputTags.isChecked());
        if (this.inputTags.isChecked()) {
            Set dropdownEntries = this.getDropdownEntries();
            this.inputTagsDropdown.setPossibilities(dropdownEntries);
            if (props.getItemTag() != null) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.stream().filter(e -> e.getMatchString().equals(props.getItemTag())).findFirst().orElse(null));
            } else if (!dropdownEntries.isEmpty()) {
                this.inputTagsDropdown.selectPossibility(dropdownEntries.iterator().next());
            } else {
                this.inputTagsDropdown.selectPossibility(null);
            }
        } else {
            this.inputTagsDropdown.m_94144_("");
            this.inputTagsDropdown.setPossibilities(Collections.emptySet());
        }
    }

    public void saveGuiToState() {
        boolean nbt = this.inputNbt.isChecked();
        String tag = this.inputTags.isChecked() ? this.inputTagsDropdown.m_94155_() : null;
        this.getSlotProperties().setNbt(nbt);
        this.getSlotProperties().setItemTag(tag);
        this.getSlotProperties().setReusable(this.inputReusable.isChecked());
        ((ValueTypeRecipeLPElement)this.element).sendSlotPropertiesToServer(this.slotId, this.getSlotProperties());
    }

    @Override
    protected boolean drawRenderPattern() {
        return false;
    }

    @Override
    public void renderBg(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, float partialTicks, int mouseX, int mouseY) {
        super.renderBg(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
        this.drawSlot(guiGraphics, this.getX() + guiLeft + 116, this.getY() + guiTop + 2);
        this.inputNbt.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        fontRenderer.m_271703_(L10NHelpers.localize((String)"gui.integrateddynamics.recipe.strictnbt", (Object[])new Object[0]), (float)(guiLeft + this.getX() + 24), (float)(guiTop + this.getY() + 3), 0, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.inputReusable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        fontRenderer.m_271703_(L10NHelpers.localize((String)"gui.integrateddynamics.recipe.reusable", (Object[])new Object[0]), (float)(guiLeft + this.getX() + 24), (float)(guiTop + this.getY() + 13), 0, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.inputTags.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        fontRenderer.m_271703_(L10NHelpers.localize((String)"gui.integrateddynamics.recipe.tagvariants", (Object[])new Object[0]), (float)(guiLeft + this.getX() + 24), (float)(guiTop + this.getY() + 23), 0, false, guiGraphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)guiGraphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
        this.inputSave.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.inputTagsDropdown.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void drawGuiContainerForegroundLayer(GuiGraphics guiGraphics, int guiLeft, int guiTop, TextureManager textureManager, Font fontRenderer, int mouseX, int mouseY) {
        int i;
        super.drawGuiContainerForegroundLayer(guiGraphics, guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
        if (this.inputTagsDropdown.m_93696_() && (i = this.inputTagsDropdown.getHoveredVisiblePossibility(mouseX, mouseY)) >= 0) {
            IDropdownEntry<ResourceLocation> hoveredPossibility = this.inputTagsDropdown.getVisiblePossibility(i);
            this.drawTagsTooltip(guiGraphics, hoveredPossibility, guiLeft, guiTop, mouseX + 10, mouseY - 20, 6, GuiHelpers.SLOT_SIZE);
        }
    }

    protected void drawTagsTooltip(GuiGraphics guiGraphics, IDropdownEntry<ResourceLocation> hoveredPossibility, int guiLeft, int guiTop, int mouseX, int mouseY, int columns, int offset) {
        int x = mouseX - guiLeft;
        int y = mouseY - guiTop;
        List items = ForgeRegistries.ITEMS.tags().getTag(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)hoveredPossibility.getValue())).stream().toList();
        GuiHelpers.drawTooltipBackground((PoseStack)guiGraphics.m_280168_(), (int)x, (int)y, (int)(Math.min(items.size(), columns) * offset), (int)(((items.size() % columns == 0 ? 0 : 1) + items.size() / columns) * offset));
        int passed = 0;
        for (Item item : items) {
            guiGraphics.m_280480_(new ItemStack((ItemLike)item), x, y);
            x += offset;
            if (passed++ % columns != columns - 1) continue;
            y += offset;
            x = mouseX - guiLeft;
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        if (this.inputTagsDropdown.m_93696_() && this.inputTagsDropdown.m_5534_(typedChar, keyCode)) {
            return true;
        }
        return super.charTyped(typedChar, keyCode);
    }

    @Override
    public boolean keyPressed(int typedChar, int keyCode, int modifiers) {
        if (this.inputTagsDropdown.m_93696_()) {
            this.inputTagsDropdown.m_7933_(typedChar, keyCode, modifiers);
            return true;
        }
        return super.keyPressed(typedChar, keyCode, modifiers);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return this.inputNbt.m_6375_(mouseX, mouseY, mouseButton) || this.inputReusable.m_6375_(mouseX, mouseY, mouseButton) || this.inputTags.m_6375_(mouseX, mouseY, mouseButton) || this.inputTagsDropdown.m_6375_(mouseX, mouseY, mouseButton) || this.inputSave.m_6375_(mouseX, mouseY, mouseButton) || super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public static class DropdownEntry
    implements IDropdownEntry<ResourceLocation> {
        private final ResourceLocation tag;

        public DropdownEntry(ResourceLocation tag) {
            this.tag = tag;
        }

        @Override
        public String getMatchString() {
            return this.tag.toString();
        }

        @Override
        public MutableComponent getDisplayString() {
            return Component.m_237113_((String)this.tag.toString());
        }

        @Override
        public List<MutableComponent> getTooltip() {
            return Collections.emptyList();
        }

        @Override
        public ResourceLocation getValue() {
            return this.tag;
        }
    }
}

