/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.path;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.persist.nbt.INBTSerializable;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.path.IPathElement;
import org.cyclops.integrateddynamics.api.path.ISidedPathElement;
import org.cyclops.integrateddynamics.capability.path.PathElementConfig;
import org.cyclops.integrateddynamics.capability.path.SidedPathElement;

public class Cluster
implements Collection<ISidedPathElement>,
INBTSerializable {
    private final Set<ISidedPathElement> elements;

    public Cluster() {
        this.elements = Sets.newTreeSet();
    }

    public Cluster(TreeSet<ISidedPathElement> elements) {
        this.elements = elements;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        for (ISidedPathElement e : this.elements) {
            CompoundTag elementTag = new CompoundTag();
            elementTag.m_128359_("dimension", e.getPathElement().getPosition().getLevel());
            elementTag.m_128356_("pos", e.getPathElement().getPosition().getBlockPos().m_121878_());
            if (e.getSide() != null) {
                elementTag.m_128405_("side", e.getSide().ordinal());
            }
            list.add((Object)elementTag);
        }
        tag.m_128365_("list", (Tag)list);
        return tag;
    }

    public void fromNBT(CompoundTag tag) {
        ListTag list = tag.m_128437_("list", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag elementTag = list.m_128728_(i);
            ResourceLocation dimensionId = new ResourceLocation(elementTag.m_128461_("dimension"));
            ResourceKey dimension = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId);
            ServerLevel world = ServerLifecycleHooks.getCurrentServer().m_129880_(dimension);
            BlockPos pos = BlockPos.m_122022_((long)elementTag.m_128454_("pos"));
            Direction side = null;
            if (elementTag.m_128425_("side", 3)) {
                side = Direction.values()[elementTag.m_128451_("side")];
            }
            if (world == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at the invalid dimension id %s.", dimensionId));
                continue;
            }
            IPathElement pathElement = (IPathElement)BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)pos, (Direction)side, PathElementConfig.CAPABILITY).orElse(null);
            if (pathElement == null) {
                IntegratedDynamics.clog(Level.WARN, String.format("Skipped loading part from a network at position %s in world %s because it has no valid path element.", pos, dimensionId));
                continue;
            }
            this.elements.add(SidedPathElement.of(pathElement, side));
        }
    }

    public Set<ISidedPathElement> getElements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<ISidedPathElement> this$elements = this.getElements();
        Set<ISidedPathElement> other$elements = other.getElements();
        return !(this$elements == null ? other$elements != null : !((Object)this$elements).equals(other$elements));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Cluster;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<ISidedPathElement> $elements = this.getElements();
        result = result * 59 + ($elements == null ? 43 : ((Object)$elements).hashCode());
        return result;
    }

    public String toString() {
        return "Cluster(elements=" + this.getElements() + ")";
    }

    @Override
    public int size() {
        return this.getElements().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getElements().isEmpty();
    }

    @Override
    public boolean contains(Object arg0) {
        return this.getElements().contains(arg0);
    }

    @Override
    public Iterator<ISidedPathElement> iterator() {
        return this.getElements().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.getElements().toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.getElements().toArray(arg0);
    }

    @Override
    public boolean add(ISidedPathElement arg0) {
        return this.getElements().add(arg0);
    }

    @Override
    public boolean remove(Object arg0) {
        return this.getElements().remove(arg0);
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.getElements().containsAll(arg0);
    }

    @Override
    public boolean addAll(Collection<? extends ISidedPathElement> arg0) {
        return this.getElements().addAll(arg0);
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        return this.getElements().retainAll(arg0);
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        return this.getElements().removeAll(arg0);
    }

    @Override
    public void clear() {
        this.getElements().clear();
    }

    @Override
    public Spliterator<ISidedPathElement> spliterator() {
        return this.getElements().spliterator();
    }

    @Override
    public <T> T[] toArray(IntFunction<T[]> generator) {
        return this.getElements().toArray(generator);
    }

    @Override
    public boolean removeIf(Predicate<? super ISidedPathElement> filter) {
        return this.getElements().removeIf(filter);
    }

    @Override
    public Stream<ISidedPathElement> stream() {
        return this.getElements().stream();
    }

    @Override
    public Stream<ISidedPathElement> parallelStream() {
        return this.getElements().parallelStream();
    }

    @Override
    public void forEach(Consumer<? super ISidedPathElement> action) {
        this.getElements().forEach(action);
    }
}

