/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalcustomization.create;

import com.blakebr0.cucumber.helper.ParsingHelper;
import com.blakebr0.mysticalagriculture.api.soul.MobSoulType;
import com.blakebr0.mysticalcustomization.loader.MobSoulTypeLoader;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;

public final class MobSoulTypeCreator {
    public static MobSoulType create(ResourceLocation id, JsonObject json) throws JsonSyntaxException {
        float souls = GsonHelper.m_13915_((JsonObject)json, (String)"souls");
        MobSoulType type = new MobSoulType(id, (Set)Sets.newHashSet(), null, (double)souls, -1);
        if (json.has("entity")) {
            String entityId = GsonHelper.m_13906_((JsonObject)json, (String)"entity");
            ResourceLocation entity2 = new ResourceLocation(entityId);
            MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.put(type, Lists.newArrayList((Object[])new ResourceLocation[]{entity2}));
        } else if (json.has("entities")) {
            JsonArray entityIds = GsonHelper.m_13933_((JsonObject)json, (String)"entities");
            ArrayList entities = new ArrayList();
            entityIds.forEach(entity -> entities.add(new ResourceLocation(entity.getAsString())));
            MobSoulTypeLoader.ENTITY_ADDITIONS_MAP.put(type, entities);
        } else {
            throw new JsonSyntaxException("Missing 'entity' or 'entities' property");
        }
        if (json.has("color")) {
            String color = GsonHelper.m_13906_((JsonObject)json, (String)"color");
            int i = ParsingHelper.parseHex((String)color, (String)"color");
            type.setColor(i);
        }
        if (json.has("name")) {
            String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            type.setEntityDisplayName((Component)Component.m_237113_((String)name));
        }
        if (json.has("enabled")) {
            boolean enabled = GsonHelper.m_13912_((JsonObject)json, (String)"enabled");
            type.setEnabled(enabled);
        }
        return type;
    }
}

