/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.control;

import com.google.common.base.Preconditions;
import com.mojang.blaze3d.platform.GlStateManager;
import it.zerono.mods.zerocore.lib.client.gui.DesiredDimension;
import it.zerono.mods.zerocore.lib.client.gui.IControl;
import it.zerono.mods.zerocore.lib.client.gui.IWindow;
import it.zerono.mods.zerocore.lib.client.gui.ModContainerScreen;
import it.zerono.mods.zerocore.lib.client.gui.Padding;
import it.zerono.mods.zerocore.lib.client.gui.RichText;
import it.zerono.mods.zerocore.lib.client.gui.Theme;
import it.zerono.mods.zerocore.lib.client.gui.layout.ILayoutEngine;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import it.zerono.mods.zerocore.lib.data.Flags;
import it.zerono.mods.zerocore.lib.data.geometry.Point;
import it.zerono.mods.zerocore.lib.data.geometry.Rectangle;
import it.zerono.mods.zerocore.lib.data.gfx.Colour;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import java.awt.Dimension;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractControl
implements IControl {
    private final String _name;
    private final ModContainerScreen<? extends ModContainer> _gui;
    private final Flags<ControlFlags> _flags;
    private IControl _parent;
    private Rectangle _bounds;
    private Point _origin;
    private Dimension _desiredDimension;
    private Padding _padding;
    private ILayoutEngine.ILayoutEngineHint _layoutHint;
    private BiConsumer<AbstractControl, GuiGraphics> _backgroundPainter;
    private int _tabOrder;
    private List<Component> _tooltipsLines;
    private List<Object> _tooltipsObjects;
    private RichText _tooltipsRichText;
    private IControl _tooltipsSource;
    private Object _tag;

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ModContainerScreen<? extends ModContainer> getGui() {
        return this._gui;
    }

    @Override
    public Optional<IControl> findControl(int x, int y) {
        return this.hitTest(x, y) ? Optional.of(this) : Optional.empty();
    }

    @Override
    public Optional<IControl> findControl(String name) {
        return this._name.equalsIgnoreCase(name) ? Optional.of(this) : Optional.empty();
    }

    @Override
    public boolean containsControl(IControl control) {
        return this == control;
    }

    @Override
    public Optional<IControl> getParent() {
        return Optional.ofNullable(this._parent);
    }

    @Override
    public void setParent(@Nullable IControl parent) {
        this._parent = parent;
        this.setControlOrigin(null != parent ? parent.getOrigin().offset(parent.getBounds().Origin) : Point.ZERO);
    }

    @Override
    public Rectangle getBounds() {
        return null != this._bounds ? this._bounds : Rectangle.ZERO;
    }

    @Override
    public void setBounds(Rectangle bounds) {
        this._bounds = bounds;
        this.onMoved();
    }

    @Override
    public Point getOrigin() {
        return this._origin;
    }

    @Override
    public int getDesiredDimension(DesiredDimension dimension) {
        if (null == this._desiredDimension) {
            return -1;
        }
        return DesiredDimension.Width == dimension ? this._desiredDimension.width : this._desiredDimension.height;
    }

    @Override
    public void setDesiredDimension(DesiredDimension dimension, int value) {
        if (null == this._desiredDimension) {
            this._desiredDimension = new Dimension(-1, -1);
        }
        switch (dimension) {
            case Width: {
                this._desiredDimension.width = value;
                break;
            }
            case Height: {
                this._desiredDimension.height = value;
            }
        }
    }

    @Override
    public void setDesiredDimension(int width, int height) {
        if (null == this._desiredDimension) {
            this._desiredDimension = new Dimension(width, height);
        } else {
            this._desiredDimension.width = width;
            this._desiredDimension.height = height;
        }
    }

    @Override
    public Padding getPadding() {
        return this._padding;
    }

    @Override
    public void setPadding(int left, int right, int top, int bottom) {
        this._padding = Padding.get(left, right, top, bottom);
    }

    @Override
    public Optional<ILayoutEngine.ILayoutEngineHint> getLayoutEngineHint() {
        return Optional.ofNullable(this._layoutHint);
    }

    @Override
    public void setLayoutEngineHint(ILayoutEngine.ILayoutEngineHint hint) {
        this._layoutHint = hint;
    }

    @Override
    public boolean hitTest(int x, int y) {
        return this.getBounds().contains(x, y);
    }

    @Override
    public void translate(int xOffset, int yOffset) {
        this.getBounds().offset(xOffset, yOffset);
        this.onMoved();
    }

    @Override
    public boolean getVisible() {
        return this._flags.contains(ControlFlags.Visible);
    }

    @Override
    public void setVisible(boolean visible) {
        this._flags.set(ControlFlags.Visible, visible);
    }

    @Override
    public boolean getEnabled() {
        return this._flags.contains(ControlFlags.Enabled);
    }

    @Override
    public void setEnabled(boolean enabled) {
        this._flags.set(ControlFlags.Enabled, enabled);
    }

    @Override
    public boolean canAcceptFocus() {
        return true;
    }

    @Override
    public int getTabOrder() {
        return this._tabOrder;
    }

    @Override
    public void setTabOrder(int position) {
        this._tabOrder = position;
    }

    @Override
    public boolean getMouseOver() {
        return this._flags.contains(ControlFlags.MouseOver);
    }

    @Override
    public void setMouseOver(boolean over, int mouseX, int mouseY) {
        this._flags.set(ControlFlags.MouseOver, over);
    }

    @Override
    public void setBackground(ISprite sprite) {
        this.setCustomBackgroundHandler((control, gfx) -> control.paintSprite((GuiGraphics)gfx, sprite, 0, 0, this.getWidth(), this.getHeight()));
    }

    @Override
    public void setBackground(Colour solidColour) {
        this.setCustomBackgroundHandler((control, gfx) -> control.paintSolidRect((GuiGraphics)gfx, 0, 0, control.getBounds().Width, control.getBounds().Height, solidColour));
    }

    @Override
    public void setBackground(Colour startColour, Colour endColour) {
        this.setCustomBackgroundHandler(this.getDesiredDimension(DesiredDimension.Height) > this.getDesiredDimension(DesiredDimension.Width) ? (c, matrix) -> c.paintHorizontalGradientRect((GuiGraphics)matrix, startColour, endColour) : (c, matrix) -> c.paintVerticalGradientRect((GuiGraphics)matrix, startColour, endColour));
    }

    @Override
    public void clearBackground() {
        this._backgroundPainter = (control, matrix) -> {};
    }

    @Override
    public List<Component> getTooltips() {
        return this._tooltipsLines;
    }

    @Override
    public List<Object> getTooltipsObjects() {
        return this._tooltipsObjects;
    }

    @Override
    public void paintToolTips(GuiGraphics gfx, int screenX, int screenY) {
        RichText rich = this.getTooltipsRichText();
        if (rich.isEmpty()) {
            return;
        }
        int borderSize = 5;
        Rectangle richBounds = rich.bounds();
        Rectangle boxBounds = richBounds.expand(10, 10).offset(screenX + 4, screenY + 8).fit(this.getGui().getScreenRectPadded());
        Colour bk = Colour.fromARGB(-267386864);
        Colour highlight1 = Colour.fromARGB(1344798847);
        Colour highlight2 = Colour.fromARGB(0x505000FF);
        int z = 900;
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX1(), boxBounds.getY1() + 1, boxBounds.Height - 2, 900, bk);
        ModRenderHelper.paintSolidRect(gfx, boxBounds.getX1() + 1, boxBounds.getY1(), boxBounds.getX2(), boxBounds.getY2() + 1, 900, bk);
        ModRenderHelper.paintVerticalLine(gfx, boxBounds.getX2(), boxBounds.getY1() + 1, boxBounds.Height - 2, 900, bk);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX1() + 1, boxBounds.getY1() + 1, boxBounds.Height - 2, 900.0, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY1() + 1, boxBounds.Width - 4, 900.0, highlight1, highlight2);
        ModRenderHelper.paintHorizontalGradientLine(gfx, boxBounds.getX1() + 2, boxBounds.getY2() - 1, boxBounds.Width - 4, 900.0, highlight1, highlight2);
        ModRenderHelper.paintVerticalGradientLine(gfx, boxBounds.getX2() - 1, boxBounds.getY1() + 1, boxBounds.Height - 2, 900.0, highlight1, highlight2);
        rich.paint(gfx, boxBounds.getX1() + 5, boxBounds.getY1() + 5, 900);
    }

    @Override
    public void setTooltips(List<Component> lines) {
        this._tooltipsLines = lines.isEmpty() ? Collections.emptyList() : lines;
        this._tooltipsObjects = Collections.emptyList();
        this._tooltipsRichText = null;
    }

    @Override
    public void setTooltips(List<Component> lines, List<Object> objects) {
        this._tooltipsLines = lines.isEmpty() ? Collections.emptyList() : lines;
        this._tooltipsObjects = lines.isEmpty() || objects.isEmpty() ? Collections.emptyList() : objects;
        this._tooltipsRichText = null;
    }

    @Override
    public void useTooltipsFrom(@Nullable IControl control) {
        this._tooltipsSource = control;
    }

    @Override
    public Point controlToScreen(int x, int y) {
        Point boundsOrigin = this.getBounds().Origin;
        Point origin = this.getOrigin();
        return new Point(x + boundsOrigin.X + origin.X, y + boundsOrigin.Y + origin.Y);
    }

    @Override
    public void controlToScreen(double[] xs, double[] ys) {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("The coordinates arrays must be of the same size.");
        }
        double deltaX = this.getBounds().Origin.X + this.getOrigin().X;
        double deltaY = this.getBounds().Origin.Y + this.getOrigin().Y;
        int i = 0;
        while (i < xs.length) {
            int n = i;
            xs[n] = xs[n] + deltaX;
            int n2 = i++;
            ys[n2] = ys[n2] + deltaY;
        }
    }

    @Override
    public Point screenToControl(int x, int y) {
        Point boundsOrigin = this.getBounds().Origin;
        Point origin = this.getOrigin();
        return new Point(Math.max(0, x - boundsOrigin.X - origin.X), Math.max(0, y - boundsOrigin.Y - origin.Y));
    }

    @Override
    public void screenToControl(double[] xs, double[] ys) {
        if (xs.length != ys.length) {
            throw new IllegalArgumentException("The coordinates arrays must be of the same size.");
        }
        double deltaX = this.getBounds().Origin.X + this.getOrigin().X;
        double deltaY = this.getBounds().Origin.Y + this.getOrigin().Y;
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = Math.max(0.0, xs[i] - deltaX);
            ys[i] = Math.max(0.0, ys[i] - deltaY);
        }
    }

    @Override
    public <Tag> Optional<Tag> getTag() {
        return Optional.ofNullable(this._tag);
    }

    @Override
    public <Tag> void setTag(@Nullable Tag tag) {
        this._tag = tag;
    }

    @Override
    public Theme getTheme() {
        return this._gui.getTheme();
    }

    @Override
    public boolean onMouseMoved(IWindow wnd, int mouseX, int mouseY) {
        return false;
    }

    @Override
    public boolean onMouseClicked(IWindow wnd, int mouseX, int mouseY, int clickedButton) {
        this.acquireFocus(wnd);
        return true;
    }

    @Override
    public boolean onMouseReleased(IWindow wnd, int mouseX, int mouseY, int releasedButton) {
        return false;
    }

    @Override
    public boolean onMouseDragged(IWindow wnd, int mouseX, int mouseY, int clickedButton, long timeSinceLastClick) {
        return false;
    }

    @Override
    public boolean onMouseWheel(IWindow wnd, int mouseX, int mouseY, double movement) {
        return false;
    }

    @Override
    public boolean onCharTyped(IWindow wnd, char typedChar, int keyCode) {
        return false;
    }

    @Override
    public boolean onKeyPressed(IWindow wnd, int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public boolean onKeyReleased(IWindow wnd, int keyCode, int scanCode, int modifiers) {
        return false;
    }

    @Override
    public void onSetFocus(IWindow wnd, @Nullable IControl previousFocus) {
        this._flags.add(ControlFlags.Focused);
    }

    @Override
    public void onKillFocus(IWindow wnd, @Nullable IControl newFocus) {
        this._flags.remove(ControlFlags.Focused);
    }

    @Override
    public void onWindowClosed() {
    }

    @Override
    public void onMoved() {
    }

    @Override
    public void onPaintBackground(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
        this._backgroundPainter.accept(this, gfx);
    }

    @Override
    public void onPaint(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
    }

    @Override
    public void onPaintOverlay(GuiGraphics gfx, float partialTicks, int mouseX, int mouseY) {
    }

    @Override
    public void enablePaintBlending(boolean blend) {
        this._flags.set(ControlFlags.BlendWhenPainting, blend);
    }

    @Override
    public void onPaintDebugFrame(GuiGraphics gfx, Colour colour) {
        this.paintHollowRect(gfx, 0, 0, this.getBounds().Width, this.getBounds().Height, colour);
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected void setCustomBackgroundHandler(BiConsumer<AbstractControl, GuiGraphics> handler) {
        this._backgroundPainter = (BiConsumer)Preconditions.checkNotNull(handler);
    }

    protected Rectangle getPaddingRect() {
        Padding padding = this.getPadding();
        return new Rectangle(padding.getLeft(), padding.getTop(), Math.max(0, this.getBounds().Width - padding.getLeft() - padding.getRight()), Math.max(0, this.getBounds().Height - padding.getTop() - padding.getBottom()));
    }

    protected float getZLevel() {
        return this.getGuiZLevel();
    }

    protected final RichText getTooltipsRichText() {
        List<Component> lines;
        if (null != this._tooltipsSource) {
            if (this._tooltipsSource instanceof AbstractControl) {
                return ((AbstractControl)this._tooltipsSource).getTooltipsRichText();
            }
            List<Component> lines2 = this._tooltipsSource.getTooltips();
            return lines2.isEmpty() ? RichText.EMPTY : AbstractControl.buildTooltipsRichText(lines2, this._tooltipsSource.getTooltipsObjects(), this.getTooltipsPopupMaxWidth());
        }
        if (null == this._tooltipsRichText && !(lines = this.getTooltips()).isEmpty()) {
            this._tooltipsRichText = AbstractControl.buildTooltipsRichText(lines, this.getTooltipsObjects(), this.getTooltipsPopupMaxWidth());
        }
        return null != this._tooltipsRichText ? this._tooltipsRichText : RichText.EMPTY;
    }

    private static RichText buildTooltipsRichText(List<Component> lines, List<Object> objects, int popupMaxWidth) {
        return RichText.builder(popupMaxWidth).textLines(lines).objects(objects).defaultColour(Colour.WHITE).build();
    }

    protected void setViewport(int x, int y, int width, int height) {
        double scale = this.getGui().getGuiScaleFactor();
        Point screenXY = this.controlToScreen(x, y + height);
        GlStateManager._viewport((int)((int)Math.round((double)screenXY.X * scale)), (int)(this.getGui().getMinecraftWindowHeight() - (int)Math.round((double)screenXY.Y * scale)), (int)((int)Math.round((double)width * scale)), (int)((int)Math.round((double)height * scale)));
    }

    protected void setViewport(Rectangle area) {
        this.setViewport(area.getX1(), area.getY1(), area.Width, area.Height);
    }

    protected void setViewport() {
        this.setViewport(0, 0, this.getBounds().Width, this.getBounds().Height);
    }

    protected void setDefaultViewport() {
        GlStateManager._viewport((int)0, (int)0, (int)this.getGui().getMinecraftWindowWidth(), (int)this.getGui().getMinecraftWindowHeight());
    }

    protected void playSound(SoundEvent sound) {
        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)sound, (float)1.0f));
    }

    protected void playSound(Holder<SoundEvent> sound) {
        this.playSound((SoundEvent)sound.m_203334_());
    }

    protected boolean shouldBlend() {
        return this._flags.contains(ControlFlags.BlendWhenPainting);
    }

    protected void paintSolidRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, Colour colour) {
        ModRenderHelper.paintSolidRect(gfx, this.controlToScreen(x1, y1), this.controlToScreen(x2, y2), (int)this.getZLevel(), colour);
    }

    protected void paintVerticalGradientRect(GuiGraphics gfx, Colour startColour, Colour endColour) {
        this.paintVerticalGradientRect(gfx, 0, 0, this.getBounds().Width, this.getBounds().Height, startColour, endColour);
    }

    protected void paintVerticalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, Colour startColour, Colour endColour) {
        Point screenXY1 = this.controlToScreen(x1, y1);
        Point screenXY2 = this.controlToScreen(x2, y2);
        ModRenderHelper.paintVerticalGradientRect(gfx, screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, this.getZLevel(), startColour, endColour);
    }

    protected void paintHorizontalGradientRect(GuiGraphics gfx, Colour startColour, Colour endColour) {
        this.paintHorizontalGradientRect(gfx, 0, 0, this.getBounds().Width, this.getBounds().Height, startColour, endColour);
    }

    protected void paintHorizontalGradientRect(GuiGraphics gfx, int x1, int y1, int x2, int y2, Colour startColour, Colour endColour) {
        Point screenXY1 = this.controlToScreen(x1, y1);
        Point screenXY2 = this.controlToScreen(x2, y2);
        ModRenderHelper.paintHorizontalGradientRect(gfx, screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, this.getZLevel(), startColour, endColour);
    }

    protected void paintHollowRect(GuiGraphics gfx, int x, int y, int width, int height, Colour colour) {
        ModRenderHelper.paintHollowRect(gfx, this.controlToScreen(x, y), width, height, (int)this.getZLevel(), colour);
    }

    protected void paintHorizontalLine(GuiGraphics gfx, int x, int y, int length, Colour colour) {
        ModRenderHelper.paintHorizontalLine(gfx, this.controlToScreen(x, y), length, (int)this.getZLevel(), colour);
    }

    protected void paintVerticalLine(GuiGraphics gfx, int x, int y, int length, Colour colour) {
        ModRenderHelper.paintVerticalLine(gfx, this.controlToScreen(x, y), length, (int)this.getZLevel(), colour);
    }

    protected void paintSprite(GuiGraphics gfx, ISprite sprite, int x, int y) {
        ModRenderHelper.paintSprite(gfx, sprite, this.controlToScreen(x, y), (int)this.getZLevel(), sprite.getWidth(), sprite.getHeight());
    }

    protected void paintSprite(GuiGraphics gfx, ISprite sprite, int x, int y, int width, int height) {
        ModRenderHelper.paintSprite(gfx, sprite, this.controlToScreen(x, y), (int)this.getZLevel(), width, height);
    }

    protected void paintButton3D(GuiGraphics gfx, int x, int y, int width, int height, Colour darkOutlineColour, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        if (gradientLightColour.equals(gradientDarkColour)) {
            ModRenderHelper.paintButton3D(gfx, this.controlToScreen(x, y), width, height, (int)this.getZLevel(), darkOutlineColour, gradientLightColour, borderLightColour, borderDarkColour);
        } else {
            ModRenderHelper.paintButton3D(gfx, this.controlToScreen(x, y), width, height, (int)this.getZLevel(), darkOutlineColour, gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
        }
    }

    protected void paint3DSunkenBox(GuiGraphics gfx, int x1, int y1, int x2, int y2, Colour gradientLightColour, Colour gradientDarkColour, Colour borderLightColour, Colour borderDarkColour) {
        Point screenXY1 = this.controlToScreen(x1, y1);
        Point screenXY2 = this.controlToScreen(x2, y2);
        if (gradientLightColour.equals(gradientDarkColour)) {
            ModRenderHelper.paint3DSunkenBox(gfx, screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, this.getZLevel(), gradientLightColour, borderLightColour, borderDarkColour);
        } else {
            ModRenderHelper.paint3DSunkenBox(gfx, screenXY1.X, screenXY1.Y, screenXY2.X, screenXY2.Y, this.getZLevel(), gradientLightColour, gradientDarkColour, borderLightColour, borderDarkColour);
        }
    }

    protected void paintItemStack(GuiGraphics gfx, ItemStack stack, boolean highlight) {
        this.paintItemStack(gfx, stack, 0, 0, highlight);
    }

    protected void paintItemStack(GuiGraphics gfx, ItemStack stack, int x, int y, boolean highlight) {
        Point screenXY = this.controlToScreen(x, y);
        ModRenderHelper.paintItemStack(gfx, stack, screenXY.X, screenXY.Y, "", highlight);
    }

    protected void paintItemStackWithCount(GuiGraphics gfx, ItemStack stack, boolean highlight) {
        this.paintItemStackWithCount(gfx, stack, 0, 0, highlight);
    }

    protected void paintItemStackWithCount(GuiGraphics gfx, ItemStack stack, int x, int y, boolean highlight) {
        Point screenXY = this.controlToScreen(x, y);
        ModRenderHelper.paintItemStackWithCount(gfx, stack, screenXY.X, screenXY.Y, highlight);
    }

    protected StringBuilder toStringBuilder() {
        return new StringBuilder().append("id:").append(this.getName()).append(" flags:").append(this._flags);
    }

    protected int nextGenericId() {
        return this.getGui().nextGenericId();
    }

    protected String nextGenericName() {
        return this.getGui().nextGenericName();
    }

    protected void enqueueTask(Runnable runnable) {
        this.getGui().enqueueTask(runnable);
    }

    protected AbstractControl(ModContainerScreen<? extends ModContainer> gui) {
        this(gui, gui.nextGenericName());
    }

    protected AbstractControl(ModContainerScreen<? extends ModContainer> gui, String name) {
        this._name = name;
        this._gui = gui;
        this._flags = new Flags<ControlFlags>(ControlFlags.class);
        this._parent = null;
        this._bounds = null;
        this._origin = Point.ZERO;
        this._desiredDimension = null;
        this._padding = Padding.ZERO;
        this._layoutHint = null;
        this._tabOrder = -1;
        this._tooltipsLines = Collections.emptyList();
        this._tooltipsObjects = Collections.emptyList();
        this._tooltipsRichText = null;
        this._tag = null;
        this.clearBackground();
        this.setVisible(true);
        this._flags.add(ControlFlags.Enabled);
    }

    protected void requestTickUpdates(Runnable handler) {
        this.getGui().requestTickUpdates(handler);
    }

    protected float getGuiZLevel() {
        return this._gui.getZLevel();
    }

    protected final boolean hasFocus() {
        return this._flags.contains(ControlFlags.Focused);
    }

    protected void acquireFocus(IWindow wnd) {
        if (this.canAcceptFocus()) {
            wnd.setFocus(this);
        }
    }

    protected void setControlOrigin(Point origin) {
        this._origin = origin;
        this.onMoved();
    }

    private static enum ControlFlags {
        Visible,
        Enabled,
        MouseOver,
        Focused,
        BlendWhenPainting;

    }
}

