/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data;

import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.EnumIndexer;

public class EnumIndexerSelection<Index extends Enum<Index>> {
    private final EnumIndexer<Index> _indexer;
    private final int _validIndicesCount;
    private int _selected;

    public EnumIndexerSelection(EnumIndexer<Index> indexer) {
        this._indexer = indexer;
        this._validIndicesCount = this._indexer.validIndicesCount();
        this._selected = 0;
    }

    public Index selectNext() {
        this._selected = CodeHelper.positiveModulo(this._selected + 1, this._validIndicesCount);
        return this.getSelection();
    }

    public Index selectPrevious() {
        this._selected = CodeHelper.positiveModulo(this._selected - 1, this._validIndicesCount);
        return this.getSelection();
    }

    public Index getSelection() {
        return (Index)((Enum)this._indexer.getIndex(this._selected).orElseThrow(ArrayIndexOutOfBoundsException::new));
    }

    public void setSelection(Index selection) {
        if (!this._indexer.isIndexValid(selection)) {
            throw new IllegalArgumentException("The new selected value is not valid");
        }
        this._selected = this._indexer.getOrdinal(selection);
    }
}

