/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.datagen.provider.tag;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;

public class ModTagAppender<T> {
    private final TagBuilder _builder;
    private final Set<ResourceLocation> _addedElements;
    private final Set<ResourceLocation> _addedOptionalElements;
    private final Set<ResourceLocation> _addedTags;
    private final Set<ResourceLocation> _addedOptionalTags;

    public ModTagAppender(TagBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"Builder must not be null");
        this._builder = builder;
        this._addedElements = new ObjectArraySet(128);
        this._addedOptionalElements = new ObjectArraySet(128);
        this._addedTags = new ObjectArraySet(128);
        this._addedOptionalTags = new ObjectArraySet(128);
    }

    public ModTagAppender<T> add(ResourceKey<T> element) {
        Preconditions.checkNotNull(element, (Object)"Element must not be null");
        ResourceLocation id = element.m_135782_();
        Preconditions.checkState((boolean)this._addedElements.add(id), (String)"The element with ID %s was already added to this tag", (Object)id);
        this._builder.m_215900_(id);
        return this;
    }

    public ModTagAppender<T> addOptional(ResourceLocation optionalElement) {
        Preconditions.checkNotNull((Object)optionalElement, (Object)"Optional element must not be null");
        Preconditions.checkState((boolean)this._addedOptionalElements.add(optionalElement), (String)"The optional element with ID %s was already added to this tag", (Object)optionalElement);
        this._builder.m_215905_(optionalElement);
        return this;
    }

    public ModTagAppender<T> addTag(TagKey<T> tag) {
        Preconditions.checkNotNull(tag, (Object)"Tag must not be null");
        ResourceLocation id = tag.f_203868_();
        Preconditions.checkState((boolean)this._addedTags.add(id), (String)"The tag with ID %s was already added to this tag", (Object)id);
        this._builder.m_215907_(id);
        return this;
    }

    public ModTagAppender<T> addOptionalTag(ResourceLocation optionalTag) {
        Preconditions.checkNotNull((Object)optionalTag, (Object)"Optional tag must not be null");
        Preconditions.checkState((boolean)this._addedOptionalTags.add(optionalTag), (String)"The optional tag with ID %s was already added to this tag", (Object)optionalTag);
        this._builder.m_215909_(optionalTag);
        return this;
    }
}

