/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.rectangular;

import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.AbstractRectangularMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.rectangular.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public abstract class AbstractRectangularMultiblockController<Controller extends AbstractRectangularMultiblockController<Controller>>
extends AbstractMultiblockController<Controller> {
    protected boolean containPosition(BlockPos position) {
        return this.mapBoundingBoxCoordinates((minPos, maxPos) -> minPos.compareTo((Vec3i)position) < 0 && maxPos.compareTo((Vec3i)position) > 0, false);
    }

    @Override
    protected boolean isMachineWhole(IMultiblockValidator validatorCallback) {
        int partsCount = this.getPartsCount();
        if (partsCount < this.getMinimumNumberOfPartsForAssembledMachine() || this.getBoundingBox().isEmpty()) {
            validatorCallback.setLastError(ValidationError.VALIDATION_ERROR_TOO_FEW_PARTS);
            return false;
        }
        return this.mapBoundingBoxCoordinates((min, max) -> this.isMachineWhole(validatorCallback, partsCount, (BlockPos)min, (BlockPos)max), false);
    }

    private boolean isMachineWhole(IMultiblockValidator validatorCallback, int partsCount, BlockPos minimumCoord, BlockPos maximumCoord) {
        int vMax;
        int vMin;
        int uMax;
        int uMin;
        int perimeter;
        BlockPos translation = maximumCoord.m_121996_((Vec3i)minimumCoord);
        Direction.Axis sizeOneAxis = AbstractRectangularMultiblockController.getZeroAxis((Vec3i)translation);
        if (null == sizeOneAxis) {
            validatorCallback.setLastError("ONLY ONE AXIS CAN BE 1!!!", new Object[0]);
            return false;
        }
        int xLength = translation.m_123341_() + 1;
        int yLength = translation.m_123342_() + 1;
        int zLength = translation.m_123343_() + 1;
        if (AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.X, this.getMinimumXSize(), this.getMaximumXSize(), xLength) || AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Y, this.getMinimumYSize(), this.getMaximumYSize(), yLength) || AbstractRectangularMultiblockController.isSizeWrong(validatorCallback, Direction.Axis.Z, this.getMinimumZSize(), this.getMaximumZSize(), zLength)) {
            return false;
        }
        BiFunction<Integer, Integer, BlockPos> positionFactory = switch (sizeOneAxis) {
            case Direction.Axis.X -> {
                perimeter = 2 * (yLength + zLength - 2);
                uMin = minimumCoord.m_123343_();
                uMax = maximumCoord.m_123343_();
                vMin = minimumCoord.m_123342_();
                vMax = maximumCoord.m_123342_();
                yield (u, v) -> new BlockPos(minimumCoord.m_123341_(), v.intValue(), u.intValue());
            }
            case Direction.Axis.Y -> {
                perimeter = 2 * (xLength + zLength - 2);
                uMin = minimumCoord.m_123341_();
                uMax = maximumCoord.m_123341_();
                vMin = minimumCoord.m_123343_();
                vMax = maximumCoord.m_123343_();
                yield (u, v) -> new BlockPos(u.intValue(), minimumCoord.m_123342_(), v.intValue());
            }
            case Direction.Axis.Z -> {
                perimeter = 2 * (xLength + yLength - 2);
                uMin = minimumCoord.m_123341_();
                uMax = maximumCoord.m_123341_();
                vMin = minimumCoord.m_123342_();
                vMax = maximumCoord.m_123342_();
                yield (u, v) -> new BlockPos(u.intValue(), v.intValue(), minimumCoord.m_123343_());
            }
            default -> throw new IllegalStateException("Illegal fourth axis");
        };
        if (perimeter != partsCount) {
            validatorCallback.setLastError("the number of blocks does not match the number of required parts!!!", new Object[0]);
            return false;
        }
        for (int u2 = uMin; u2 <= uMax; ++u2) {
            if (this.validateBlock(positionFactory.apply(u2, vMin), validatorCallback) && this.validateBlock(positionFactory.apply(u2, vMax), validatorCallback)) continue;
            return false;
        }
        for (int v2 = vMin + 1; v2 <= vMax - 1; ++v2) {
            if (this.validateBlock(positionFactory.apply(uMin, v2), validatorCallback) && this.validateBlock(positionFactory.apply(uMax, v2), validatorCallback)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void forceStructureUpdate(Level world) {
        this.forBoundingBoxCoordinates((min, max) -> AbstractRectangularMultiblockController.forceStructureUpdate(world, min, max));
    }

    protected AbstractRectangularMultiblockController(Level world) {
        super(world);
    }

    @Nullable
    private static Direction.Axis getZeroAxis(Vec3i vector) {
        boolean z;
        boolean y;
        boolean x = 0 == vector.m_123341_();
        int count = (x ? 1 : 0) + ((y = 0 == vector.m_123342_()) ? 1 : 0) + ((z = 0 == vector.m_123343_()) ? 1 : 0);
        if (1 != count) {
            return null;
        }
        return x ? Direction.Axis.X : (y ? Direction.Axis.Y : Direction.Axis.Z);
    }

    private boolean validateBlock(BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        BlockEntity te = WorldHelper.getLoadedTile(this.getWorld(), blockPosition);
        AbstractRectangularMultiblockPart part = te instanceof AbstractRectangularMultiblockPart ? (AbstractRectangularMultiblockPart)te : null;
        return null != part ? this.validatePart(part, blockPosition, validatorCallback) : this.validateGenericBlock(blockPosition, validatorCallback);
    }

    private boolean validatePart(AbstractRectangularMultiblockPart<Controller> part, BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        if (!part.getMultiblockController().map(this::isControllerCompatible).orElse(false).booleanValue()) {
            validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part", new Object[0]);
            return false;
        }
        if (!this.containsPart(part)) {
            validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_foreign_part", new Object[0]);
            return false;
        }
        PartPosition position = PartPosition.positionIn((AbstractRectangularMultiblockController)this.castSelf(), blockPosition);
        if (!part.isGoodForPosition(position, validatorCallback)) {
            if (!validatorCallback.hasLastError()) {
                validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part_for_frame", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private boolean validateGenericBlock(BlockPos blockPosition, IMultiblockValidator validatorCallback) {
        if (!this.isBlockGoodForFrame(this.getWorld(), blockPosition.m_123341_(), blockPosition.m_123342_(), blockPosition.m_123343_(), validatorCallback)) {
            if (!validatorCallback.hasLastError()) {
                validatorCallback.setLastError(blockPosition, "zerocore:api.multiblock.validation.invalid_part_for_frame", new Object[0]);
            }
            return false;
        }
        return true;
    }

    private static boolean isValueNot(int value, int min, int max) {
        return value != min && value != max;
    }

    private static boolean isOnCorner(int a, int b, int aTarget, int bTarget) {
        return a == aTarget && b == bTarget;
    }

    private static boolean isOnCorner(int a, int b, int minA, int minB, int maxA, int maxB) {
        return AbstractRectangularMultiblockController.isOnCorner(a, b, minA, minB) || AbstractRectangularMultiblockController.isOnCorner(a, b, minA, maxB) || AbstractRectangularMultiblockController.isOnCorner(a, b, maxA, maxB) || AbstractRectangularMultiblockController.isOnCorner(a, b, maxA, minB);
    }

    private static boolean isOnCornerX(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.m_123342_(), pos.m_123343_(), minPos.m_123342_(), minPos.m_123343_(), maxPos.m_123342_(), maxPos.m_123343_());
    }

    private static boolean isOnCornerY(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.m_123341_(), pos.m_123343_(), minPos.m_123341_(), minPos.m_123343_(), maxPos.m_123341_(), maxPos.m_123343_());
    }

    private static boolean isOnCornerZ(BlockPos pos, BlockPos minPos, BlockPos maxPos) {
        return AbstractRectangularMultiblockController.isOnCorner(pos.m_123341_(), pos.m_123342_(), minPos.m_123341_(), minPos.m_123342_(), maxPos.m_123341_(), maxPos.m_123342_());
    }

    private static boolean isSizeWrong(IMultiblockValidator validatorCallback, Direction.Axis axis, int minSize, int maxSize, int size) {
        if (maxSize > 0 && size > maxSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_large", maxSize, axis.m_7912_());
            return true;
        }
        if (size < minSize) {
            validatorCallback.setLastError("zerocore:api.multiblock.validation.machine_too_small", minSize, axis.m_7912_());
            return true;
        }
        return false;
    }

    @Nullable
    private AbstractRectangularMultiblockPart<Controller> getPartFromWorld(BlockPos position) {
        BlockEntity te = WorldHelper.getLoadedTile(this.getWorld(), position);
        return te instanceof AbstractRectangularMultiblockPart ? (AbstractRectangularMultiblockPart)te : null;
    }

    private static void forceStructureUpdate(Level world, BlockPos minCoord, BlockPos maxCoord) {
        int minX = minCoord.m_123341_();
        int minY = minCoord.m_123342_();
        int minZ = minCoord.m_123343_();
        int maxX = maxCoord.m_123341_();
        int maxY = maxCoord.m_123342_();
        int maxZ = maxCoord.m_123343_();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = world.m_8055_(pos);
                    world.m_7260_(pos, state, state, 3);
                }
            }
        }
    }
}

