/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.registry;

import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.zerono.mods.zerocore.internal.Lib;
import it.zerono.mods.zerocore.internal.Log;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockRegistry;
import it.zerono.mods.zerocore.lib.multiblock.registry.MultiblockWorldRegistry;
import java.util.Map;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MultiblockRegistry<Controller extends IMultiblockController<Controller>>
implements IMultiblockRegistry<Controller> {
    public static final IMultiblockRegistry INSTANCE = Lib.createMultiblockRegistry();
    private final Map<Level, MultiblockWorldRegistry<Controller>> _registries = new Reference2ObjectArrayMap(16);

    @Override
    public void onPartAdded(IMultiblockPart<Controller> part) {
        this._registries.computeIfAbsent(part.getCurrentWorld(), MultiblockWorldRegistry::new).onPartAdded(part);
    }

    @Override
    public void onPartRemovedFromWorld(IMultiblockPart<Controller> part) {
        MultiblockWorldRegistry<Controller> registry = this._registries.get(part.getCurrentWorld());
        if (null != registry) {
            registry.onPartRemovedFromWorld(part);
        } else {
            Log.LOGGER.error(Log.MULTIBLOCK, "Trying to remove a part from a world ({}) that is not tracked! Skipping.", (Object)part.getCurrentWorld().m_46472_());
        }
    }

    @Override
    public void addDeadController(Controller controller) {
        MultiblockWorldRegistry<Controller> registry = this._registries.get(controller.getWorld());
        if (null != registry) {
            registry.addDeadController(controller);
        } else {
            Log.LOGGER.error(Log.MULTIBLOCK, "Controller {} in world ({}) marked as dead, but that world is not tracked! Controller is being ignored.", (Object)controller.hashCode(), (Object)controller.getWorld().m_46472_());
        }
    }

    @Override
    public void addDirtyController(Controller controller) {
        MultiblockWorldRegistry<Controller> registry = this._registries.get(controller.getWorld());
        if (null != registry) {
            registry.addDirtyController(controller);
        } else {
            Log.LOGGER.error(Log.MULTIBLOCK, "Adding a dirty controller to a world ({}) that has no registered controllers!", (Object)controller.getWorld().m_46472_());
        }
    }

    public MultiblockRegistry() {
        MinecraftForge.EVENT_BUS.addListener(this::onWorldUnload);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldTick);
    }

    protected void tickStart(Level world) {
        ProfilerFiller profiler = world.m_46473_();
        profiler.m_6180_("Zero CORE|Multiblock|Tick");
        MultiblockWorldRegistry<Controller> registry = this._registries.get(world);
        if (null != registry) {
            registry.processMultiblockChanges();
            registry.tickStart();
        }
        profiler.m_7238_();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onWorldUnload(LevelEvent.Unload event) {
        LevelAccessor world = event.getLevel();
        if (world instanceof Level) {
            MultiblockWorldRegistry<Controller> registry = this._registries.get(world);
            if (null != registry) {
                registry.onWorldUnloaded();
                this._registries.remove(world);
            }
        } else {
            Log.LOGGER.error(Log.MULTIBLOCK, "Trying to unload a world that's not a World!");
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.LevelTickEvent event) {
        if (TickEvent.Phase.START == event.phase) {
            this.tickStart(event.level);
        }
    }
}

