/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.multiblock.storage;

import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectCollections;
import it.zerono.mods.zerocore.lib.data.geometry.CuboidBoundingBox;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.storage.IPartStorage;
import it.zerono.mods.zerocore.lib.world.NeighboringPositions;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public class PartStorage<Controller extends IMultiblockController<Controller>>
implements IPartStorage<Controller> {
    private final Long2ObjectAVLTreeMap<IMultiblockPart<Controller>> _parts = new Long2ObjectAVLTreeMap();
    private final ObjectCollection<IMultiblockPart<Controller>> _values;
    private Collection<IMultiblockPart<Controller>> _partsUnmodifiable;

    public PartStorage() {
        this._parts.defaultReturnValue(null);
        this._values = this._parts.values();
    }

    @Override
    public boolean isEmpty() {
        return this._parts.isEmpty();
    }

    @Override
    public int size() {
        return this._parts.size();
    }

    @Override
    public boolean contains(IMultiblockPart<Controller> part) {
        if (this._parts.isEmpty()) {
            return false;
        }
        long firstHash = this._parts.firstLongKey();
        long lastHash = this._parts.lastLongKey();
        long positionHash = part.getWorldPositionHash();
        return positionHash >= firstHash && positionHash <= lastHash && this._parts.containsKey(positionHash);
    }

    @Override
    public boolean contains(BlockPos[] positions) {
        if (this._parts.isEmpty()) {
            return false;
        }
        long firstHash = this._parts.firstLongKey();
        long lastHash = this._parts.lastLongKey();
        for (BlockPos position : positions) {
            long positionHash = position.m_121878_();
            if (positionHash < firstHash || positionHash > lastHash || !this._parts.containsKey(positionHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(long[] positionsHashes) {
        if (this._parts.isEmpty()) {
            return false;
        }
        long firstHash = this._parts.firstLongKey();
        long lastHash = this._parts.lastLongKey();
        for (long positionHash : positionsHashes) {
            if (positionHash < firstHash || positionHash > lastHash || !this._parts.containsKey(positionHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(NeighboringPositions positions) {
        if (this._parts.isEmpty()) {
            return false;
        }
        long firstHash = this._parts.firstLongKey();
        long lastHash = this._parts.lastLongKey();
        for (int index = 0; index < positions.size(); ++index) {
            long positionHash = positions.getHash(index);
            if (positionHash < firstHash || positionHash > lastHash || !this._parts.containsKey(positionHash)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public IMultiblockPart<Controller> get(BlockPos position) {
        return this.get(position.m_121878_());
    }

    @Override
    @Nullable
    public IMultiblockPart<Controller> get(long positionHash) {
        if (this._parts.isEmpty()) {
            return null;
        }
        long firstHash = this._parts.firstLongKey();
        long lastHash = this._parts.lastLongKey();
        return positionHash >= firstHash && positionHash <= lastHash ? (IMultiblockPart)this._parts.get(positionHash) : null;
    }

    @Override
    public void get(NeighboringPositions positions, List<IMultiblockPart<Controller>> foundParts) {
        int size = positions.size();
        for (int idx = 0; idx < size; ++idx) {
            IMultiblockPart<Controller> part = this.get(positions.getHash(idx));
            if (null == part) continue;
            foundParts.add(part);
        }
    }

    @Override
    @Nullable
    public IMultiblockPart<Controller> getFirst() {
        return this.isEmpty() ? null : (IMultiblockPart)this._parts.get(this._parts.firstLongKey());
    }

    @Override
    public void addOrReplace(IMultiblockPart<Controller> part) {
        this._parts.put(part.getWorldPositionHash(), part);
    }

    @Override
    public void addAll(IPartStorage<Controller> parts) {
        if (parts instanceof PartStorage) {
            this._parts.putAll(((PartStorage)parts)._parts);
        } else {
            IPartStorage.super.addAll(parts);
        }
    }

    @Override
    public void remove(IMultiblockPart<Controller> part) {
        long positionHash = part.getWorldPositionHash();
        if (this.get(positionHash) == part) {
            this._parts.remove(positionHash);
        }
    }

    @Override
    public void removeAll(Collection<IMultiblockPart<Controller>> parts) {
        this._values.removeAll(parts);
    }

    @Override
    public void clear() {
        this._parts.clear();
    }

    @Override
    public Collection<IMultiblockPart<Controller>> unmodifiable() {
        if (null == this._partsUnmodifiable) {
            this._partsUnmodifiable = ObjectCollections.unmodifiable(this._values);
        }
        return this._partsUnmodifiable;
    }

    @Override
    public Stream<IMultiblockPart<Controller>> stream() {
        return this._values.stream();
    }

    @Override
    public Stream<IMultiblockPart<Controller>> parallelStream() {
        return this._values.parallelStream();
    }

    @Override
    public void forEach(Consumer<IMultiblockPart<Controller>> consumer, Predicate<IMultiblockPart<Controller>> filter) {
        for (IMultiblockPart part : this._values) {
            if (!filter.test(part)) continue;
            consumer.accept(part);
        }
    }

    @Override
    public void forEachValidPart(Consumer<IMultiblockPart<Controller>> consumer) {
        for (IMultiblockPart part : this._values) {
            if (part.isPartInvalid()) continue;
            consumer.accept(part);
        }
    }

    @Override
    public void forEachNotVisitedPart(Consumer<IMultiblockPart<Controller>> consumer) {
        for (IMultiblockPart part : this._values) {
            if (!part.isNotVisited()) continue;
            consumer.accept(part);
        }
    }

    @Override
    public CuboidBoundingBox boundingBox() {
        if (this.size() <= 4096) {
            CuboidBoundingBox bb = CuboidBoundingBox.EMPTY;
            for (IMultiblockPart part : this._values) {
                bb = bb.add(part.getWorldPosition());
            }
            return bb;
        }
        return this.parallelStream().map(IMultiblockPart::getWorldPosition).collect(CuboidBoundingBox::new, CuboidBoundingBox::add, CuboidBoundingBox::combine);
    }

    @Override
    public Iterator<IMultiblockPart<Controller>> iterator() {
        return this._values.iterator();
    }

    @Override
    public void forEach(Consumer<? super IMultiblockPart<Controller>> action) {
        for (IMultiblockPart part : this._values) {
            action.accept(part);
        }
    }

    public String toString() {
        return String.format("%d parts", this._parts.size());
    }
}

