/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.inventory.container;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerMultipart;
import org.cyclops.integrateddynamics.core.part.PartStateEmpty;
import org.cyclops.integratedterminals.GeneralConfig;
import org.cyclops.integratedterminals.RegistryEntries;
import org.cyclops.integratedterminals.api.terminalstorage.crafting.ITerminalCraftingPlan;
import org.cyclops.integratedterminals.core.client.gui.CraftingJobGuiData;
import org.cyclops.integratedterminals.part.PartTypeTerminalCraftingJob;

public class ContainerTerminalCraftingJobsPlan
extends ContainerMultipart<PartTypeTerminalCraftingJob, PartStateEmpty<PartTypeTerminalCraftingJob>> {
    private final CraftingJobGuiData craftingJobGuiData;
    private final int craftingPlanNotifierId;
    private long lastUpdate;
    private Optional<ITerminalCraftingPlan> craftingPlan;

    public ContainerTerminalCraftingJobsPlan(int id, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(id, playerInventory, PartHelpers.readPartTarget((FriendlyByteBuf)packetBuffer), Optional.empty(), (PartTypeTerminalCraftingJob)PartHelpers.readPart((FriendlyByteBuf)packetBuffer), CraftingJobGuiData.readFromPacketBuffer(packetBuffer));
    }

    public ContainerTerminalCraftingJobsPlan(int id, Inventory playerInventory, PartTarget target, Optional<IPartContainer> partContainer, PartTypeTerminalCraftingJob partType, CraftingJobGuiData craftingJobGuiData) {
        super(RegistryEntries.CONTAINER_PART_TERMINAL_CRAFTING_JOBS_PLAN, id, playerInventory, (Container)new SimpleContainer(new ItemStack[0]), Optional.of(target), partContainer, (IPartType)partType);
        this.craftingJobGuiData = craftingJobGuiData;
        this.craftingPlan = Optional.empty();
        this.craftingPlanNotifierId = this.getNextValueId();
    }

    public CraftingJobGuiData getCraftingJobGuiData() {
        return this.craftingJobGuiData;
    }

    public Optional<ITerminalCraftingPlan> getCraftingPlan() {
        return this.craftingPlan;
    }

    public void m_38946_() {
        super.m_38946_();
        if (!this.getLevel().m_5776_() && this.lastUpdate < System.currentTimeMillis()) {
            this.lastUpdate = System.currentTimeMillis() + (long)GeneralConfig.guiTerminalCraftingJobsUpdateFrequency;
            this.updateCraftingPlan();
        }
    }

    public int getCraftingPlanNotifierId() {
        return this.craftingPlanNotifierId;
    }

    protected void updateCraftingPlan() {
        this.getTarget().ifPresent(target -> {
            INetwork network = NetworkHelpers.getNetworkChecked((PartPos)target.getCenter());
            this.craftingPlan = Optional.ofNullable(this.craftingJobGuiData.getHandler().getCraftingJob(network, this.craftingJobGuiData.getChannel(), this.craftingJobGuiData.getCraftingJob()));
            this.setValue(this.craftingPlanNotifierId, this.craftingPlan.map(p -> this.craftingJobGuiData.getHandler().serializeCraftingPlan(p)).orElse(new CompoundTag()));
        });
    }

    protected int getSizeInventory() {
        return 0;
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void onUpdate(int valueId, CompoundTag value) {
        if (valueId == this.craftingPlanNotifierId) {
            try {
                this.craftingPlan = Optional.of(this.craftingJobGuiData.getHandler().deserializeCraftingPlan(value));
            }
            catch (IllegalArgumentException e) {
                this.craftingPlan = Optional.empty();
            }
        }
        super.onUpdate(valueId, value);
    }
}

