/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedterminals.network.packet;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.commoncapabilities.IngredientComponents;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.PacketCodec;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentClient;
import org.cyclops.integratedterminals.core.terminalstorage.TerminalStorageTabIngredientComponentItemStackCrafting;
import org.cyclops.integratedterminals.inventory.container.ContainerTerminalStorageBase;

public class TerminalStorageIngredientMaxQuantityPacket
extends PacketCodec {
    @CodecField
    private String tabId;
    @CodecField
    private String ingredientName;
    @CodecField
    private long maxQuantity;
    @CodecField
    private int channel;

    public TerminalStorageIngredientMaxQuantityPacket() {
    }

    public TerminalStorageIngredientMaxQuantityPacket(String tabId, IngredientComponent<?, ?> ingredientComponent, long maxQuantity, int channel) {
        this.tabId = tabId;
        this.ingredientName = ingredientComponent.getName().toString();
        this.maxQuantity = maxQuantity;
        this.channel = channel;
    }

    public boolean isAsync() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void actionClient(Level world, Player player) {
        if (player.f_36096_ instanceof ContainerTerminalStorageBase) {
            ContainerTerminalStorageBase container = (ContainerTerminalStorageBase)player.f_36096_;
            IngredientComponent ingredientComponent = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(this.ingredientName));
            if (ingredientComponent == null) {
                throw new IllegalArgumentException("No ingredient component with the given name was found: " + this.ingredientName);
            }
            TerminalStorageTabIngredientComponentClient tab = (TerminalStorageTabIngredientComponentClient)container.getTabClient(this.tabId);
            tab.setMaxQuantity(this.channel, this.maxQuantity);
            if (this.tabId.equals(IngredientComponents.ITEMSTACK.getName().toString())) {
                TerminalStorageTabIngredientComponentClient tabCrafting = (TerminalStorageTabIngredientComponentClient)container.getTabClient(TerminalStorageTabIngredientComponentItemStackCrafting.NAME.toString());
                tabCrafting.setMaxQuantity(this.channel, this.maxQuantity);
            }
        }
    }

    public void actionServer(Level world, ServerPlayer player) {
    }
}

