/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.autocrafting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class AllowedTagList {
    private static final String NBT_ALLOWED_ITEM_TAGS = "AllowedItemTags";
    private static final String NBT_ALLOWED_FLUID_TAGS = "AllowedFluidTags";
    @Nullable
    private final Runnable listener;
    private List<Set<ResourceLocation>> allowedItemTags = new ArrayList<Set<ResourceLocation>>();
    private List<Set<ResourceLocation>> allowedFluidTags = new ArrayList<Set<ResourceLocation>>();

    public AllowedTagList(@Nullable Runnable listener, int size) {
        for (int i = 0; i < size; ++i) {
            this.allowedItemTags.add(new HashSet());
            this.allowedFluidTags.add(new HashSet());
        }
        this.listener = listener;
    }

    public CompoundTag writeToNbt() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_(NBT_ALLOWED_ITEM_TAGS, (Tag)this.getList(this.allowedItemTags));
        tag.m_128365_(NBT_ALLOWED_FLUID_TAGS, (Tag)this.getList(this.allowedFluidTags));
        return tag;
    }

    public void readFromNbt(CompoundTag tag) {
        if (tag.m_128441_(NBT_ALLOWED_ITEM_TAGS)) {
            this.applyList(this.allowedItemTags, tag.m_128437_(NBT_ALLOWED_ITEM_TAGS, 9));
        }
        if (tag.m_128441_(NBT_ALLOWED_FLUID_TAGS)) {
            this.applyList(this.allowedFluidTags, tag.m_128437_(NBT_ALLOWED_FLUID_TAGS, 9));
        }
    }

    private ListTag getList(List<Set<ResourceLocation>> tagsPerSlot) {
        ListTag list = new ListTag();
        for (Set<ResourceLocation> tags : tagsPerSlot) {
            ListTag subList = new ListTag();
            tags.forEach(t -> subList.add((Object)StringTag.m_129297_((String)t.toString())));
            list.add((Object)subList);
        }
        return list;
    }

    private void applyList(List<Set<ResourceLocation>> list, ListTag tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            ListTag subList = tagList.m_128744_(i);
            for (int j = 0; j < subList.size(); ++j) {
                list.get(i).add(new ResourceLocation(subList.m_128778_(j)));
            }
        }
    }

    public List<Set<ResourceLocation>> getAllowedItemTags() {
        return this.allowedItemTags;
    }

    public void setAllowedItemTags(List<Set<ResourceLocation>> allowedItemTags) {
        this.allowedItemTags = allowedItemTags;
        this.notifyListener();
    }

    public List<Set<ResourceLocation>> getAllowedFluidTags() {
        return this.allowedFluidTags;
    }

    public void setAllowedFluidTags(List<Set<ResourceLocation>> allowedFluidTags) {
        this.allowedFluidTags = allowedFluidTags;
        this.notifyListener();
    }

    public void setAllowedItemTags(int slot, Set<ResourceLocation> allowedItemTags) {
        this.allowedItemTags.set(slot, allowedItemTags);
        this.notifyListener();
    }

    public void setAllowedFluidTags(int slot, Set<ResourceLocation> allowedFluidTags) {
        this.allowedFluidTags.set(slot, allowedFluidTags);
        this.notifyListener();
    }

    public void clearItemTags(int slot) {
        this.allowedItemTags.get(slot).clear();
        this.notifyListener();
    }

    public void clearFluidTags(int slot) {
        this.allowedFluidTags.get(slot).clear();
        this.notifyListener();
    }

    private void notifyListener() {
        if (this.listener != null) {
            this.listener.run();
        }
    }
}

