/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.blockentity.data;

import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationParameter;
import com.refinedmods.refinedstorage.network.sync.BlockEntitySynchronizationParameterMessage;
import net.minecraft.server.level.ServerPlayer;

public class BlockEntitySynchronizationWatcher {
    private final ServerPlayer player;
    private final BlockEntitySynchronizationManager manager;
    private boolean sentInitial;
    private Object[] cache;

    public BlockEntitySynchronizationWatcher(ServerPlayer player, BlockEntitySynchronizationManager manager) {
        this.player = player;
        this.manager = manager;
        if (manager != null) {
            this.manager.addWatcher(this);
            this.cache = new Object[manager.getWatchedParameters().size()];
        }
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public void onClosed() {
        this.manager.removeWatcher(this);
    }

    public void detectAndSendChanges() {
        if (!this.sentInitial) {
            this.manager.getParameters().forEach(p -> this.sendParameter(true, (BlockEntitySynchronizationParameter)p));
            this.sentInitial = true;
        } else {
            for (int i = 0; i < this.manager.getWatchedParameters().size(); ++i) {
                Object cached;
                BlockEntitySynchronizationParameter parameter = this.manager.getWatchedParameters().get(i);
                Object real = parameter.getValueProducer().apply(this.manager.getBlockEntity());
                if (real.equals(cached = this.cache[i])) continue;
                this.cache[i] = real;
                if (cached == null) continue;
                this.sendParameter(false, parameter);
            }
        }
    }

    public void sendParameter(boolean initial, BlockEntitySynchronizationParameter parameter) {
        RS.NETWORK_HANDLER.sendTo(this.player, new BlockEntitySynchronizationParameterMessage(this.manager.getBlockEntity(), parameter, initial));
    }
}

