/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.screen.grid;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.refinedmods.refinedstorage.RS;
import com.refinedmods.refinedstorage.RSKeyBindings;
import com.refinedmods.refinedstorage.api.network.grid.GridType;
import com.refinedmods.refinedstorage.api.network.grid.IGrid;
import com.refinedmods.refinedstorage.apiimpl.network.node.GridNetworkNode;
import com.refinedmods.refinedstorage.apiimpl.render.ElementDrawers;
import com.refinedmods.refinedstorage.blockentity.NetworkNodeBlockEntity;
import com.refinedmods.refinedstorage.blockentity.data.BlockEntitySynchronizationManager;
import com.refinedmods.refinedstorage.blockentity.grid.GridBlockEntity;
import com.refinedmods.refinedstorage.blockentity.grid.portable.IPortableGrid;
import com.refinedmods.refinedstorage.blockentity.grid.portable.PortableGridBlockEntity;
import com.refinedmods.refinedstorage.container.GridContainerMenu;
import com.refinedmods.refinedstorage.network.grid.GridClearMessage;
import com.refinedmods.refinedstorage.network.grid.GridFluidInsertHeldMessage;
import com.refinedmods.refinedstorage.network.grid.GridFluidPullMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemGridScrollMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemInsertHeldMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemInventoryScrollMessage;
import com.refinedmods.refinedstorage.network.grid.GridItemPullMessage;
import com.refinedmods.refinedstorage.network.grid.GridPatternCreateMessage;
import com.refinedmods.refinedstorage.screen.BaseScreen;
import com.refinedmods.refinedstorage.screen.IScreenInfoProvider;
import com.refinedmods.refinedstorage.screen.grid.CraftingSettingsScreen;
import com.refinedmods.refinedstorage.screen.grid.SmallClientTooltipComponent;
import com.refinedmods.refinedstorage.screen.grid.sorting.IGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.IdGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.InventoryTweaksGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.LastModifiedGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.NameGridSorter;
import com.refinedmods.refinedstorage.screen.grid.sorting.QuantityGridSorter;
import com.refinedmods.refinedstorage.screen.grid.stack.IGridStack;
import com.refinedmods.refinedstorage.screen.grid.stack.ItemGridStack;
import com.refinedmods.refinedstorage.screen.grid.view.GridViewImpl;
import com.refinedmods.refinedstorage.screen.grid.view.IGridView;
import com.refinedmods.refinedstorage.screen.widget.CheckboxWidget;
import com.refinedmods.refinedstorage.screen.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.screen.widget.SearchWidget;
import com.refinedmods.refinedstorage.screen.widget.TabListWidget;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSearchBoxModeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSizeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSortingDirectionSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridSortingTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.GridViewTypeSideButton;
import com.refinedmods.refinedstorage.screen.widget.sidebutton.RedstoneModeSideButton;
import com.refinedmods.refinedstorage.util.RenderUtils;
import com.refinedmods.refinedstorage.util.TimeUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.ForgeHooksClient;
import yalter.mousetweaks.api.MouseTweaksDisableWheelTweak;

@MouseTweaksDisableWheelTweak
public class GridScreen
extends BaseScreen<GridContainerMenu>
implements IScreenInfoProvider {
    private static final ResourceLocation PORTABLE_GRID_TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/portable_grid.png");
    private static final ResourceLocation CRAFTING_GRID_TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/crafting_grid.png");
    private static final ResourceLocation PATTERN_GRID_TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/pattern_grid.png");
    private static final ResourceLocation PATTERN_GRID_PROCESSING_TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/pattern_grid_processing.png");
    private static final ResourceLocation GRID_TEXTURE = new ResourceLocation("refinedstorage", "textures/gui/grid.png");
    private static String searchQuery = "";
    private final IGrid grid;
    private final TabListWidget<GridContainerMenu> tabs;
    private final int patternScrollOffsetAbsoluteMax = 24;
    private IGridView view;
    private SearchWidget searchField;
    private CheckboxWidget exactPattern;
    private CheckboxWidget processingPattern;
    private CheckboxWidget fluidCheckBox;
    private ScrollbarWidget scrollbar;
    private ScrollbarWidget patternScrollbar;
    private boolean wasConnected;
    private boolean doSort;
    private int slotNumber;
    private int slotNumberX;
    private int slotNumberY;
    private int patternScrollOffset;
    private int patternScrollOffsetMax;
    private boolean updatePatternOffset;

    public GridScreen(GridContainerMenu containerMenu, final IGrid grid, Inventory inventory, Component title) {
        super(containerMenu, 227, 0, inventory, title);
        this.grid = grid;
        this.view = new GridViewImpl(this, GridScreen.getDefaultSorter(), GridScreen.getSorters());
        this.wasConnected = this.grid.isGridActive();
        this.tabs = new TabListWidget<GridContainerMenu>(this, new ElementDrawers<GridContainerMenu>(this), grid::getTabs, grid::getTotalTabPages, grid::getTabPage, grid::getTabSelected, 5);
        this.tabs.addListener(new TabListWidget.ITabListListener(){

            @Override
            public void onSelectionChanged(int tab) {
                grid.onTabSelectionChanged(tab);
            }

            @Override
            public void onPageChanged(int page) {
                grid.onTabPageChanged(page);
            }
        });
        if (grid instanceof GridNetworkNode && grid.getGridType() == GridType.PATTERN) {
            GridNetworkNode node = (GridNetworkNode)grid;
            node.getProcessingMatrix().addListener((handler, slot, reading) -> {
                this.updatePatternOffset = true;
            });
            node.getProcessingMatrixFluids().addListener((handler, slot, reading) -> {
                this.updatePatternOffset = true;
            });
        }
    }

    public static List<IGridSorter> getSorters() {
        LinkedList<IGridSorter> sorters = new LinkedList<IGridSorter>();
        sorters.add(GridScreen.getDefaultSorter());
        sorters.add(new QuantityGridSorter());
        sorters.add(new IdGridSorter());
        sorters.add(new LastModifiedGridSorter());
        sorters.add(new InventoryTweaksGridSorter());
        return sorters;
    }

    public static IGridSorter getDefaultSorter() {
        return new NameGridSorter();
    }

    @Override
    protected void onPreInit() {
        super.onPreInit();
        this.doSort = true;
        this.f_97727_ = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18;
    }

    @Override
    public void onPostInit(int x, int y) {
        ((GridContainerMenu)this.f_97732_).initSlots();
        this.tabs.init(this.f_97726_ - 32);
        this.scrollbar = new ScrollbarWidget(this, 174, this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof GridNetworkNode || this.grid instanceof PortableGridBlockEntity) {
            this.addSideButton(new RedstoneModeSideButton(this, this.grid instanceof GridNetworkNode ? NetworkNodeBlockEntity.REDSTONE_MODE : PortableGridBlockEntity.REDSTONE_MODE));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1;
        if (this.searchField == null) {
            this.searchField = new SearchWidget(this.f_96547_, sx, sy, 82);
            this.searchField.m_94151_(value -> {
                this.searchField.updateJei();
                this.getView().sort();
                searchQuery = value;
            });
            this.searchField.setMode(this.grid.getSearchBoxMode());
            this.searchField.m_94144_(searchQuery);
        } else {
            this.searchField.m_252865_(sx);
            this.searchField.m_253211_(sy);
        }
        this.m_142416_((GuiEventListener)this.searchField);
        if (this.searchField.m_93696_()) {
            this.m_7522_((GuiEventListener)this.searchField);
        }
        if (this.grid.getViewType() != -1) {
            this.addSideButton(new GridViewTypeSideButton(this, this.grid));
        }
        this.addSideButton(new GridSortingDirectionSideButton(this, this.grid));
        this.addSideButton(new GridSortingTypeSideButton(this, this.grid));
        this.addSideButton(new GridSearchBoxModeSideButton(this));
        this.addSideButton(new GridSizeSideButton(this, this.grid::getSize, this.grid::onSizeChanged));
        if (this.grid.getGridType() == GridType.PATTERN) {
            this.patternScrollbar = new ScrollbarWidget(this, 160, this.getTopHeight() + this.getVisibleRows() * 18 + 4, 6, 52, true);
            this.patternScrollbar.setMaxOffset(24);
            this.patternScrollbar.setOffset(this.patternScrollOffset);
            ((GridContainerMenu)this.f_97732_).updatePatternSlotPositions(this.patternScrollOffset);
            this.patternScrollbar.addListener((oldOffset, newOffset) -> {
                this.patternScrollOffset = newOffset;
                ((GridContainerMenu)this.f_97732_).updatePatternSlotPositions(newOffset);
            });
            this.processingPattern = this.addCheckBox(x + 7, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (Component)Component.m_237115_((String)"misc.refinedstorage.processing"), GridBlockEntity.PROCESSING_PATTERN.getValue(), btn -> {
                GridBlockEntity.PROCESSING_PATTERN.setValue(false, this.processingPattern.m_93840_());
                ((GridNetworkNode)this.grid).clearMatrix();
                ((GridContainerMenu)this.f_97732_).initSlots();
                this.patternScrollOffset = 0;
                BlockEntitySynchronizationManager.setParameter(GridBlockEntity.PROCESSING_PATTERN, this.processingPattern.m_93840_());
            });
            if (!this.processingPattern.m_93840_()) {
                this.exactPattern = this.addCheckBox(this.processingPattern.m_252754_() + this.processingPattern.m_5711_() + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (Component)Component.m_237115_((String)"misc.refinedstorage.exact"), GridBlockEntity.EXACT_PATTERN.getValue(), btn -> BlockEntitySynchronizationManager.setParameter(GridBlockEntity.EXACT_PATTERN, this.exactPattern.m_93840_()));
                this.patternScrollbar.setEnabled(false);
            } else {
                this.patternScrollbar.setEnabled(true);
                this.fluidCheckBox = this.addCheckBox(this.processingPattern.m_252754_() + this.processingPattern.m_5711_() + 5, y + this.getTopHeight() + this.getVisibleRows() * 18 + 60, (Component)Component.m_237115_((String)"misc.refinedstorage.fluidmode"), ((GridNetworkNode)this.grid).getType() == 1, button -> BlockEntitySynchronizationManager.setParameter(GridBlockEntity.PROCESSING_TYPE, GridBlockEntity.PROCESSING_TYPE.getValue() == 0 ? 1 : 0));
            }
        }
        this.updateScrollbar();
    }

    public IGrid getGrid() {
        return this.grid;
    }

    public IGridView getView() {
        return this.view;
    }

    public void setView(IGridView view) {
        this.view = view;
    }

    @Override
    public void tick(int x, int y) {
        if (this.wasConnected != this.grid.isGridActive()) {
            this.wasConnected = this.grid.isGridActive();
            this.view.sort();
        }
        if (this.updatePatternOffset) {
            this.updatePatternOffsetMax();
            this.updatePatternOffset = false;
        }
        if (GridScreen.isKeyDown(RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX)) {
            RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
        }
        this.tabs.update();
    }

    @Override
    public int getTopHeight() {
        return 19;
    }

    @Override
    public int getBottomHeight() {
        if (this.grid.getGridType() == GridType.CRAFTING) {
            return 156;
        }
        if (this.grid.getGridType() == GridType.PATTERN) {
            return 169;
        }
        return 99;
    }

    @Override
    public int getYPlayerInventory() {
        int yp = this.getTopHeight() + this.getVisibleRows() * 18;
        if (this.grid.getGridType() == GridType.NORMAL || this.grid.getGridType() == GridType.FLUID) {
            yp += 16;
        } else if (this.grid.getGridType() == GridType.CRAFTING) {
            yp += 73;
        } else if (this.grid.getGridType() == GridType.PATTERN) {
            yp += 86;
        }
        return yp;
    }

    @Override
    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    @Override
    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    @Override
    public String getSearchFieldText() {
        return this.searchField.m_94155_();
    }

    @Override
    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.f_96544_ - this.getTopHeight() - this.getBottomHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.CLIENT_CONFIG.getGrid().getMaxRowsStretch()));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    private boolean isOverSlotWithStack() {
        return this.grid.isGridActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(double mouseX, double mouseY) {
        return RenderUtils.inBounds(7, 19, 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public int getSlotNumberX() {
        return this.slotNumberX;
    }

    public int getSlotNumberY() {
        return this.slotNumberY;
    }

    private boolean isOverClear(double mouseX, double mouseY) {
        int y = this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        switch (this.grid.getGridType()) {
            case CRAFTING: {
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
            case PATTERN: {
                if (((GridNetworkNode)this.grid).isProcessingPattern()) {
                    return RenderUtils.inBounds(149, y, 7, 7, mouseX, mouseY);
                }
                return RenderUtils.inBounds(82, y, 7, 7, mouseX, mouseY);
            }
        }
        return false;
    }

    private boolean isOverCreatePattern(double mouseX, double mouseY) {
        return this.grid.getGridType() == GridType.PATTERN && RenderUtils.inBounds(172, this.getTopHeight() + this.getVisibleRows() * 18 + 22, 16, 16, mouseX, mouseY) && ((GridNetworkNode)this.grid).canCreatePattern();
    }

    @Override
    public void renderBackground(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
        this.tabs.drawBackground(graphics, x, y - this.tabs.getHeight());
        ResourceLocation texture = this.grid instanceof IPortableGrid ? PORTABLE_GRID_TEXTURE : (this.grid.getGridType() == GridType.CRAFTING ? CRAFTING_GRID_TEXTURE : (this.grid.getGridType() == GridType.PATTERN ? (((GridNetworkNode)this.grid).isProcessingPattern() ? PATTERN_GRID_PROCESSING_TEXTURE : PATTERN_GRID_TEXTURE) : GRID_TEXTURE));
        int yy = y;
        graphics.m_280218_(texture, x, yy, 0, 0, this.f_97726_ - 34, this.getTopHeight());
        graphics.m_280218_(texture, x + this.f_97726_ - 34 + 4, y, 197, 0, 30, this.grid instanceof IPortableGrid ? 114 : 82);
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            yy += 18;
            int yTextureStart = this.getTopHeight();
            if (i > 0) {
                yTextureStart = i == rows - 1 ? (yTextureStart += 36) : (yTextureStart += 18);
            }
            graphics.m_280218_(texture, x, yy, 0, yTextureStart, this.f_97726_ - 34, 18);
        }
        graphics.m_280218_(texture, x, yy += 18, 0, this.getTopHeight() + 54, this.f_97726_ - 34, this.getBottomHeight());
        if (this.grid.getGridType() == GridType.PATTERN) {
            int ty = 0;
            if (this.isOverCreatePattern(mouseX - this.f_97735_, mouseY - this.f_97736_)) {
                ty = 1;
            }
            if (!((GridNetworkNode)this.grid).canCreatePattern()) {
                ty = 2;
            }
            graphics.m_280218_(texture, x + 172, y + this.getTopHeight() + this.getVisibleRows() * 18 + 22, 240, ty * 16, 16, 16);
            if (this.processingPattern.m_93840_()) {
                this.updatePatternScrollbar();
                this.patternScrollbar.render(graphics);
            }
        }
        this.tabs.drawForeground(graphics, x, y - this.tabs.getHeight(), mouseX, mouseY, true);
        this.searchField.m_88315_(graphics, 0, 0, 0.0f);
        this.scrollbar.render(graphics);
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.isOverSlotWithStack()) {
            this.drawGridTooltip(graphics, this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
    }

    @Override
    public void renderForeground(GuiGraphics graphics, int mouseX, int mouseY) {
        this.renderString(graphics, 7, 7, this.f_96539_.getString());
        this.renderString(graphics, 7, this.getYPlayerInventory() - 12, I18n.m_118938_((String)"container.inventory", (Object[])new Object[0]));
        int x = 8;
        int y = 19;
        this.slotNumber = -1;
        this.slotNumberX = -1;
        this.slotNumberY = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        Lighting.m_84931_();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                this.slotNumber = slot;
                this.slotNumberX = x;
                this.slotNumberY = y;
            }
            if (slot < this.view.getStacks().size()) {
                this.view.getStacks().get(slot).draw(graphics, this, x, y);
            }
            if (RenderUtils.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isGridActive()) {
                int color = this.grid.isGridActive() ? -2130706433 : -10790053;
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 300.0f);
                RenderSystem.disableDepthTest();
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                graphics.m_280024_(x, y, x + 16, y + 16, color, color);
                RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                graphics.m_280168_().m_85849_();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.renderTooltip(graphics, mouseX, mouseY, I18n.m_118938_((String)"misc.refinedstorage.clear", (Object[])new Object[0]));
        }
        if (this.isOverCreatePattern(mouseX, mouseY)) {
            this.renderTooltip(graphics, mouseX, mouseY, I18n.m_118938_((String)"gui.refinedstorage.grid.pattern_create", (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(graphics, this.f_96547_, mouseX, mouseY);
    }

    private void drawGridTooltip(GuiGraphics graphics, IGridStack gridStack, int mouseX, int mouseY) {
        ItemStack stackContext = gridStack instanceof ItemGridStack ? ((ItemGridStack)gridStack).getStack() : ItemStack.f_41583_;
        List<Component> textElements = gridStack.getTooltip(true);
        ArrayList<SmallClientTooltipComponent> components = new ArrayList<SmallClientTooltipComponent>(ForgeHooksClient.gatherTooltipComponents((ItemStack)stackContext, textElements, (int)mouseX, (int)this.f_96541_.m_91268_().m_85445_(), (int)this.f_96541_.m_91268_().m_85446_(), (Font)this.f_96547_));
        if (RS.CLIENT_CONFIG.getGrid().getDetailedTooltip()) {
            float scale;
            float f = scale = this.f_96541_ != null && this.f_96541_.m_91390_() ? 1.0f : 0.7f;
            if (!gridStack.isCraftable()) {
                MutableComponent total = Component.m_237110_((String)"misc.refinedstorage.total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}).m_130940_(ChatFormatting.GRAY);
                components.add(new SmallClientTooltipComponent((Component)total, scale));
            }
            if (gridStack.getTrackerEntry() != null) {
                MutableComponent time = Component.m_237115_((String)TimeUtils.getAgo(gridStack.getTrackerEntry().getTime(), gridStack.getTrackerEntry().getName())).m_130940_(ChatFormatting.GRAY);
                components.add(new SmallClientTooltipComponent((Component)time, scale));
            }
        }
        graphics.m_280497_(this.f_96547_, components, mouseX, mouseY, DefaultTooltipPositioner.f_262752_);
    }

    public boolean m_6375_(double mouseX, double mouseY, int clickedButton) {
        boolean clickedCreatePattern;
        if (this.tabs.mouseClicked()) {
            this.m_7522_(null);
            return true;
        }
        if (this.scrollbar.m_6375_(mouseX, mouseY, clickedButton)) {
            this.m_7522_(null);
            return true;
        }
        if (this.grid.getGridType() == GridType.PATTERN && this.patternScrollbar.m_6375_(mouseX, mouseY, clickedButton)) {
            this.m_7522_(null);
            return true;
        }
        if (RS.CLIENT_CONFIG.getGrid().getPreventSortingWhileShiftIsDown()) {
            this.doSort = !this.isOverSlotArea(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_) && !this.isOverCraftingOutputArea(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_);
        }
        boolean clickedClear = clickedButton == 0 && this.isOverClear(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_);
        boolean bl = clickedCreatePattern = clickedButton == 0 && this.isOverCreatePattern(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_);
        if (clickedCreatePattern) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            RS.NETWORK_HANDLER.sendToServer(new GridPatternCreateMessage(((GridNetworkNode)this.grid).getPos()));
            this.m_7522_(null);
            return true;
        }
        if (clickedClear) {
            this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            RS.NETWORK_HANDLER.sendToServer(new GridClearMessage());
            this.m_7522_(null);
            return true;
        }
        if (this.grid.isGridActive()) {
            ItemStack held = ((GridContainerMenu)this.f_97732_).m_142621_();
            if (this.isOverSlotArea(mouseX - (double)this.f_97735_, mouseY - (double)this.f_97736_) && !held.m_41619_() && (clickedButton == 0 || clickedButton == 1)) {
                if (this.grid.getGridType() == GridType.FLUID) {
                    RS.NETWORK_HANDLER.sendToServer(new GridFluidInsertHeldMessage());
                } else {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemInsertHeldMessage(clickedButton == 1));
                }
                this.m_7522_(null);
                return true;
            }
            if (this.isOverSlotWithStack()) {
                IGridStack stack = this.view.getStacks().get(this.slotNumber);
                if (held.m_41619_()) {
                    if (this.view.canCraft() && stack.isCraftable()) {
                        this.f_96541_.m_91152_((Screen)new CraftingSettingsScreen(this, this.inventory.f_35978_, stack));
                    } else if (this.view.canCraft() && !stack.isCraftable() && stack.getOtherId() != null && GridScreen.m_96638_() && GridScreen.m_96637_()) {
                        this.f_96541_.m_91152_((Screen)new CraftingSettingsScreen(this, this.inventory.f_35978_, this.view.get(stack.getOtherId())));
                    } else if (this.grid.getGridType() == GridType.FLUID && held.m_41619_()) {
                        RS.NETWORK_HANDLER.sendToServer(new GridFluidPullMessage(this.view.getStacks().get(this.slotNumber).getId(), GridScreen.m_96638_()));
                    } else if (this.grid.getGridType() != GridType.FLUID) {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GridScreen.m_96638_()) {
                            flags |= 4;
                        }
                        RS.NETWORK_HANDLER.sendToServer(new GridItemPullMessage(stack.getId(), flags));
                    }
                }
                this.m_7522_(null);
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, clickedButton);
    }

    private boolean isOverCraftingOutputArea(double mouseX, double mouseY) {
        if (this.grid.getGridType() != GridType.CRAFTING) {
            return false;
        }
        return RenderUtils.inBounds(130, this.getTopHeight() + this.getVisibleRows() * 18 + 18, 24, 24, mouseX, mouseY);
    }

    public void m_94757_(double mx, double my) {
        this.scrollbar.m_94757_(mx, my);
        if (this.grid.getGridType() == GridType.PATTERN) {
            this.patternScrollbar.m_94757_(mx, my);
        }
        super.m_94757_(mx, my);
    }

    public boolean m_6348_(double mx, double my, int button) {
        if (this.grid.getGridType() == GridType.PATTERN && this.patternScrollbar.m_6348_(mx, my, button)) {
            return true;
        }
        return this.scrollbar.m_6348_(mx, my, button) || super.m_6348_(mx, my, button);
    }

    public boolean m_6050_(double x, double y, double delta) {
        if (GridScreen.m_96638_() || GridScreen.m_96637_()) {
            if (RS.CLIENT_CONFIG.getGrid().getPreventSortingWhileShiftIsDown()) {
                boolean bl = this.doSort = !this.isOverSlotArea(x - (double)this.f_97735_, y - (double)this.f_97736_) && !this.isOverCraftingOutputArea(x - (double)this.f_97735_, y - (double)this.f_97736_);
            }
            if (this.grid.getGridType() != GridType.FLUID) {
                if (this.isOverInventory(x - (double)this.f_97735_, y - (double)this.f_97736_) && this.f_97734_ != null && this.f_97734_.m_6657_() && ((GridContainerMenu)this.m_6262_()).getDisabledSlotNumber() != this.f_97734_.getSlotIndex()) {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemInventoryScrollMessage(this.f_97734_.getSlotIndex(), GridScreen.m_96638_(), delta > 0.0));
                } else if (this.isOverSlotArea(x - (double)this.f_97735_, y - (double)this.f_97736_)) {
                    RS.NETWORK_HANDLER.sendToServer(new GridItemGridScrollMessage(this.isOverSlotWithStack() ? this.view.getStacks().get(this.slotNumber).getId() : null, GridScreen.m_96638_(), delta > 0.0));
                }
            }
            return super.m_6050_(x, y, delta);
        }
        if (this.grid.getGridType() == GridType.PATTERN && this.isOverPatternArea(x - (double)this.f_97735_, y - (double)this.f_97736_) && this.patternScrollbar.m_6050_(x, y, delta)) {
            return true;
        }
        return this.scrollbar.m_6050_(x, y, delta) || super.m_6050_(x, y, delta);
    }

    private boolean isOverInventory(double x, double y) {
        return RenderUtils.inBounds(8, this.getYPlayerInventory(), 160, 74, x, y);
    }

    private boolean isOverPatternArea(double x, double y) {
        return RenderUtils.inBounds(8, this.getTopHeight() + this.getVisibleRows() * 18, 152, 54, x, y);
    }

    public boolean m_5534_(char unknown1, int unknown2) {
        if (this.searchField.m_5534_(unknown1, unknown2)) {
            return true;
        }
        return super.m_5534_(unknown1, unknown2);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 340 || keyCode == 344 || keyCode == 341 || keyCode == 345) {
            this.view.sort();
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.searchField.m_7933_(key, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public void m_7861_() {
        super.m_7861_();
        if (!RS.CLIENT_CONFIG.getGrid().getRememberSearchQuery()) {
            searchQuery = "";
        }
        this.getView().removed();
    }

    public SearchWidget getSearchField() {
        return this.searchField;
    }

    public void updateExactPattern(boolean checked) {
        if (this.exactPattern != null) {
            this.exactPattern.setChecked(checked);
        }
    }

    private void updatePatternOffsetMax() {
        int filledInputSlots = 0;
        int filledOutputSlots = 0;
        int lastFilledInputSlot = 0;
        int lastFilledOutputSlot = 0;
        for (int i = 0; i < 162; ++i) {
            if (this.isMatrixSlotEmpty(i)) continue;
            if (i > 80) {
                ++filledOutputSlots;
                lastFilledOutputSlot = i - 81 - 1;
                continue;
            }
            ++filledInputSlots;
            lastFilledInputSlot = i;
        }
        int maxFilledSlots = Math.max(filledInputSlots, filledOutputSlots);
        int maxLastFilledSlot = Math.max(lastFilledInputSlot, lastFilledOutputSlot);
        int filledSlotOffset = Math.floorDiv(maxFilledSlots - 1, 3);
        int lastSlotOffset = Math.floorDiv(maxLastFilledSlot, 3) - 2;
        this.patternScrollOffsetMax = Math.max(filledSlotOffset, lastSlotOffset);
    }

    private boolean isMatrixSlotEmpty(int slotNumber) {
        return ((GridNetworkNode)this.grid).getProcessingMatrix().getStackInSlot(slotNumber).m_41619_() && ((GridNetworkNode)this.grid).getProcessingMatrixFluids().getFluid(slotNumber).isEmpty();
    }

    public void updatePatternScrollbar() {
        this.patternScrollbar.setEnabled(this.processingPattern.m_93840_() && this.patternScrollOffsetMax > 0);
        int oldOffset = this.patternScrollbar.getOffset();
        this.patternScrollbar.setMaxOffset(Math.min(this.patternScrollOffsetMax, 24));
        if (oldOffset != this.patternScrollbar.getOffset()) {
            ((GridContainerMenu)this.f_97732_).updatePatternSlotPositions(this.patternScrollbar.getOffset());
        }
    }

    public void updateScrollbar() {
        this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
        this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
    }

    public boolean canSort() {
        return this.doSort || !GridScreen.m_96638_() && !GridScreen.m_96637_();
    }
}

