/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portabletanks;

import com.dremoline.portabletanks.PortableTankBlock;
import com.dremoline.portabletanks.PortableTankType;
import com.supermartijn642.core.block.BaseBlockEntity;
import com.supermartijn642.core.block.TickableBlockEntity;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PortableTankBlockEntity
extends BaseBlockEntity
implements IFluidHandler,
TickableBlockEntity {
    private final PortableTankType type;
    private FluidStack fluidStack = FluidStack.EMPTY;
    private boolean output = false;

    public PortableTankBlockEntity(PortableTankType type, BlockPos pos, BlockState state) {
        super(type.getBlockEntityType(), pos, state);
        this.type = type;
    }

    public PortableTankType getTankType() {
        return this.type;
    }

    public FluidStack getTankContent() {
        return this.fluidStack;
    }

    protected CompoundTag writeData() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("output", this.output);
        compound.m_128365_("fluid", (Tag)this.fluidStack.writeToNBT(new CompoundTag()));
        return compound;
    }

    protected void readData(CompoundTag compound) {
        this.output = compound.m_128471_("output");
        this.fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluid"));
    }

    public void update() {
        BlockEntity entity;
        if (this.output && !this.fluidStack.isEmpty() && (entity = this.f_58857_.m_7702_(this.f_58858_.m_7495_())) != null) {
            entity.getCapability(ForgeCapabilities.FLUID_HANDLER).ifPresent(handler -> FluidUtil.tryFluidTransfer((IFluidHandler)handler, (IFluidHandler)this, (int)1000, (boolean)true));
        }
    }

    public boolean toggleOutput() {
        this.output = !this.output;
        BlockState state = this.m_58900_();
        this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)PortableTankBlock.OUTPUT, (Comparable)Boolean.valueOf(this.output)), 6);
        this.dataChanged();
        return this.output;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return ForgeCapabilities.FLUID_HANDLER.orEmpty(cap, LazyOptional.of(() -> this));
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int tank) {
        return this.fluidStack.copy();
    }

    public int getTankCapacity(int tank) {
        return this.type.tankCapacity.get();
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return true;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.fluidStack.isEmpty() && !this.fluidStack.isFluidEqual(resource)) {
            return 0;
        }
        int amount = Math.min(resource.getAmount(), this.getTankCapacity(0) - this.fluidStack.getAmount());
        if (action.execute()) {
            FluidStack newStack = resource.copy();
            newStack.setAmount(this.fluidStack.getAmount() + amount);
            this.fluidStack = newStack;
            this.dataChanged();
        }
        return amount;
    }

    @Nonnull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || this.fluidStack.isEmpty() || !this.fluidStack.getFluid().m_6212_(resource.getFluid())) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(resource.getAmount(), this.fluidStack.getAmount());
        FluidStack returnStack = this.fluidStack.copy();
        returnStack.setAmount(amount);
        if (action.execute()) {
            this.fluidStack.shrink(amount);
            this.dataChanged();
        }
        return returnStack;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        if (maxDrain <= 0 || this.fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int amount = Math.min(maxDrain, this.fluidStack.getAmount());
        FluidStack returnStack = this.fluidStack.copy();
        returnStack.setAmount(amount);
        if (action.execute()) {
            this.fluidStack.shrink(amount);
            this.dataChanged();
        }
        return returnStack;
    }

    public boolean interactWithItemFluidHandler(IFluidHandlerItem fluidHandler, Player player) {
        if (fluidHandler.getTanks() == 0) {
            return false;
        }
        FluidStack tankFluid = fluidHandler.getFluidInTank(0);
        if (tankFluid.isEmpty()) {
            int amount;
            if (!this.fluidStack.isEmpty() && fluidHandler.isFluidValid(0, this.fluidStack) && (amount = fluidHandler.fill(this.fluidStack.copy(), IFluidHandler.FluidAction.EXECUTE)) > 0) {
                this.fluidStack.getFluid().m_142520_().ifPresent(arg_0 -> ((Player)player).m_216990_(arg_0));
                this.fluidStack.shrink(amount);
                this.dataChanged();
                return true;
            }
        } else if (this.fluidStack.isEmpty() || this.fluidStack.isFluidEqual(tankFluid)) {
            tankFluid = tankFluid.copy();
            tankFluid.setAmount(this.getTankCapacity(0) - this.fluidStack.getAmount());
            FluidStack amount = fluidHandler.drain(tankFluid, IFluidHandler.FluidAction.SIMULATE);
            if (!amount.isEmpty() && (this.fluidStack.isEmpty() || this.fluidStack.isFluidEqual(amount))) {
                amount = fluidHandler.drain(tankFluid, IFluidHandler.FluidAction.EXECUTE);
                amount.grow(this.fluidStack.getAmount());
                this.fluidStack = amount;
                SoundEvent soundEvent = this.fluidStack.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY);
                if (soundEvent != null) {
                    player.m_216990_(soundEvent);
                }
                this.dataChanged();
                return true;
            }
        }
        return false;
    }
}

