/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portabletanks;

import com.dremoline.portabletanks.PortableTankType;
import com.dremoline.portabletanks.PortableTanks;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public class PortableTankItem
extends BaseBlockItem {
    private final PortableTankType type;

    public PortableTankItem(PortableTankType type) {
        super((Block)type.getBlock(), ItemProperties.create().group((CreativeModeTab)PortableTanks.GROUP));
        this.type = type;
    }

    protected void appendItemInformation(ItemStack stack, @Nullable BlockGetter level, Consumer<Component> info, boolean advanced) {
        FluidStack fluidStack = FluidStack.EMPTY;
        if (stack.m_41784_().m_128441_("tileData")) {
            fluidStack = FluidStack.loadFluidStackFromNBT((CompoundTag)stack.m_41784_().m_128469_("tileData").m_128469_("fluid"));
        }
        MutableComponent capacity = TextComponents.string((String)Integer.toString(this.type.tankCapacity.get())).color(ChatFormatting.GOLD).get();
        if (fluidStack.isEmpty()) {
            info.accept((Component)TextComponents.translation((String)"portabletanks.portable_tank.info.capacity", (Object[])new Object[]{capacity}).color(ChatFormatting.GRAY).get());
        } else {
            MutableComponent fluidName = TextComponents.fromTextComponent((Component)fluidStack.getDisplayName()).color(ChatFormatting.GOLD).get();
            MutableComponent amount = TextComponents.string((String)Integer.toString(fluidStack.getAmount())).color(ChatFormatting.GOLD).get();
            info.accept((Component)TextComponents.translation((String)"portabletanks.portable_tank.info.stored", (Object[])new Object[]{fluidName, amount, capacity}).color(ChatFormatting.GRAY).get());
        }
        super.appendItemInformation(stack, level, info, advanced);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new ItemFluidHandler(stack, this.type);
    }

    public static class ItemFluidHandler
    implements ICapabilityProvider,
    IFluidHandlerItem {
        private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
        private final ItemStack stack;
        private final PortableTankType type;

        public ItemFluidHandler(ItemStack stack, PortableTankType type) {
            this.stack = stack;
            this.type = type;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            return this.getFluid().copy();
        }

        public int getTankCapacity(int tank) {
            return this.type.tankCapacity.get();
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return true;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource == null || resource.isEmpty()) {
                return 0;
            }
            FluidStack current = this.getFluid();
            if (!current.isEmpty() && !current.isFluidEqual(resource)) {
                return 0;
            }
            int amount = Math.min(resource.getAmount(), this.getTankCapacity(0) - current.getAmount());
            if (action.execute()) {
                FluidStack newStack = resource.copy();
                newStack.setAmount(current.getAmount() + amount);
                this.setFluid(newStack);
            }
            return amount;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource == null || resource.isEmpty()) {
                return FluidStack.EMPTY;
            }
            FluidStack current = this.getFluid();
            if (current.isEmpty() || !current.isFluidEqual(resource)) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(current.getAmount(), resource.getAmount());
            if (action.execute()) {
                FluidStack newStack = current.copy();
                newStack.shrink(amount);
                this.setFluid(newStack);
            }
            current.setAmount(amount);
            return current;
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (maxDrain == 0) {
                return FluidStack.EMPTY;
            }
            FluidStack current = this.getFluid();
            if (current.isEmpty()) {
                return FluidStack.EMPTY;
            }
            int amount = Math.min(current.getAmount(), maxDrain);
            if (action.execute()) {
                FluidStack newStack = current.copy();
                newStack.shrink(amount);
                this.setFluid(newStack);
            }
            current.setAmount(amount);
            return current;
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.stack;
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            return ForgeCapabilities.FLUID_HANDLER_ITEM.orEmpty(capability, this.holder);
        }

        private FluidStack getFluid() {
            CompoundTag compound = this.stack.m_41784_().m_128469_("tileData");
            return compound.m_128441_("fluid") ? FluidStack.loadFluidStackFromNBT((CompoundTag)compound.m_128469_("fluid")) : FluidStack.EMPTY;
        }

        private void setFluid(FluidStack fluid) {
            CompoundTag tileData = this.stack.m_41784_().m_128469_("tileData");
            tileData.m_128365_("fluid", (Tag)fluid.writeToNBT(new CompoundTag()));
            this.stack.m_41784_().m_128365_("tileData", (Tag)tileData);
        }
    }
}

