/*
 * Decompiled with CFR 0.152.
 */
package com.dremoline.portabletanks.compatibility;

import com.dremoline.portabletanks.PortableTankBlockEntity;
import com.supermartijn642.core.TextComponents;
import java.util.function.Function;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;

public class PortableTanksTheOneProbePlugin {
    public static void interModEnqueue(InterModEnqueueEvent e) {
        InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", () -> new ProbeInfoProvider());
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider,
    Function<ITheOneProbe, Void> {
        @Override
        public Void apply(ITheOneProbe theOneProbe) {
            theOneProbe.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
            return null;
        }

        public ResourceLocation getID() {
            return new ResourceLocation("portabletanks", "portable_tank_component");
        }

        public void addProbeInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player player, Level level, BlockState blockState, IProbeHitData probeHitData) {
            BlockEntity entity = level.m_7702_(probeHitData.getPos());
            if (entity instanceof PortableTankBlockEntity) {
                int capacity = ((PortableTankBlockEntity)entity).getTankType().tankCapacity.get();
                FluidStack contents = ((PortableTankBlockEntity)entity).getTankContent();
                MutableComponent capacityText = TextComponents.number((int)capacity).color(ChatFormatting.GOLD).get();
                if (contents.isEmpty()) {
                    MutableComponent text = TextComponents.translation((String)"portabletanks.portable_tank.info.capacity", (Object[])new Object[]{capacityText}).get();
                    probeInfo.vertical().text((Component)text);
                } else {
                    MutableComponent amountText = TextComponents.number((int)contents.getAmount()).color(ChatFormatting.GOLD).get();
                    MutableComponent fluidName = TextComponents.fluidStack((FluidStack)contents).color(ChatFormatting.GOLD).get();
                    MutableComponent text = TextComponents.translation((String)"portabletanks.portable_tank.info.stored", (Object[])new Object[]{fluidName, amountText, capacityText}).get();
                    probeInfo.vertical().text((Component)text);
                }
            }
        }
    }
}

