/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.action;

import com.blamejared.jeitweaker.common.JeiTweakerInitializer;
import com.blamejared.jeitweaker.common.api.action.JeiTweakerAction;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.blamejared.jeitweaker.common.util.UnintuitiveApiHelper;
import java.util.Objects;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;

public final class HideCategoryAction
extends JeiTweakerAction {
    private final ResourceLocation categoryId;

    private HideCategoryAction(ResourceLocation categoryId) {
        this.categoryId = categoryId;
    }

    public static HideCategoryAction of(ResourceLocation categoryName) {
        Objects.requireNonNull(categoryName, "categoryName");
        return new HideCategoryAction(categoryName);
    }

    public void apply() {
        this.enqueueCommand(JeiCommand.of(JeiCommandTypes.GENERAL, this::hide));
    }

    public String describe() {
        return "Hiding JEI category with id '%s'".formatted(this.categoryId);
    }

    private void hide(IJeiRuntime runtime) {
        IRecipeManager manager = runtime.getRecipeManager();
        manager.createRecipeCategoryLookup().includeHidden().get().filter(it -> this.categoryId.equals((Object)UnintuitiveApiHelper.getRecipeCategoryId(it))).findAny().ifPresentOrElse(it -> UnintuitiveApiHelper.hideCategory(it, manager), this::warn);
    }

    private void warn() {
        JeiTweakerInitializer.get().jeiTweakerLogger().warn("No JEI category with ID '{}' was found for hiding: command skipped", (Object)this.categoryId);
    }
}

