/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.action;

import com.blamejared.jeitweaker.common.api.action.JeiTweakerAction;
import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientTypes;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredients;
import it.unimi.dsi.fastutil.Pair;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.resources.ResourceLocation;

public final class HideModIngredientsAction
extends JeiTweakerAction {
    private final String mod;
    private final Predicate<String> inclusionFilter;

    private HideModIngredientsAction(String mod, Predicate<String> inclusionFilter) {
        this.mod = mod;
        this.inclusionFilter = inclusionFilter;
    }

    public static HideModIngredientsAction of(String mod, Predicate<String> exclusionFilter) {
        return new HideModIngredientsAction(Objects.requireNonNull(mod, "mod"), Objects.requireNonNull(exclusionFilter, "exclusionFilter").negate());
    }

    public void apply() {
        this.enqueueCommand(JeiCommand.of(JeiCommandTypes.GENERAL, this::hide));
    }

    public String describe() {
        return "Hiding all ingredients from mod %s from JEI".formatted(this.mod);
    }

    private void hide(IJeiRuntime runtime) {
        IIngredientManager manager = runtime.getIngredientManager();
        Predicate<ResourceLocation> mergedFilter = it -> this.mod.equals(it.m_135827_()) && this.inclusionFilter.test(it.m_135815_());
        manager.getRegisteredIngredientTypes().stream().flatMap(type -> this.ingredientsOfType(manager, (IIngredientType)type)).map(ingredient -> Pair.of((Object)JeiIngredients.toRegistryName(ingredient), (Object)ingredient)).filter(it -> mergedFilter.test((ResourceLocation)it.first())).map(Pair::value).collect(Collectors.groupingBy(JeiIngredients::jeiIngredientTypeOf, Collectors.mapping(JeiIngredient::jeiContent, Collectors.toList()))).forEach((type, ingredient) -> this.doHide(manager, (IIngredientType)type, (List)ingredient));
    }

    private <J, Z> Stream<JeiIngredient<J, Z>> ingredientsOfType(IIngredientManager manager, IIngredientType<J> ingredientType) {
        return Stream.ofNullable(JeiIngredientTypes.fromJeiTypeOrNull(ingredientType)).flatMap(type -> manager.getAllIngredients(ingredientType).stream().map(it -> JeiIngredient.ofJei(type, it)));
    }

    private <J> void doHide(IIngredientManager manager, IIngredientType<J> type, List<J> ingredients) {
        if (ingredients.isEmpty()) {
            return;
        }
        manager.removeIngredientsAtRuntime(type, ingredients);
    }
}

