/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.api.command;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.jeitweaker.common.api.command.JeiCommandTypes;
import com.google.common.reflect.TypeToken;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public final class JeiCommandType<T> {
    private static final Map<String, JeiCommandType<?>> CATALOG_TYPE_CATALOG = new Object2ObjectArrayMap();
    private static final Collection<JeiCommandType<?>> VALUES = Collections.unmodifiableCollection(CATALOG_TYPE_CATALOG.values());
    private final String id;
    private final TypeToken<T> argumentType;

    private JeiCommandType(String id, TypeToken<T> argumentType) {
        this.id = id;
        this.argumentType = argumentType;
    }

    public static <T> JeiCommandType<T> of(String id) {
        return (JeiCommandType)GenericUtil.uncheck(CATALOG_TYPE_CATALOG.get(id));
    }

    public static Collection<JeiCommandType<?>> values() {
        return VALUES;
    }

    static <T> JeiCommandType<T> of(String id, Class<T> argumentType) {
        return JeiCommandType.of(id, TypeToken.of(argumentType));
    }

    static <T> JeiCommandType<T> of(String id, TypeToken<T> argumentType) {
        JeiCommandType<T> type = new JeiCommandType<T>(id, argumentType);
        CATALOG_TYPE_CATALOG.put(id, type);
        return type;
    }

    public String id() {
        return this.id;
    }

    public TypeToken<T> argumentType() {
        return this.argumentType;
    }

    public String toString() {
        return "JeiCommandType[%s@%s]".formatted(this.id(), this.argumentType());
    }

    static {
        JeiCommandTypes.init();
    }
}

