/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.api.ingredient;

import com.google.common.reflect.TypeToken;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;

public final class JeiIngredientType<J, Z> {
    private final ResourceLocation id;
    private final TypeToken<J> jeiType;
    private final TypeToken<Z> zenType;

    private JeiIngredientType(ResourceLocation id, TypeToken<J> jeiType, TypeToken<Z> zenType) {
        this.id = id;
        this.jeiType = jeiType;
        this.zenType = zenType;
    }

    public static <J, Z> JeiIngredientType<J, Z> of(ResourceLocation id, Class<J> jeiType, Class<Z> zenType) {
        return JeiIngredientType.of(id, TypeToken.of(jeiType), TypeToken.of(zenType));
    }

    public static <J, Z> JeiIngredientType<J, Z> of(ResourceLocation id, Class<J> jeiType, TypeToken<Z> zenType) {
        return JeiIngredientType.of(id, TypeToken.of(jeiType), zenType);
    }

    public static <J, Z> JeiIngredientType<J, Z> of(ResourceLocation id, TypeToken<J> jeiType, Class<Z> zenType) {
        return JeiIngredientType.of(id, jeiType, TypeToken.of(zenType));
    }

    public static <J, Z> JeiIngredientType<J, Z> of(ResourceLocation id, TypeToken<J> jeiType, TypeToken<Z> zenType) {
        Objects.requireNonNull(id, "id");
        Objects.requireNonNull(jeiType, "jeiType");
        Objects.requireNonNull(zenType, "zenType");
        return new JeiIngredientType<J, Z>(id, jeiType, zenType);
    }

    public ResourceLocation id() {
        return this.id;
    }

    public TypeToken<J> jeiType() {
        return this.jeiType;
    }

    public TypeToken<Z> zenType() {
        return this.zenType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JeiIngredientType that = (JeiIngredientType)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "JeiIngredientType[%s]{%s->%s}".formatted(this.id(), this.jeiType(), this.zenType());
    }
}

