/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.api.ingredient;

import com.blamejared.jeitweaker.common.api.JeiTweakerApi;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientConverter;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.resources.ResourceLocation;

public final class JeiIngredientTypes {
    private JeiIngredientTypes() {
    }

    public static <J, Z> JeiIngredientType<J, Z> findById(ResourceLocation id) {
        return JeiTweakerApi.get().ingredientTypeFromIdentifier(id);
    }

    public static <J, Z> JeiIngredientType<J, Z> fromJeiType(IIngredientType<J> jeiType) {
        return Objects.requireNonNull(JeiIngredientTypes.fromJeiTypeOrNull(jeiType), () -> "Unknown type " + jeiType + " (class " + jeiType.getIngredientClass().getName() + ")");
    }

    public static <J, Z> JeiIngredientType<J, Z> fromJeiTypeOrNull(IIngredientType<J> jeiType) {
        return JeiTweakerApi.get().ingredientTypeFromJei(jeiType);
    }

    public static <J, Z> JeiIngredientConverter<J, Z> converterFor(JeiIngredientType<J, Z> type) {
        return JeiTweakerApi.get().ingredientConverterFromIngredientType(type);
    }

    public static <J, Z> IIngredientType<J> toJeiType(JeiIngredientType<J, Z> type) {
        return JeiTweakerApi.get().jeiFromIngredientType(type);
    }
}

