/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.command;

import com.blamejared.jeitweaker.common.api.command.JeiCommand;
import com.blamejared.jeitweaker.common.api.command.JeiCommandType;
import com.blamejared.jeitweaker.common.command.CommandGeneration;
import com.blamejared.jeitweaker.common.command.GenerativeCommand;
import com.blamejared.jeitweaker.common.command.TypedCommandQueues;

public final class CommandManager {
    private final CommandGeneration generation = CommandGeneration.of();
    private final TypedCommandQueues queues = TypedCommandQueues.of(JeiCommandType.values());

    private CommandManager() {
    }

    public static CommandManager of() {
        return new CommandManager();
    }

    public <T> void enqueueCommand(JeiCommand<T> command) {
        this.generation.awaitingReproduction(newGeneration -> this.queues.queueFor(command.type()).add(new GenerativeCommand(command, newGeneration)));
    }

    public void populateCommands() {
        this.generation.reproduce();
    }

    public <T> void executeCommands(JeiCommandType<T> type, T argument) {
        this.queues.queueFor(type).runCommands(this.generation.currentGeneration(), argument);
    }
}

