/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.ingredient;

import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredient;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientConverter;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientTypes;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
abstract class SimpleJeiIngredient<J, Z>
implements JeiIngredient<J, Z> {
    private final JeiIngredientType<J, Z> type;

    protected SimpleJeiIngredient(JeiIngredientType<J, Z> type) {
        this.type = Objects.requireNonNull(type, "type");
    }

    @Override
    public final JeiIngredientType<J, Z> type() {
        return this.type;
    }

    protected final JeiIngredientConverter<J, Z> converter() {
        return JeiIngredientTypes.converterFor(this.type());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JeiIngredient)) {
            return false;
        }
        JeiIngredient ingredient = (JeiIngredient)obj;
        return Objects.equals(this.type(), ingredient.type()) && (Objects.equals(this.jeiContent(), ingredient.jeiContent()) || Objects.equals(this.zenContent(), ingredient.zenContent()));
    }

    public int hashCode() {
        return Objects.hashCode(this.type());
    }

    @Override
    public final String toString() {
        return this.converter().toCommandStringFromJei(this.jeiContent());
    }
}

