/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.jeitweaker.common.registry;

import com.blamejared.crafttweaker.api.util.GenericUtil;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientConverter;
import com.blamejared.jeitweaker.common.api.ingredient.JeiIngredientType;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Objects;
import mezz.jei.api.ingredients.IIngredientType;
import net.minecraft.resources.ResourceLocation;

public final class JeiIngredientTypeRegistry {
    private final BiMap<ResourceLocation, JeiIngredientType<?, ?>> ingredientTypes = HashBiMap.create();
    private final BiMap<IIngredientType<?>, JeiIngredientType<?, ?>> jeiIngredientTypesMapping = HashBiMap.create();
    private final BiMap<JeiIngredientType<?, ?>, IIngredientType<?>> jeiIngredientTypesMappingInverseView = this.jeiIngredientTypesMapping.inverse();
    private final Map<JeiIngredientType<?, ?>, JeiIngredientConverter<?, ?>> converters = new Object2ObjectOpenHashMap();

    JeiIngredientTypeRegistry() {
    }

    public <J, Z> void register(JeiIngredientType<J, Z> type, JeiIngredientConverter<J, Z> converter, IIngredientType<J> jeiType) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(converter, "converter");
        Objects.requireNonNull(jeiType, "jeiType");
        if (!type.jeiType().isSubtypeOf((Type)jeiType.getIngredientClass())) {
            throw new IllegalArgumentException("Type " + type + " does not match the JEI type " + jeiType + ", nor it is a subtype");
        }
        if (this.ingredientTypes.containsValue(type)) {
            throw new IllegalArgumentException("Type " + type + " has already been registered");
        }
        ResourceLocation id = type.id();
        if (this.ingredientTypes.containsKey((Object)id)) {
            throw new IllegalArgumentException("A type with the same id " + id + " has already been registered");
        }
        this.ingredientTypes.put((Object)id, type);
        this.jeiIngredientTypesMapping.put(jeiType, type);
        this.converters.put(type, converter);
    }

    public <J, Z> JeiIngredientType<J, Z> findById(ResourceLocation id) {
        return (JeiIngredientType)this.queryMap((Map)this.ingredientTypes, (Object)id);
    }

    public <J, Z> JeiIngredientType<J, Z> findByJeiTypeOrNull(IIngredientType<J> jeiType) {
        return (JeiIngredientType)GenericUtil.uncheck((Object)this.jeiIngredientTypesMapping.get(jeiType));
    }

    public <J, Z> JeiIngredientConverter<J, Z> converterFor(JeiIngredientType<J, Z> type) {
        return (JeiIngredientConverter)this.queryMap(this.converters, type);
    }

    public <J, Z> IIngredientType<J> jeiTypeOf(JeiIngredientType<J, Z> type) {
        return (IIngredientType)this.queryMap((Map)this.jeiIngredientTypesMappingInverseView, (Object)type);
    }

    private <K, V, R extends V, T extends K> R queryMap(Map<K, V> map, T key) {
        return (R)GenericUtil.uncheck((Object)map.computeIfAbsent(Objects.requireNonNull(key, "key"), it -> {
            throw new IllegalArgumentException("No known Jei ingredient type mapped by " + it);
        }));
    }
}

