/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.flopper.block;

import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.InventoryHelpers;
import org.cyclops.flopper.RegistryEntries;
import org.cyclops.flopper.block.BlockFlopperConfig;
import org.cyclops.flopper.blockentity.BlockEntityFlopper;

public class BlockFlopper
extends BlockWithEntity {
    public static final DirectionProperty FACING = BlockStateProperties.f_61373_;
    public static final BooleanProperty ENABLED = BlockStateProperties.f_61431_;
    private static final VoxelShape INPUT_SHAPE = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)10.0, (double)12.0);
    private static final VoxelShape INPUT_MIDDLE_SHAPE = Shapes.m_83110_((VoxelShape)MIDDLE_SHAPE, (VoxelShape)INPUT_SHAPE);
    private static final VoxelShape BASE_SHAPE = Shapes.m_83113_((VoxelShape)INPUT_MIDDLE_SHAPE, (VoxelShape)Hopper.f_59296_, (BooleanOp)BooleanOp.f_82685_);
    private static final VoxelShape DOWN_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0));
    private static final VoxelShape EAST_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)12.0, (double)4.0, (double)6.0, (double)16.0, (double)8.0, (double)10.0));
    private static final VoxelShape NORTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)0.0, (double)10.0, (double)8.0, (double)4.0));
    private static final VoxelShape SOUTH_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)6.0, (double)4.0, (double)12.0, (double)10.0, (double)8.0, (double)16.0));
    private static final VoxelShape WEST_SHAPE = Shapes.m_83110_((VoxelShape)BASE_SHAPE, (VoxelShape)Block.m_49796_((double)0.0, (double)4.0, (double)6.0, (double)4.0, (double)8.0, (double)10.0));
    private static final VoxelShape DOWN_RAYTRACE_SHAPE = Hopper.f_59296_;
    private static final VoxelShape EAST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)12.0, (double)8.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0));
    private static final VoxelShape NORTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0));
    private static final VoxelShape SOUTH_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0));
    private static final VoxelShape WEST_RAYTRACE_SHAPE = Shapes.m_83110_((VoxelShape)Hopper.f_59296_, (VoxelShape)Block.m_49796_((double)0.0, (double)8.0, (double)6.0, (double)4.0, (double)10.0, (double)10.0));

    public BlockFlopper(BlockBehaviour.Properties properties, BiFunction<BlockPos, BlockState, CyclopsBlockEntity> blockEntitySupplier) {
        super(properties, blockEntitySupplier);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : BlockFlopper.m_152132_(blockEntityType, RegistryEntries.BLOCK_ENTITY_FLOPPER, (BlockEntityTicker)new BlockEntityFlopper.Ticker());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ENABLED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return DOWN_SHAPE;
            }
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
            case EAST: {
                return EAST_SHAPE;
            }
        }
        return BASE_SHAPE;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case DOWN: {
                return DOWN_RAYTRACE_SHAPE;
            }
            case NORTH: {
                return NORTH_RAYTRACE_SHAPE;
            }
            case SOUTH: {
                return SOUTH_RAYTRACE_SHAPE;
            }
            case WEST: {
                return WEST_RAYTRACE_SHAPE;
            }
            case EAST: {
                return EAST_RAYTRACE_SHAPE;
            }
        }
        return Hopper.f_59296_;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43719_().m_122424_();
        if (direction == Direction.UP) {
            direction = Direction.DOWN;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(true));
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
        this.updateState(worldIn, pos, state);
    }

    private void updateState(Level worldIn, BlockPos pos, BlockState state) {
        boolean notPowered;
        boolean bl = notPowered = !worldIn.m_276867_(pos);
        if (notPowered != (Boolean)state.m_61143_((Property)ENABLED)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)ENABLED, (Comparable)Boolean.valueOf(notPowered)), 4);
        }
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    public InteractionResult m_6227_(BlockState blockState, Level world, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
        InteractionResult activatedSuper = super.m_6227_(blockState, world, blockPos, player, hand, rayTraceResult);
        if (activatedSuper.m_19077_()) {
            return activatedSuper;
        }
        return BlockEntityHelpers.getCapability((BlockGetter)world, (BlockPos)blockPos, (Capability)ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> {
            ItemStack itemStack = player.m_21120_(hand);
            if (itemStack.m_41619_()) {
                if (BlockFlopperConfig.showContentsStatusMessageOnClick) {
                    FluidStack fluidStack = fluidHandler.drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE);
                    if (fluidStack.isEmpty()) {
                        player.m_5661_((Component)Component.m_237113_((String)("0 / " + String.format("%,d", fluidHandler.getTankCapacity(0)))), true);
                    } else {
                        player.m_5661_((Component)Component.m_237115_((String)fluidStack.getTranslationKey()).m_7220_((Component)Component.m_237113_((String)(": " + String.format("%,d", fluidStack.getAmount()) + " / " + String.format("%,d", fluidHandler.getTankCapacity(0))))), true);
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (!player.m_6047_() && BlockFlopper.tryEmptyContainer(itemStack, fluidHandler, 1000, player, false).isSuccess()) {
                    FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (Player)player, (boolean)true);
                    if (result.isSuccess()) {
                        ItemStack drainedItem = result.getResult();
                        if (!player.m_7500_()) {
                            InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)drainedItem, (InteractionHand)hand);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
                if (player.m_6047_() && FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (Player)player, (boolean)false).isSuccess()) {
                    FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)itemStack, (IFluidHandler)fluidHandler, (int)1000, (Player)player, (boolean)true);
                    if (result.isSuccess()) {
                        ItemStack filledItem = result.getResult();
                        if (!player.m_7500_()) {
                            InventoryHelpers.tryReAddToStack((Player)player, (ItemStack)itemStack, (ItemStack)filledItem, (InteractionHand)hand);
                        }
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    @Nonnull
    public static FluidActionResult tryEmptyContainer(@Nonnull ItemStack container, IFluidHandler fluidDestination, int maxAmount, @Nullable Player player, boolean doDrain) {
        ItemStack containerCopy = ItemHandlerHelper.copyStackWithSize((ItemStack)container, (int)1);
        return FluidUtil.getFluidHandler((ItemStack)containerCopy).map(containerFluidHandler -> {
            SoundEvent soundevent;
            FluidStack transfer = FluidUtil.tryFluidTransfer((IFluidHandler)fluidDestination, (IFluidHandler)containerFluidHandler, (int)maxAmount, (boolean)doDrain);
            if (transfer.isEmpty()) {
                return FluidActionResult.FAILURE;
            }
            if (doDrain && player != null && (soundevent = transfer.getFluid().getFluidType().getSound(SoundActions.BUCKET_EMPTY)) != null) {
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            ItemStack resultContainer = containerFluidHandler.getContainer();
            return new FluidActionResult(resultContainer);
        }).orElse(FluidActionResult.FAILURE);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return BlockEntityHelpers.get((BlockGetter)worldIn, (BlockPos)pos, BlockEntityFlopper.class).map(tile -> tile.getTank().getFluidAmount() * 8 / tile.getTank().getCapacity()).orElse(0);
    }

    @SubscribeEvent
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getItemStack().m_41619_() && event.getLevel().m_8055_(event.getPos()).m_60734_() == this && event.getItemStack().getCapability(ForgeCapabilities.FLUID_HANDLER).isPresent()) {
            event.setUseBlock(Event.Result.ALLOW);
        }
    }
}

