/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.api.radiation.RadiationPacket;
import it.zerono.mods.extremereactors.api.reactor.IHeatEntity;
import it.zerono.mods.extremereactors.api.reactor.radiation.IRadiationModerator;
import it.zerono.mods.extremereactors.api.reactor.radiation.IrradiationData;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.IReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.network.UpdateClientsFuelRodsLayout;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.IMultiblockReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockVariantProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;

public abstract class AbstractReactorEntity
extends AbstractMultiblockEntity<MultiblockReactor>
implements IHeatEntity,
IRadiationModerator,
IMultiblockPartTypeProvider<MultiblockReactor, IReactorPartType>,
IMultiblockVariantProvider<IMultiblockReactorVariant> {
    private static CuboidPartVariantsModelDataCache[] s_modelDataCaches;

    public AbstractReactorEntity(BlockEntityType<?> type, BlockPos position, BlockState blockState) {
        super(type, position, blockState);
    }

    protected boolean isReactorActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockReactor::isMachineActive).orElse(false);
    }

    protected void setReactorActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public Component getPartDisplayName() {
        return Component.m_237110_((String)"gui.bigreactors.multiblock_variant_part_format.title", (Object[])new Object[]{Component.m_237115_((String)this.getMultiblockVariant().map(IMultiblockVariant::getTranslationKey).orElse("unknown")), Component.m_237115_((String)this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"))});
    }

    protected ModelData getUpdatedModelData() {
        return CodeHelper.optionalMap((Optional)this.getMultiblockVariant(), (Optional)this.getPartType(), this::getUpdatedModelData).orElse(ModelData.EMPTY);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public void onUpdateClientsFuelRodsLayout(UpdateClientsFuelRodsLayout message) {
        this.executeOnController(c -> c.onUpdateClientsFuelRodsLayout(message));
    }

    @Override
    public double getHeat() {
        return (Double)this.evalOnController(c -> c.getFuelHeatValue().getAsDouble(), 0.0);
    }

    @Override
    public double getThermalConductivity() {
        return 0.6f;
    }

    @Override
    public void moderateRadiation(IrradiationData irradiationData, RadiationPacket radiation) {
        radiation.intensity = 0.0f;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        BlockPos coordinates = this.getWorldPosition();
        if (position.isFrame()) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockReactor createController() {
        Level myWorld = this.m_58904_();
        if (null == myWorld) {
            throw new RuntimeException("Trying to create a Controller from a Part without a Level");
        }
        return new MultiblockReactor(this.m_58904_(), this.getMultiblockVariant().orElse(ReactorVariant.Basic));
    }

    public Class<MultiblockReactor> getControllerType() {
        return MultiblockReactor.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected ModelData getUpdatedModelData(IMultiblockReactorVariant variant, IMultiblockPartType partType) {
        return AbstractReactorEntity.getVariantModelDataCache(variant).computeIfAbsent((int)partType.getByteHashCode(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings());
    }

    private static CuboidPartVariantsModelDataCache getVariantModelDataCache(IMultiblockReactorVariant variant) {
        if (null == s_modelDataCaches) {
            s_modelDataCaches = new CuboidPartVariantsModelDataCache[ReactorVariant.values().length];
        }
        if (null == s_modelDataCaches[variant.getId()]) {
            AbstractReactorEntity.s_modelDataCaches[variant.getId()] = new CuboidPartVariantsModelDataCache();
        }
        return s_modelDataCaches[variant.getId()];
    }
}

