/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.computer;

import com.google.common.collect.Maps;
import it.zerono.mods.extremereactors.gamecontent.multiblock.IMachineReader;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.VentSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineComputerPortEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.compat.computer.ComputerMethod;
import it.zerono.mods.zerocore.lib.compat.computer.LuaHelper;
import it.zerono.mods.zerocore.lib.compat.computer.MultiblockComputerPeripheral;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.fluid.FluidHelper;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockPart;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.NonNullConsumer;

public class TurbineComputerPeripheral
extends MultiblockComputerPeripheral<MultiblockTurbine, TurbineComputerPortEntity> {
    public TurbineComputerPeripheral(TurbineComputerPortEntity computerPort) {
        super((AbstractMultiblockPart)computerPort);
    }

    public String getPeripheralStaticName() {
        return "extremereactor-turbineComputerPort";
    }

    public void populateMethods(NonNullConsumer<ComputerMethod<MultiblockComputerPeripheral<MultiblockTurbine, TurbineComputerPortEntity>>> methodConsumer) {
        super.populateMethods(methodConsumer);
        methodConsumer.accept((Object)new ComputerMethod("getVariant", this.wrapControllerValue(c -> c.getVariant().getName())));
        methodConsumer.accept((Object)new ComputerMethod("getActive", this.wrapControllerValue(IMachineReader::isMachineActive)));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyProducedLastTick", this.wrapControllerValue(MultiblockTurbine::getEnergyGeneratedLastTick)));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStored", this.wrapControllerValue(c -> c.getEnergyStored(c.getOutputEnergySystem()).doubleValue())));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStoredAsText", this.wrapControllerValue(c -> {
            EnergySystem sys = c.getOutputEnergySystem();
            return CodeHelper.formatAsHumanReadableNumber((double)c.getEnergyStored(sys).doubleValue(), (String)sys.getUnit());
        })));
        methodConsumer.accept((Object)new ComputerMethod("getFluidAmountMax", this.wrapControllerValue(c -> c.getCapacity())));
        methodConsumer.accept((Object)new ComputerMethod("getFluidFlowRate", this.wrapControllerValue(MultiblockTurbine::getFluidConsumedLastTick)));
        methodConsumer.accept((Object)new ComputerMethod("getFluidFlowRateMax", this.wrapControllerValue(MultiblockTurbine::getMaxIntakeRate)));
        methodConsumer.accept((Object)new ComputerMethod("getFluidFlowRateMaxMax", this.wrapControllerValue(MultiblockTurbine::getMaxIntakeRateHardLimit)));
        methodConsumer.accept((Object)new ComputerMethod("getInputAmount", this.wrapControllerValue(c -> c.getFluidContainer().getGasAmount())));
        methodConsumer.accept((Object)new ComputerMethod("getInputType", this.wrapControllerValue(c -> TurbineComputerPeripheral.getFluidName(c.getFluidContainer().getGas()))));
        methodConsumer.accept((Object)new ComputerMethod("getOutputAmount", this.wrapControllerValue(c -> c.getFluidContainer().getLiquidAmount())));
        methodConsumer.accept((Object)new ComputerMethod("getOutputType", this.wrapControllerValue(c -> TurbineComputerPeripheral.getFluidName(c.getFluidContainer().getLiquid()))));
        methodConsumer.accept((Object)new ComputerMethod("getRotorSpeed", this.wrapControllerValue(MultiblockTurbine::getRotorSpeed)));
        methodConsumer.accept((Object)new ComputerMethod("getNumberOfBlades", this.wrapControllerValue(MultiblockTurbine::getRotorBladesCount)));
        methodConsumer.accept((Object)new ComputerMethod("getBladeEfficiency", this.wrapControllerValue(c -> Float.valueOf(c.getRotorEfficiencyLastTick() * 100.0f))));
        methodConsumer.accept((Object)new ComputerMethod("getRotorMass", this.wrapControllerValue(MultiblockTurbine::getRotorMass)));
        methodConsumer.accept((Object)new ComputerMethod("getInductorEngaged", this.wrapControllerValue(MultiblockTurbine::isInductorEngaged)));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyCapacity", this.wrapControllerValue(c -> c.getCapacity(c.getOutputEnergySystem()).doubleValue())));
        methodConsumer.accept((Object)new ComputerMethod("getEnergyStats", this.wrapControllerValue(c -> {
            HashMap stats = Maps.newHashMap();
            EnergySystem sys = c.getOutputEnergySystem();
            stats.put("energyStored", c.getEnergyStored(sys).doubleValue());
            stats.put("energyCapacity", c.getCapacity(sys).doubleValue());
            stats.put("energyProducedLastTick", c.getEnergyGeneratedLastTick());
            stats.put("energySystem", sys.getUnit());
            return stats;
        })));
        methodConsumer.accept((Object)new ComputerMethod("setActive", this.wrapControllerAction((c, arguments) -> c.setMachineActive(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0))), 1, true));
        methodConsumer.accept((Object)new ComputerMethod("setFluidFlowRateMax", this.wrapControllerAction((c, arguments) -> c.setMaxIntakeRate(LuaHelper.getIntFromArgs((Object[])arguments, (int)0))), 1, true));
        methodConsumer.accept((Object)new ComputerMethod("setVentNone", this.wrapControllerAction(c -> c.setVentSetting(VentSetting.DoNotVent)), 0, true));
        methodConsumer.accept((Object)new ComputerMethod("setVentOverflow", this.wrapControllerAction(c -> c.setVentSetting(VentSetting.VentOverflow)), 0, true));
        methodConsumer.accept((Object)new ComputerMethod("setVentAll", this.wrapControllerAction(c -> c.setVentSetting(VentSetting.VentAll)), 0, true));
        methodConsumer.accept((Object)new ComputerMethod("setInductorEngaged", this.wrapControllerAction((c, arguments) -> c.setInductorEngaged(LuaHelper.getBooleanFromArgs((Object[])arguments, (int)0))), 1, true));
    }

    private static String getFluidName(Optional<Fluid> fluid) {
        return fluid.map(FluidHelper::getFluidName).map(Component::getString).orElse("");
    }
}

