/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.packedup;

import com.supermartijn642.packedup.BackpackInventory;
import com.supermartijn642.packedup.BackpackItem;
import com.supermartijn642.packedup.BackpackType;
import com.supermartijn642.packedup.PackedUpConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class BackpackStorageManager {
    private static File directory;
    private static long lastSaveTimestamp;
    private static final HashMap<Integer, BackpackInventory> inventories;
    private static int inventoryIndex;
    public static final Supplier<Integer> maxLayers;

    @SubscribeEvent
    public static void onLevelSave(LevelEvent.Save event) {
        if (event.getLevel().m_5776_() || !(event.getLevel() instanceof Level) || ((Level)event.getLevel()).m_46472_() != Level.f_46428_ && System.currentTimeMillis() - lastSaveTimestamp < 30000L) {
            return;
        }
        BackpackStorageManager.save();
    }

    @SubscribeEvent
    public static void onLevelLoad(LevelEvent.Load event) {
        if (event.getLevel().m_5776_() || !(event.getLevel() instanceof Level) || ((Level)event.getLevel()).m_46472_() != Level.f_46428_) {
            return;
        }
        ServerLevel world = (ServerLevel)event.getLevel();
        directory = new File(world.m_7654_().m_129843_(LevelResource.f_78182_).toFile(), "packedup/backpacks");
        BackpackStorageManager.load();
    }

    public static BackpackInventory getInventory(int index) {
        File file;
        BackpackInventory inventory = inventories.get(index);
        if (inventory == null && (file = new File(directory, "inventory" + index + ".nbt")).exists()) {
            inventory = new BackpackInventory(false, index);
            inventory.load(file);
            inventories.put(index, inventory);
        }
        return inventory;
    }

    public static int createInventoryIndex(BackpackType type) {
        int index = inventoryIndex++;
        inventories.put(index, new BackpackInventory(false, index, type.getSlots()));
        return index;
    }

    public static void save() {
        directory.mkdirs();
        for (int i : inventories.keySet()) {
            inventories.get(i).save(new File(directory, "inventory" + i + ".nbt"));
        }
        lastSaveTimestamp = System.currentTimeMillis();
    }

    public static void load() {
        int index;
        File[] files = directory.listFiles();
        inventories.clear();
        if (files == null) {
            files = new File[]{};
        }
        int highest = -1;
        for (File file : files) {
            String name = file.getName();
            if (!name.startsWith("inventory") || !name.endsWith(".nbt")) continue;
            try {
                index = Integer.parseInt(name.substring("inventory".length(), name.length() - ".nbt".length()));
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (index > highest) {
                highest = index;
            }
            BackpackInventory inventory = new BackpackInventory(false, index);
            inventory.load(file);
            inventory.bagsThisBagIsIn.clear();
            inventory.bagsThisBagIsDirectlyIn.clear();
            inventory.bagsInThisBag.clear();
            inventory.bagsDirectlyInThisBag.clear();
            inventory.layer = 0;
            inventories.put(index, inventory);
        }
        inventoryIndex = highest + 1;
        for (Map.Entry entry : inventories.entrySet()) {
            BackpackInventory inventory = (BackpackInventory)entry.getValue();
            for (ItemStack stack : inventory.getStacks()) {
                if (!(stack.m_41720_() instanceof BackpackItem) || !stack.m_41784_().m_128441_("packedup:invIndex")) continue;
                index = stack.m_41783_().m_128451_("packedup:invIndex");
                if (!inventories.containsKey(index)) {
                    stack.m_41783_().m_128473_("packedup:invIndex");
                    continue;
                }
                inventory.bagsDirectlyInThisBag.add(index);
                BackpackStorageManager.inventories.get((Object)Integer.valueOf((int)index)).bagsThisBagIsDirectlyIn.add((Integer)entry.getKey());
            }
        }
        for (Map.Entry entry : inventories.entrySet()) {
            BackpackInventory inventory = (BackpackInventory)entry.getValue();
            inventory.layer = BackpackStorageManager.getBagsThisBagIsIn((Integer)entry.getKey(), inventory.bagsThisBagIsIn);
            BackpackStorageManager.getBagsInThisBag((Integer)entry.getKey(), inventory.bagsInThisBag);
        }
        BackpackStorageManager.save();
        inventories.clear();
    }

    private static Integer getBagsThisBagIsIn(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return 0;
        }
        int highest = 0;
        for (int id : BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn) {
            if (bags.contains(id)) continue;
            bags.add(id);
            highest = Math.max(highest, BackpackStorageManager.getBagsThisBagIsIn(id, bags)) + 1;
        }
        return highest;
    }

    private static void getBagsInThisBag(int index, Set<Integer> bags) {
        if (BackpackStorageManager.getInventory(index) == null) {
            return;
        }
        for (int id : BackpackStorageManager.getInventory((int)index).bagsDirectlyInThisBag) {
            if (bags.contains(id)) continue;
            bags.add(id);
            BackpackStorageManager.getBagsInThisBag(id, bags);
        }
    }

    public static void onInsert(int index, int to) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.add(to);
        BackpackStorageManager.getInventory((int)to).bagsDirectlyInThisBag.add(index);
        BackpackStorageManager.updateRelativeBags(index, to);
    }

    public static void onExtract(int index, int from) {
        BackpackStorageManager.getInventory((int)index).bagsThisBagIsDirectlyIn.remove(from);
        BackpackStorageManager.getInventory((int)from).bagsDirectlyInThisBag.remove(index);
        BackpackStorageManager.updateRelativeBags(index, from);
    }

    private static void updateRelativeBags(int child, int parent) {
        BackpackInventory inv;
        BackpackInventory childInventory = BackpackStorageManager.getInventory(child);
        BackpackInventory parentInventory = BackpackStorageManager.getInventory(parent);
        Set<Integer> bagsBefore = parentInventory.bagsThisBagIsIn;
        bagsBefore.add(parent);
        Set<Integer> bagsAfter = childInventory.bagsInThisBag;
        bagsAfter.add(child);
        for (int id : bagsBefore) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsInThisBag.clear();
            BackpackStorageManager.getBagsInThisBag(id, inv.bagsInThisBag);
        }
        for (int id : bagsAfter) {
            inv = BackpackStorageManager.getInventory(id);
            inv.bagsThisBagIsIn.clear();
            inv.layer = BackpackStorageManager.getBagsThisBagIsIn(id, inv.bagsThisBagIsIn);
        }
    }

    static {
        lastSaveTimestamp = 0L;
        inventories = new HashMap();
        inventoryIndex = 0;
        maxLayers = () -> PackedUpConfig.allowBagInBag.get() != false ? PackedUpConfig.maxBagInBagLayer.get() : 0;
    }
}

