/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Registries;

public class ModConfig {
    private static final Logger LOGGER = ModRedstonePen.LOGGER;
    private static final String MODID = "redstonepen";
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    private static final CompoundTag server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;
    private static boolean wihtout_preview_rendering_;

    public static boolean isOptedOut(@Nullable Block block) {
        return ModConfig.isOptedOut(block.m_5456_());
    }

    public static boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(Auxiliaries.getResourceLocation(item).m_135815_());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static boolean withDebugLogging() {
        return with_experimental_features_ && with_config_logging_;
    }

    public static boolean withoutPreviewRendering() {
        return wihtout_preview_rendering_;
    }

    public static CompoundTag getServerConfig() {
        return server_config_;
    }

    private static void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("redstonepen:", "").replaceAll("[^*_,a-z0-9]", "");
        if (!((String)ModConfig.COMMON.pattern_includes.get()).equals(inc)) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("redstonepen:", "").replaceAll("[^*_,a-z0-9]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        Registries.getRegisteredItems().stream().filter(item -> {
            if (item == null) {
                return true;
            }
            try {
                String rn = Auxiliaries.getResourceLocation(item).m_135815_();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(Auxiliaries.getResourceLocation(e).m_135815_()));
        Registries.getRegisteredBlocks().stream().filter(e -> e == null || ModConfig.isOptedOut(e.m_5456_())).forEach(e -> optouts.add(Auxiliaries.getResourceLocation(e).m_135815_()));
        optouts_ = optouts;
        String s = String.join((CharSequence)",", optouts_);
        server_config_.m_128359_("optout", s);
        if (!s.isEmpty()) {
            ModConfig.log("Opt-outs:" + s);
        }
    }

    public static void apply() {
        if (!COMMON_CONFIG_SPEC.isLoaded()) {
            return;
        }
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        wihtout_preview_rendering_ = (Boolean)ModConfig.COMMON.without_preview_rendering.get();
        ModConfig.updateOptouts();
    }

    public static void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        server_config_ = new CompoundTag();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
        wihtout_preview_rendering_ = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.BooleanValue without_preview_rendering;
        public final ForgeConfigSpec.IntValue max_pen_redstone_capacity;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("redstonepen.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("redstonepen.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("redstonepen.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_config_logging = builder.translation("redstonepen.config.with_config_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_config_logging", false);
            this.without_preview_rendering = builder.translation("redstonepen.config.without_preview_rendering").comment("Disable RLC and Relay preview rendering. Can be very useful if optifine is installed.").define("without_preview_rendering", false);
            builder.pop();
            builder.comment("Tweak settings").push("tweaks");
            this.max_pen_redstone_capacity = builder.translation("redstonepen.config.max_pen_redstone_capacity").comment("Defines how much redstone can be stored in the pen. Use 0 to force using redstone from your inventory.").defineInRange("max_pen_redstone_capacity", 0, 0, 256);
            builder.pop();
        }
    }
}

