/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen;

import com.mojang.logging.LogUtils;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import wile.redstonepen.ModConfig;
import wile.redstonepen.ModContent;
import wile.redstonepen.detail.ModRenderers;
import wile.redstonepen.detail.RcaSync;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.Registries;

@Mod(value="redstonepen")
public class ModRedstonePen {
    public static final String MODID = "redstonepen";
    public static final String MODNAME = "Redstone Pen";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final boolean USE_CONFIG = false;

    public ModRedstonePen() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "quill", reg -> reg.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModContent.init(MODID);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterModels);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCreativeModeTabContents);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        Networking.init(MODID);
        ModConfig.apply();
        RcaSync.CommonRca.init();
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Networking.OverlayTextMessage.setHandler(Overlay.TextOverlayGui::show);
        ModContent.registerMenuGuis(event);
        ModContent.registerBlockEntityRenderers();
        ModContent.processContentClientSide();
        Overlay.TextOverlayGui.on_config(0.75, 0xFFAA00, 0x55333333, 0x55333333, 0x55444444);
        if (RcaSync.ClientRca.init()) {
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ModRedstonePen::onPlayerTickEvent);
        }
    }

    private void onRegisterModels(ModelEvent.RegisterAdditional event) {
        ModRenderers.TrackTer.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    private void onCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.f_257028_) {
            Registries.getRegisteredItems().stream().filter(e -> e != Registries.getItem("track")).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
            Registries.getRegisteredBlocks().stream().filter(e -> e != Registries.getBlock("track")).forEach(arg_0 -> ((BuildCreativeModeTabContentsEvent)event).m_246326_(arg_0));
        }
    }

    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !event.player.m_9236_().f_46443_) {
            return;
        }
        if ((event.player.m_9236_().m_46467_() & 1L) != 0L) {
            return;
        }
        RcaSync.ClientRca.tick();
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            Overlay.TextOverlayGui.INSTANCE.onRenderGui(event.getGuiGraphics());
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldOverlay(RenderLevelStageEvent event) {
            if (ModConfig.withoutPreviewRendering()) {
                return;
            }
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_CUTOUT_MIPPED_BLOCKS_BLOCKS) {
                Overlay.TextOverlayGui.INSTANCE.onRenderWorldOverlay(event.getPoseStack(), event.getPartialTick());
            }
        }
    }
}

