/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import wile.redstonepen.ModContent;
import wile.redstonepen.ModRedstonePen;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Overlay;
import wile.redstonepen.libmc.StandardBlocks;

public class CircuitComponents {

    public static class BridgeRelayBlock
    extends RelayBlock {
        private int power_update_recursion_level_ = 0;

        public BridgeRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        protected int getInputPower(Level world, BlockPos relay_pos, Direction side) {
            BlockPos pos = relay_pos.m_121945_(side);
            BlockState state = world.m_8055_(pos);
            int p = 0;
            if (this.power_update_recursion_level_ < 32) {
                ++this.power_update_recursion_level_;
                if (state.m_60713_(Blocks.f_50088_)) {
                    p = Math.max(0, (Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_) - 2);
                } else if (state.m_60713_((Block)ModContent.references.TRACK_BLOCK)) {
                    p = Math.max(0, RedstoneTrack.RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.getRedstonePower(side, true)).orElse(0) - 2);
                } else if (state.m_60713_((Block)ModContent.references.BRIDGE_RELAY_BLOCK)) {
                    p = state.m_61143_((Property)FACING) != world.m_8055_(relay_pos).m_61143_((Property)FACING) ? 0 : (((Integer)state.m_61143_((Property)ROTATION) & 1) != ((Integer)world.m_8055_(relay_pos).m_61143_((Property)ROTATION) & 1) ? 0 : this.getInputPower(world, pos, side));
                } else {
                    p = state.m_60746_((BlockGetter)world, pos, side);
                    if (p < 15 && !state.m_60803_() && state.shouldCheckWeakPower((SignalGetter)world, pos, side)) {
                        for (Direction d : Direction.values()) {
                            if (d != side.m_122424_() && (p = Math.max(p, world.m_8055_(pos.m_121945_(d)).m_60746_((BlockGetter)world, pos.m_121945_(d), d))) >= 15) break;
                        }
                    }
                }
                if (--this.power_update_recursion_level_ < 0) {
                    this.power_update_recursion_level_ = 0;
                }
            }
            return p;
        }

        protected boolean isWireConnected(Level world, BlockPos relay_pos, Direction side) {
            BlockPos pos = relay_pos.m_121945_(side);
            BlockState state = world.m_8055_(pos);
            return state.m_60713_(Blocks.f_50088_) || state.m_60713_((Block)ModContent.references.TRACK_BLOCK);
        }

        protected boolean isSidePowered(Level world, BlockPos pos, Direction side) {
            return world.m_277185_(pos.m_121945_(side), side) > 0;
        }

        @Override
        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            return this.isSidePowered(world, pos, (Direction)state.m_61143_((Property)FACING)) || this.isSidePowered(world, pos, BridgeRelayBlock.getOutputFacing(state).m_122424_());
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            if (redstone_side == BridgeRelayBlock.getOutputFacing(state).m_122424_()) {
                return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
            }
            int p = 0;
            Direction left = BridgeRelayBlock.getLeftFacing(state);
            Direction right = BridgeRelayBlock.getRightFacing(state);
            if ((redstone_side == left || redstone_side == right) && world instanceof ServerLevel) {
                boolean right_source;
                boolean left_source = !this.isWireConnected((Level)((ServerLevel)world), pos, left) && world.m_8055_(pos.m_121945_(left)).m_60803_();
                boolean bl = right_source = !this.isWireConnected((Level)((ServerLevel)world), pos, right) && world.m_8055_(pos.m_121945_(right)).m_60803_();
                p = left_source && !right_source ? this.getInputPower((Level)((ServerLevel)world), pos, left) : (!left_source && right_source ? this.getInputPower((Level)((ServerLevel)world), pos, right) : Math.max(0, Math.max(this.getInputPower((Level)((ServerLevel)world), pos, left), this.getInputPower((Level)((ServerLevel)world), pos, right))));
            }
            return p;
        }

        @Override
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.m_6378_(state, world, pos, redstone_side);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.m_61143_((Property)POWERED) && !world.m_183326_().m_183582_(pos, (Object)this)) {
                if (powered) {
                    this.lock_update = true;
                    state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
                    world.m_7731_(pos, state, 15);
                    world.m_46586_(pos.m_121945_(BridgeRelayBlock.getOutputFacing(state)), (Block)this, pos);
                    this.lock_update = false;
                } else {
                    world.m_186460_(pos, (Block)this, 2);
                }
            }
            if (fromPos != null) {
                BlockPos v = pos.m_121996_((Vec3i)fromPos);
                Direction dir = Direction.m_122372_((float)v.m_123341_(), (float)v.m_123342_(), (float)v.m_123343_());
                Direction left = BridgeRelayBlock.getLeftFacing(state);
                Direction right = BridgeRelayBlock.getRightFacing(state);
                if (dir == left || dir == right) {
                    this.lock_update = true;
                    this.power_update_recursion_level_ = 0;
                    int pr = this.m_6378_(state, (BlockGetter)world, pos, right);
                    int pl = this.m_6378_(state, (BlockGetter)world, pos, left);
                    boolean track_powered = pr > 0 || pl > 0;
                    if (track_powered != ((Integer)state.m_61143_((Property)STATE) == 1)) {
                        state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(track_powered ? 1 : 0));
                        world.m_7731_(pos, state, 15);
                    }
                    world.m_46586_(pos.m_121945_(dir), (Block)this, pos);
                    this.lock_update = false;
                }
            }
            return state;
        }
    }

    public static class PulseRelayBlock
    extends RelayBlock {
        public PulseRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Integer)state.m_61143_((Property)STATE) == 0 || redstone_side != PulseRelayBlock.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            if ((Integer)state.m_61143_((Property)STATE) == 0) {
                return;
            }
            state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
            world.m_7731_(pos, state, 15);
            this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered != (Boolean)state.m_61143_((Property)POWERED)) {
                state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
                if (powered) {
                    boolean trig = (Integer)state.m_61143_((Property)STATE) == 0;
                    state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf(1));
                    world.m_7731_(pos, state, 15);
                    if (trig) {
                        this.notifyOutputNeighbourOfStateChange(state, world, pos);
                    }
                } else {
                    world.m_7731_(pos, state, 15);
                }
            }
            if (!world.m_183326_().m_183582_(pos, (Object)this)) {
                world.m_186460_(pos, (Block)this, 2);
            }
            return state;
        }
    }

    public static class BistableRelayBlock
    extends RelayBlock {
        public BistableRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Integer)state.m_61143_((Property)STATE) == 0 || redstone_side != BistableRelayBlock.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean pwstate;
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (pwstate = ((Boolean)state.m_61143_((Property)POWERED)).booleanValue())) {
                return state;
            }
            state = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered));
            if (powered && !pwstate) {
                state = (BlockState)state.m_61124_((Property)STATE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)STATE) == 0 ? 1 : 0));
                world.m_7731_(pos, state, 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
            } else if (!powered && pwstate) {
                world.m_7731_(pos, state, 15);
            }
            return state;
        }
    }

    public static class InvertedRelayBlock
    extends RelayBlock {
        private boolean lock_update = false;

        public InvertedRelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Boolean)state.m_61143_((Property)POWERED) != false || redstone_side != InvertedRelayBlock.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return;
            }
            if (powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return state;
            }
            if (world.m_183326_().m_183582_(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                world.m_186460_(pos, (Block)this, 2);
            } else {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            }
            return state;
        }
    }

    public static class RelayBlock
    extends DirectedComponentBlock {
        protected boolean lock_update = false;

        protected boolean isPowered(BlockState state, Level world, BlockPos pos) {
            Direction output_side = RelayBlock.getOutputFacing(state);
            Direction mount_side = (Direction)state.m_61143_((Property)FACING);
            for (Direction side : Direction.values()) {
                if (side == output_side || side == mount_side.m_122424_() || world.m_277185_(pos.m_121945_(side), side) <= 0) continue;
                return true;
            }
            return false;
        }

        public RelayBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            super(config, builder, aabb);
        }

        @Override
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return (Boolean)state.m_61143_((Property)POWERED) == false || redstone_side != RelayBlock.getOutputFacing(state).m_122424_() ? 0 : 15;
        }

        @Override
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.m_6378_(state, world, pos, redstone_side);
        }

        @Override
        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            boolean powered = this.isPowered(state, (Level)world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return;
            }
            if (!powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)), 15);
                this.notifyOutputNeighbourOfStateChange(state, (Level)world, pos);
                this.lock_update = false;
            }
        }

        @Override
        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            boolean powered = this.isPowered(state, world, pos);
            if (powered == (Boolean)state.m_61143_((Property)POWERED)) {
                return state;
            }
            if (world.m_183326_().m_183582_(pos, (Object)this)) {
                return state;
            }
            if (powered) {
                this.lock_update = true;
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true)), 15);
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                this.lock_update = false;
            } else {
                world.m_186460_(pos, (Block)this, 2);
            }
            return state;
        }
    }

    public static class DirectedComponentBlockItem
    extends BlockItem {
        public DirectedComponentBlockItem(Block block, Item.Properties builder) {
            super(block, builder);
        }

        public void m_6883_(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
            if (!(isSelected && world.f_46443_ && entity instanceof Player)) {
                return;
            }
            Player player = (Player)entity;
            BlockHitResult hr = DirectedComponentBlockItem.m_41435_((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
            BlockPlaceContext pc = new BlockPlaceContext(new UseOnContext(player, InteractionHand.MAIN_HAND, hr));
            if (!pc.m_7059_()) {
                return;
            }
            BlockState state = this.m_40614_().m_5573_(pc);
            if (state == null) {
                return;
            }
            Overlay.show(state, pc.m_8083_());
        }
    }

    public static class DirectedComponentBlock
    extends StandardBlocks.WaterLoggable {
        public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
        public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)3);
        public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
        public static final IntegerProperty STATE = IntegerProperty.m_61631_((String)"state", (int)0, (int)1);
        private static final List<Direction> facing_mapping_ = DirectedComponentBlock.make_facing_mappings();
        private static final Direction[][][] facing_fwd_state_mapping_ = new Direction[6][4][6];
        private static final Direction[][][] facing_rev_state_mapping_ = new Direction[6][4][6];
        protected final Map<BlockState, VoxelShape> shapes_ = new HashMap<BlockState, VoxelShape>();

        private static List<Direction> make_facing_mappings() {
            ArrayList<Direction> maps = new ArrayList<Direction>();
            Arrays.stream(Direction.values()).forEach(face -> {
                switch (face) {
                    case DOWN: 
                    case UP: {
                        maps.add(Direction.NORTH);
                        maps.add(Direction.EAST);
                        maps.add(Direction.SOUTH);
                        maps.add(Direction.WEST);
                        break;
                    }
                    case NORTH: {
                        maps.add(Direction.UP);
                        maps.add(Direction.EAST);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.WEST);
                        break;
                    }
                    case EAST: {
                        maps.add(Direction.UP);
                        maps.add(Direction.SOUTH);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.NORTH);
                        break;
                    }
                    case SOUTH: {
                        maps.add(Direction.UP);
                        maps.add(Direction.WEST);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.EAST);
                        break;
                    }
                    case WEST: {
                        maps.add(Direction.UP);
                        maps.add(Direction.NORTH);
                        maps.add(Direction.DOWN);
                        maps.add(Direction.SOUTH);
                    }
                }
            });
            return maps;
        }

        private static void fill_state_facing_lookups(ImmutableList<BlockState> states) {
            if (facing_fwd_state_mapping_[0][0][0] != null && facing_rev_state_mapping_[0][0][0] != null) {
                return;
            }
            for (BlockState state : states) {
                for (Direction world_side : Direction.values()) {
                    Direction sm;
                    DirectedComponentBlock.facing_fwd_state_mapping_[((Direction)state.m_61143_((Property)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.m_61143_((Property)DirectedComponentBlock.ROTATION)).intValue()][world_side.ordinal()] = sm = (switch (world_side) {
                        default -> throw new IncompatibleClassChangeError();
                        case Direction.DOWN -> DirectedComponentBlock.getDownFacing(state);
                        case Direction.UP -> DirectedComponentBlock.getUpFacing(state);
                        case Direction.NORTH -> DirectedComponentBlock.getFrontFacing(state);
                        case Direction.SOUTH -> DirectedComponentBlock.getBackFacing(state);
                        case Direction.WEST -> DirectedComponentBlock.getLeftFacing(state);
                        case Direction.EAST -> DirectedComponentBlock.getRightFacing(state);
                    });
                    DirectedComponentBlock.facing_rev_state_mapping_[((Direction)state.m_61143_((Property)DirectedComponentBlock.FACING)).ordinal()][((Integer)state.m_61143_((Property)DirectedComponentBlock.ROTATION)).intValue()][sm.ordinal()] = world_side;
                }
            }
        }

        protected static VoxelShape mapped_shape(BlockState state, AABB[] aabb) {
            switch ((Direction)state.m_61143_((Property)FACING)) {
                case DOWN: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 2));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(aabb, 3));
                        }
                    }
                }
                case UP: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 0), Direction.Axis.Y));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 1), Direction.Axis.Y));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 2), Direction.Axis.Y));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getMirroredAABB(Auxiliaries.getYRotatedAABB(aabb, 3), Direction.Axis.Y));
                        }
                    }
                }
                case NORTH: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.DOWN));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.DOWN));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.DOWN));
                        }
                    }
                }
                case EAST: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.WEST), 0));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.DOWN), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP), 3));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 3));
                        }
                    }
                }
                case SOUTH: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.NORTH), Direction.UP));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.SOUTH), Direction.UP));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP));
                        }
                    }
                }
                case WEST: {
                    switch ((Integer)state.m_61143_((Property)ROTATION)) {
                        case 0: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.UP), Direction.EAST));
                        }
                        case 1: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.EAST), Direction.UP), 1));
                        }
                        case 2: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.DOWN), Direction.WEST));
                        }
                        case 3: {
                            return Auxiliaries.getUnionShape(Auxiliaries.getYRotatedAABB(Auxiliaries.getRotatedAABB(Auxiliaries.getRotatedAABB(aabb, Direction.WEST), Direction.UP), 1));
                        }
                    }
                }
            }
            return Shapes.m_83144_();
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB[] aabbs) {
            super(config, builder);
            this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)super.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0)));
            this.f_49792_.m_61056_().forEach(state -> this.shapes_.put((BlockState)state, DirectedComponentBlock.mapped_shape(state, aabbs)));
            DirectedComponentBlock.fill_state_facing_lookups((ImmutableList<BlockState>)this.f_49792_.m_61056_());
        }

        public DirectedComponentBlock(long config, BlockBehaviour.Properties builder, AABB aabb) {
            this(config, builder, new AABB[]{aabb});
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{FACING, ROTATION, POWERED, STATE});
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            return Collections.singletonList(new ItemStack((ItemLike)this.m_5456_()));
        }

        @Override
        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return true;
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.shapes_.getOrDefault(state, Shapes.m_83144_());
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return this.m_5940_(state, world, pos, context);
        }

        public VoxelShape m_7952_(BlockState state, BlockGetter world, BlockPos pos) {
            return this.shapes_.getOrDefault(state, Shapes.m_83144_());
        }

        @Override
        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
        }

        @Override
        public PushReaction getPistonPushReaction(BlockState state) {
            return PushReaction.DESTROY;
        }

        @Deprecated
        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side == null || side != state.m_61143_((Property)FACING);
        }

        public boolean m_7899_(BlockState state) {
            return true;
        }

        public boolean m_7278_(BlockState state) {
            return false;
        }

        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return 0;
        }

        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return 0;
        }

        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return 0;
        }

        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return state;
            }
            Direction face = context.m_43719_().m_122424_();
            Vec3 hit_r = context.m_43720_().m_82546_(Vec3.m_82512_((Vec3i)context.m_8083_()));
            Vec3 hit = switch (face) {
                case Direction.WEST, Direction.EAST -> hit_r.m_82542_(0.0, 1.0, 1.0);
                case Direction.NORTH, Direction.SOUTH -> hit_r.m_82542_(1.0, 1.0, 0.0);
                default -> hit_r.m_82542_(1.0, 0.0, 1.0);
            };
            Direction dir = Direction.m_122366_((double)hit.m_7096_(), (double)hit.m_7098_(), (double)hit.m_7094_());
            int rotation = 0;
            block4 : switch (face) {
                case DOWN: 
                case UP: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case NORTH: {
                    switch (dir) {
                        case EAST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case WEST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case EAST: {
                    switch (dir) {
                        case SOUTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case NORTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case SOUTH: {
                    switch (dir) {
                        case WEST: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case EAST: {
                            rotation = 3;
                            break block4;
                        }
                    }
                    break;
                }
                case WEST: {
                    switch (dir) {
                        case NORTH: {
                            rotation = 1;
                            break block4;
                        }
                        case DOWN: {
                            rotation = 2;
                            break block4;
                        }
                        case SOUTH: {
                            rotation = 3;
                            break block4;
                        }
                    }
                }
            }
            state = (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)face)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)STATE, (Comparable)Integer.valueOf(0));
            if (!this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_())) {
                return null;
            }
            return state;
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if ((state = super.m_7417_(state, facing, facingState, world, pos, facingPos)) == null) {
                return state;
            }
            if (!this.m_7898_(state, (LevelReader)world, pos)) {
                return Blocks.f_50016_.m_49966_();
            }
            return world instanceof ServerLevel ? this.update(state, (Level)((ServerLevel)world), pos, facingPos) : state;
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            Direction face = (Direction)state.m_61143_((Property)FACING);
            BlockPos adj_pos = pos.m_121945_(face);
            return world.m_8055_(adj_pos).m_60783_((BlockGetter)world, adj_pos, face.m_122424_());
        }

        public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
            this.update(state, world, pos, null);
        }

        @Override
        public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.m_60713_(newState.m_60734_())) {
                return;
            }
            super.m_6810_(state, world, pos, newState, isMoving);
            if (!world.m_5776_()) {
                this.notifyOutputNeighbourOfStateChange(state, world, pos);
                world.m_46672_(pos, (Block)this);
            }
        }

        public boolean shouldCheckWeakPower(BlockState state, SignalGetter level, BlockPos pos, Direction side) {
            return false;
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            this.update(state, world, pos, fromPos);
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(Level world, RandomSource rand, BlockPos pos, Vec3 color, Direction side, float chance) {
            if (rand.m_188501_() < chance) {
                double c2 = chance * rand.m_188501_();
                double p0 = 0.5 + (double)side.m_122429_() * 0.4 + c2 * 0.1;
                double p1 = 0.5 + (double)side.m_122430_() * 0.4 + c2 * 0.1;
                double p2 = 0.5 + (double)side.m_122431_() * 0.4 + c2 * 0.1;
                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f((Vector3fc)color.m_252839_()), 1.0f), (double)pos.m_123341_() + p0, (double)pos.m_123342_() + p1, (double)pos.m_123343_() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue() || (double)rand.m_188501_() > 0.4) {
                return;
            }
            Vec3 color = new Vec3((double)0.6f, 0.0, 0.0);
            Direction side = (Direction)state.m_61143_((Property)FACING);
            this.spawnPoweredParticle(world, rand, pos, color, side, 0.3f);
        }

        protected static Direction getOutputFacing(BlockState state) {
            return DirectedComponentBlock.getFrontFacing(state);
        }

        protected static Direction getFrontFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) & 3));
        }

        protected static Direction getRightFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 1 & 3));
        }

        protected static Direction getBackFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 2 & 3));
        }

        protected static Direction getLeftFacing(BlockState state) {
            return facing_mapping_.get(((Direction)state.m_61143_((Property)FACING)).m_122411_() * 4 + ((Integer)state.m_61143_((Property)ROTATION) + 3 & 3));
        }

        protected static Direction getUpFacing(BlockState state) {
            return ((Direction)state.m_61143_((Property)FACING)).m_122424_();
        }

        protected static Direction getDownFacing(BlockState state) {
            return (Direction)state.m_61143_((Property)FACING);
        }

        protected static Direction getForwardStateMappedFacing(BlockState state, Direction internal_side) {
            return facing_fwd_state_mapping_[((Direction)state.m_61143_((Property)FACING)).ordinal()][(Integer)state.m_61143_((Property)ROTATION)][internal_side.ordinal()];
        }

        protected static Direction getReverseStateMappedFacing(BlockState state, Direction world_side) {
            return facing_rev_state_mapping_[((Direction)state.m_61143_((Property)FACING)).ordinal()][(Integer)state.m_61143_((Property)ROTATION)][world_side.ordinal()];
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, Level world, BlockPos pos) {
            this.notifyOutputNeighbourOfStateChange(state, world, pos, DirectedComponentBlock.getOutputFacing(state));
        }

        protected void notifyOutputNeighbourOfStateChange(BlockState state, Level world, BlockPos pos, Direction facing) {
            BlockPos adjacent_pos = pos.m_121945_(facing);
            BlockState adjacent_state = world.m_8055_(adjacent_pos);
            try {
                adjacent_state.m_60690_(world, adjacent_pos, (Block)this, pos, false);
                if (adjacent_state.shouldCheckWeakPower((SignalGetter)world, adjacent_pos, facing)) {
                    world.m_46590_(adjacent_pos, state.m_60734_(), facing.m_122424_());
                }
            }
            catch (Throwable ex) {
                ModRedstonePen.logger().error("Curcuit neighborChanged recursion detected, dropping!");
                Vec3 p = Vec3.m_82512_((Vec3i)pos);
                world.m_7967_((Entity)new ItemEntity(world, p.f_82479_, p.f_82480_, p.f_82481_, new ItemStack((ItemLike)this, 1)));
                world.m_7731_(pos, world.m_8055_(pos).m_60819_().m_76188_(), 18);
            }
        }

        public BlockState update(BlockState state, Level world, BlockPos pos, @Nullable BlockPos fromPos) {
            return state;
        }
    }
}

