/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.item.tool;

import com.blakebr0.cucumber.helper.BlockHelper;
import com.blakebr0.cucumber.lib.ModTags;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BaseSickleItem
extends DiggerItem {
    private final float attackDamage;
    private final float attackSpeed;
    private final int range;

    public BaseSickleItem(Tier tier, int range) {
        this(tier, range, p -> p);
    }

    public BaseSickleItem(Tier tier, int range, Function<Item.Properties, Item.Properties> properties) {
        super(4.0f, -3.0f, tier, ModTags.MINEABLE_WITH_SICKLE, properties.apply(new Item.Properties()));
        this.attackDamage = 4.0f;
        this.attackSpeed = -3.0f;
        this.range = range;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return state.m_204336_(ModTags.MINEABLE_WITH_SICKLE) ? this.m_43314_().m_6624_() / 2.0f : super.m_8102_(stack, state);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        Level level = player.m_9236_();
        if (level.m_5776_()) {
            return false;
        }
        this.harvestAOEBlocks(stack, level, pos, player);
        return false;
    }

    public float m_41008_() {
        return this.attackDamage + this.m_43314_().m_6631_();
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    private void harvestAOEBlocks(ItemStack stack, Level level, BlockPos pos, Player player) {
        BlockState state = level.m_8055_(pos);
        if (this.range > 0 && this.isCorrectToolForDrops(stack, state)) {
            float hardness = state.m_60800_((BlockGetter)level, pos);
            BlockPos.m_121940_((BlockPos)pos.m_7918_(-this.range, -this.range, -this.range), (BlockPos)pos.m_7918_(this.range, this.range, this.range)).forEach(aoePos -> {
                if (stack.m_41619_()) {
                    return;
                }
                if (aoePos != pos) {
                    BlockState aoeState = level.m_8055_(aoePos);
                    if (!this.isCorrectToolForDrops(stack, aoeState)) {
                        return;
                    }
                    float aoeHardness = aoeState.m_60800_((BlockGetter)level, aoePos);
                    if (aoeHardness > hardness + 5.0f) {
                        return;
                    }
                    boolean harvested = BlockHelper.harvestAOEBlock(stack, level, (ServerPlayer)player, aoePos.m_7949_());
                    if (harvested && !player.m_150110_().f_35937_ && aoeHardness <= 0.0f && Math.random() < 0.33) {
                        stack.m_41622_(1, (LivingEntity)player, entity -> entity.m_21190_(player.m_7655_()));
                    }
                }
            });
        }
    }
}

