/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection;

import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import wile.wilescollection.ModWilesCollection;
import wile.wilescollection.blocks.Chair;
import wile.wilescollection.blocks.ExtCraftingTable;
import wile.wilescollection.blocks.ExtLadderBlock;
import wile.wilescollection.blocks.FluidBarrel;
import wile.wilescollection.blocks.LabeledCrate;
import wile.wilescollection.items.BackfillWandItem;
import wile.wilescollection.items.ChargedLapisSqueezerItem;
import wile.wilescollection.items.RediaToolItem;
import wile.wilescollection.items.Trinkets;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.OptionalRecipeCondition;
import wile.wilescollection.libmc.Registries;
import wile.wilescollection.libmc.blocks.SlabSliceBlock;
import wile.wilescollection.libmc.blocks.VariantSlabBlock;

public class ModConfig {
    private static final Logger LOGGER = ModWilesCollection.logger();
    private static final String MODID = "wilescollection";
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_CONFIG_SPEC;
    private static final CompoundTag server_config_;
    private static HashSet<String> optouts_;
    private static boolean with_experimental_features_;
    private static boolean with_config_logging_;
    private static boolean with_debug_logs_;
    public static boolean without_direct_slab_pickup;
    public static boolean with_creative_mode_device_drops;

    public static boolean isOptedOut(@Nullable Block block) {
        return block == null || ModConfig.isOptedOut(block.m_5456_());
    }

    public static boolean isOptedOut(@Nullable Item item) {
        return item != null && optouts_.contains(Auxiliaries.getResourceLocation(item).m_135815_());
    }

    public static boolean withExperimental() {
        return with_experimental_features_;
    }

    public static boolean withoutRecipes() {
        return false;
    }

    public static boolean withDebug() {
        return with_debug_logs_;
    }

    public static boolean withDebugLogging() {
        return with_debug_logs_;
    }

    public static CompoundTag getServerConfig() {
        return server_config_;
    }

    private static void updateOptouts() {
        int i;
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> excludes = new ArrayList<String>();
        String inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("wilescollection:", "").replaceAll("[^*_,a-z\\d]", "");
        if (!((String)ModConfig.COMMON.pattern_includes.get()).equals(inc)) {
            ModConfig.COMMON.pattern_includes.set((Object)inc);
        }
        String[] incl = inc.split(",");
        for (i = 0; i < incl.length; ++i) {
            incl[i] = incl[i].replaceAll("[*]", ".*?");
            if (incl[i].isEmpty()) continue;
            includes.add(incl[i]);
        }
        String exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("wilescollection:", "").replaceAll("[^*_,a-z\\d]", "");
        String[] excl = exc.split(",");
        for (i = 0; i < excl.length; ++i) {
            excl[i] = excl[i].replaceAll("[*]", ".*?");
            if (excl[i].isEmpty()) continue;
            excludes.add(excl[i]);
        }
        if (COMMON_CONFIG_SPEC.isLoaded()) {
            inc = ((String)ModConfig.COMMON.pattern_includes.get()).toLowerCase().replaceAll("wilescollection:", "").replaceAll("[^*_,a-z\\d]", "");
            incl = inc.split(",");
            for (i = 0; i < incl.length; ++i) {
                incl[i] = incl[i].replaceAll("[*]", ".*?");
                if (incl[i].isEmpty()) continue;
                includes.add(incl[i]);
            }
        }
        if (COMMON_CONFIG_SPEC.isLoaded()) {
            exc = ((String)ModConfig.COMMON.pattern_excludes.get()).toLowerCase().replaceAll("wilescollection:", "").replaceAll("[^*_,a-z\\d]", "");
            excl = exc.split(",");
            for (i = 0; i < excl.length; ++i) {
                excl[i] = excl[i].replaceAll("[*]", ".*?");
                if (excl[i].isEmpty()) continue;
                excludes.add(excl[i]);
            }
        }
        if (!excludes.isEmpty()) {
            ModConfig.log("Config pattern excludes: '" + String.join((CharSequence)",", excludes) + "'");
        }
        if (!includes.isEmpty()) {
            ModConfig.log("Config pattern includes: '" + String.join((CharSequence)",", includes) + "'");
        }
        HashSet optouts = new HashSet();
        Registries.getRegisteredBlocks().stream().filter(block -> {
            try {
                if (!with_experimental_features_ && block instanceof Auxiliaries.IExperimentalFeature) {
                    return true;
                }
                String rn = Auxiliaries.getResourceLocation(block).m_135815_();
                try {
                    for (String e : includes) {
                        if (!rn.matches(e)) continue;
                        ModConfig.log("Optout force include: " + rn);
                        return false;
                    }
                    for (String e : excludes) {
                        if (!rn.matches(e)) continue;
                        ModConfig.log("Optout force exclude: " + rn);
                        return true;
                    }
                }
                catch (Throwable ex) {
                    LOGGER.error("optout include pattern failed, disabling.");
                    includes.clear();
                    excludes.clear();
                }
            }
            catch (Exception ex) {
                LOGGER.error("Exception evaluating the optout config: '" + ex.getMessage() + "'");
            }
            return false;
        }).forEach(e -> optouts.add(Auxiliaries.getResourceLocation(e).m_135815_()));
        optouts_ = optouts;
        OptionalRecipeCondition.on_config(ModConfig.withExperimental(), ModConfig.withoutRecipes(), ModConfig::isOptedOut, ModConfig::isOptedOut);
    }

    public static void apply() {
        with_config_logging_ = (Boolean)ModConfig.COMMON.with_config_logging.get();
        with_experimental_features_ = (Boolean)ModConfig.COMMON.with_experimental.get();
        with_debug_logs_ = (Boolean)ModConfig.COMMON.with_debug_logging.get();
        if (with_experimental_features_) {
            LOGGER.info("Config: EXPERIMENTAL FEATURES ENABLED.");
        }
        if (with_debug_logs_) {
            LOGGER.info("Config: DEBUG LOGGING ENABLED, WARNING, THIS MAY SPAM THE LOG.");
        }
        ModConfig.updateOptouts();
        if (!COMMON_CONFIG_SPEC.isLoaded()) {
            return;
        }
        without_direct_slab_pickup = (Boolean)ModConfig.COMMON.without_direct_slab_pickup.get();
        Chair.on_config((Boolean)ModConfig.COMMON.without_chair_sitting.get(), (Boolean)ModConfig.COMMON.without_chair_sitting.get(), 80.0, 10.0);
        ExtLadderBlock.on_config((Boolean)ModConfig.COMMON.without_ladder_speed_boost.get());
        VariantSlabBlock.on_config(!without_direct_slab_pickup);
        SlabSliceBlock.on_config(!without_direct_slab_pickup);
        LabeledCrate.on_config(false);
        ExtCraftingTable.on_config((Boolean)ModConfig.COMMON.without_crafting_table_history.get(), false, (Boolean)ModConfig.COMMON.without_crafting_mouse_scrolling.get());
        FluidBarrel.on_config(12000, 1000);
        Trinkets.on_config();
        BackfillWandItem.on_config(2048);
        ChargedLapisSqueezerItem.on_config(15);
        boolean without_redia_torchplacing = false;
        boolean without_redia_hoeing = false;
        boolean without_redia_tree_chopping = false;
        boolean without_safe_attacking = false;
        int durability = 3000;
        int initial_durability_percent = 100;
        int enchantability = 20;
        RediaToolItem.on_config(without_redia_torchplacing, without_redia_hoeing, without_redia_tree_chopping, without_safe_attacking, durability, initial_durability_percent, enchantability);
    }

    public static void log(String config_message) {
        if (!with_config_logging_) {
            return;
        }
        LOGGER.info(config_message);
    }

    static {
        Pair common_ = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_CONFIG_SPEC = (ForgeConfigSpec)common_.getRight();
        COMMON = (CommonConfig)common_.getLeft();
        server_config_ = new CompoundTag();
        optouts_ = new HashSet();
        with_experimental_features_ = false;
        with_config_logging_ = false;
        with_debug_logs_ = false;
        without_direct_slab_pickup = false;
        with_creative_mode_device_drops = false;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.ConfigValue<String> pattern_excludes;
        public final ForgeConfigSpec.ConfigValue<String> pattern_includes;
        public final ForgeConfigSpec.BooleanValue without_chair_sitting;
        public final ForgeConfigSpec.BooleanValue without_ladder_speed_boost;
        public final ForgeConfigSpec.BooleanValue without_crafting_table_history;
        public final ForgeConfigSpec.BooleanValue without_direct_slab_pickup;
        public final ForgeConfigSpec.BooleanValue with_experimental;
        public final ForgeConfigSpec.BooleanValue with_config_logging;
        public final ForgeConfigSpec.BooleanValue with_debug_logging;
        public final ForgeConfigSpec.BooleanValue without_ters;
        public final ForgeConfigSpec.BooleanValue without_crafting_mouse_scrolling;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Settings affecting the logical server side.").push("server");
            builder.comment("Opt-out settings").push("optout");
            this.pattern_excludes = builder.translation("wilescollection.config.pattern_excludes").comment("Opt-out any block by its registry name ('*' wildcard matching, comma separated list, whitespaces ignored. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' excludes everything that has 'wood' or 'steel' in the registry name. The matching result is also traced in the log file. ").define("pattern_excludes", (Object)"");
            this.pattern_includes = builder.translation("wilescollection.config.pattern_includes").comment("Prevent blocks from being opt'ed by registry name ('*' wildcard matching, comma separated list, whitespaces ignored. Evaluated before all other opt-out checks. You must match the whole name, means maybe add '*' also at the begin and end. Example: '*wood*,*steel*' includes everything that has 'wood' or 'steel' in the registry name.The matching result is also traced in the log file.").define("pattern_includes", (Object)"");
            this.without_chair_sitting = builder.translation("wilescollection.config.without_chair_sitting").comment("Disable possibility to sit on stools and chairs.").define("without_chair_sitting", false);
            this.without_ladder_speed_boost = builder.translation("wilescollection.config.without_ladder_speed_boost").comment("Disable the speed boost of ladders in this mod.").define("without_ladder_speed_boost", false);
            this.without_crafting_table_history = builder.translation("wilescollection.config.without_crafting_table_history").comment("Disable history refabrication feature of the crafting table.").define("without_crafting_table_history", false);
            builder.pop();
            builder.comment("Miscellaneous settings").push("miscellaneous");
            this.with_experimental = builder.translation("wilescollection.config.with_experimental").comment("Enables experimental features. Use at own risk.").define("with_experimental", false);
            this.with_config_logging = builder.translation("wilescollection.config.with_debug_logging").comment("Enable detailed logging of the config values and resulting calculations in each mod feature config.").define("with_debug_logging", false);
            this.with_debug_logging = builder.translation("wilescollection.config.with_debug_logging").comment("Enable debug log messages for trouble shooting. Don't activate if not really needed, this can spam the log file.").define("with_debug_logging", false);
            this.without_ters = builder.translation("wilescollection.config.without_ters").comment("Disable all TERs (tile entity renderers).").define("without_ters", false);
            this.without_direct_slab_pickup = builder.translation("wilescollection.config.without_direct_slab_pickup").comment("Disable directly picking up layers from slabs and slab  slices by left clicking while looking up/down.").define("without_direct_slab_pickup", true);
            this.without_crafting_mouse_scrolling = builder.translation("wilescollection.config.without_crafting_mouse_scrolling").comment("Disables increasing/decreasing the crafting grid items by scrolling over the crafting result slot.").define("without_crafting_mouse_scrolling", false);
            builder.pop();
        }
    }
}

