/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection;

import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import wile.wilescollection.blocks.AriadneCoalBlock;
import wile.wilescollection.blocks.Chair;
import wile.wilescollection.blocks.ExtCraftingTable;
import wile.wilescollection.blocks.ExtLadderBlock;
import wile.wilescollection.blocks.FluidBarrel;
import wile.wilescollection.blocks.LabeledCrate;
import wile.wilescollection.blocks.SimpleBlocks;
import wile.wilescollection.blocks.SpecialFlowerBlock;
import wile.wilescollection.detail.ModRenderers;
import wile.wilescollection.items.AriadneCoalItem;
import wile.wilescollection.items.Armors;
import wile.wilescollection.items.BackfillWandItem;
import wile.wilescollection.items.ChargedLapisItem;
import wile.wilescollection.items.ChargedLapisSqueezerItem;
import wile.wilescollection.items.CrushingHammerItem;
import wile.wilescollection.items.GritItem;
import wile.wilescollection.items.ModItem;
import wile.wilescollection.items.ProspectingDowserItem;
import wile.wilescollection.items.RediaToolItem;
import wile.wilescollection.items.TrackerItem;
import wile.wilescollection.items.Trinkets;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.ExtendedShapelessRecipe;
import wile.wilescollection.libmc.Materials;
import wile.wilescollection.libmc.Registries;
import wile.wilescollection.libmc.blocks.StandardBlocks;
import wile.wilescollection.libmc.blocks.StandardDoorBlock;
import wile.wilescollection.libmc.blocks.StandardStairsBlock;
import wile.wilescollection.libmc.blocks.VariantSlabBlock;
import wile.wilescollection.libmc.blocks.VariantWallBlock;

public class ModContent {
    public static void init(String modid) {
        detail.MODID = modid;
        ModContent.initTags();
        ModContent.initBlocks();
        ModContent.initItems();
        ModContent.initEntities();
        ModContent.initPaintings();
        Registries.addRecipeSerializer("crafting_extended_shapeless", () -> ExtendedShapelessRecipe.SERIALIZER);
    }

    public static void initTags() {
        Registries.addOptionalBlockTag("prospectible", new ResourceLocation("minecraft:diamond_ore"));
    }

    public static void initBlocks() {
        Registries.addBlock("crafting_table", () -> new ExtCraftingTable.CraftingTableBlock(177L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56736_).m_60955_(), new AABB[]{Auxiliaries.getPixeledAABB(0.0, 13.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(1.0, 0.0, 1.0, 15.0, 16.0, 15.0)}), ExtCraftingTable.CraftingTableTileEntity::new, ExtCraftingTable.CraftingTableUiContainer::new);
        Registries.addBlock("fluid_barrel", () -> new FluidBarrel.FluidBarrelBlock(161L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56736_).m_60955_(), new AABB[]{Auxiliaries.getPixeledAABB(2.0, 0.0, 0.0, 14.0, 1.0, 16.0), Auxiliaries.getPixeledAABB(1.0, 1.0, 0.0, 15.0, 2.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 2.0, 0.0, 16.0, 14.0, 16.0), Auxiliaries.getPixeledAABB(1.0, 14.0, 0.0, 15.0, 15.0, 16.0), Auxiliaries.getPixeledAABB(2.0, 15.0, 0.0, 14.0, 16.0, 16.0)}), FluidBarrel.FluidBarrelItem::new, FluidBarrel.FluidBarrelTileEntity::new);
        Registries.addBlock("rustic_barrel", () -> new BarrelBlock(BlockBehaviour.Properties.m_284310_().m_60978_(3.0f).m_155954_(0.4f).m_60918_(SoundType.f_56736_)));
        Registries.addBlock("crate", () -> new LabeledCrate.LabeledCrateBlock(176L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 5.0f).m_60918_(SoundType.f_56736_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)), LabeledCrate.LabeledCrateTileEntity::new, LabeledCrate.LabeledCrateContainer::new);
        Registries.addBlock("ladder", () -> new ExtLadderBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_()));
        Registries.addBlock("wood_table", () -> new SimpleBlocks.TableBlock(1L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 14.0, 0.0, 16.0, 16.0, 16.0), new AABB[]{Auxiliaries.getPixeledAABB(14.0, 0.0, 0.0, 16.0, 16.0, 2.0)}));
        Registries.addBlock("wood_chair", () -> new Chair.ChairBlock(49L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56736_).m_60955_(), new AABB[]{Auxiliaries.getPixeledAABB(2.0, 0.0, 3.0, 4.0, 9.0, 5.0), Auxiliaries.getPixeledAABB(12.0, 0.0, 3.0, 14.0, 9.0, 5.0), Auxiliaries.getPixeledAABB(12.0, 0.0, 12.0, 14.0, 16.0, 14.0), Auxiliaries.getPixeledAABB(2.0, 0.0, 12.0, 4.0, 16.0, 14.0), Auxiliaries.getPixeledAABB(2.5, 7.0, 3.5, 13.5, 8.875, 13.0), Auxiliaries.getPixeledAABB(4.0, 11.25, 12.0, 12.0, 15.25, 13.0)}));
        Registries.addBlock("patchy_stone", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56742_)));
        Registries.addBlock("patchy_stone_slab", () -> new VariantSlabBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56742_)));
        Registries.addBlock("patchy_stone_stairs", () -> new StandardStairsBlock(0L, () -> Registries.getBlock("patchy_stone").m_49966_(), BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56742_)));
        Registries.addBlock("rustic_wood_planks", () -> new Block(BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56736_)));
        Registries.addBlock("rustic_wood_slab", () -> new VariantSlabBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56736_)));
        Registries.addBlock("rustic_wood_stairs", () -> new StandardStairsBlock(0L, () -> Registries.getBlock("rustic_wood_planks").m_49966_(), BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56736_)));
        Registries.addBlock("rustic_wood_door", () -> new StandardDoorBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56736_).m_60955_(), BlockSetType.f_271100_, Auxiliaries.getPixeledAABB(15.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), SoundEvents.f_12627_, SoundEvents.f_12626_, false));
        Registries.addBlock("rustic_player_wood_door", () -> new StandardDoorBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 6.0f).m_60918_(SoundType.f_56736_).m_60955_(), BlockSetType.f_271132_, Auxiliaries.getPixeledAABB(15.0, 0.0, 0.0, 16.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 13.0, 16.0, 16.0, 16.0), SoundEvents.f_12627_, SoundEvents.f_12626_, true));
        Registries.addBlock("rustic_wood_trapdoor", () -> new TrapDoorBlock(BlockBehaviour.Properties.m_284310_().m_60978_(2.0f).m_60918_(SoundType.f_56736_).m_60955_().m_60922_(detail::disallowSpawn), BlockSetType.f_271100_));
        Registries.addBlock("rustic_iron_lantern", () -> new SimpleBlocks.OmniLanternBlock(2241L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 4.0f).m_60918_(SoundType.f_56762_).m_60953_(state -> 15).m_60955_(), new AABB[]{Auxiliaries.getPixeledAABB(5.0, 2.0, 5.0, 11.0, 8.0, 11.0), Auxiliaries.getPixeledAABB(6.0, 8.0, 6.0, 10.0, 9.0, 10.0), Auxiliaries.getPixeledAABB(7.5, 11.0, 0.0, 8.5, 13.0, 2.0), Auxiliaries.getPixeledAABB(7.5, 12.0, 2.0, 8.5, 13.0, 9.0)}, new AABB[]{Auxiliaries.getPixeledAABB(5.0, 0.0, 5.0, 11.0, 6.0, 11.0), Auxiliaries.getPixeledAABB(6.0, 6.0, 6.0, 10.0, 7.0, 10.0)}, new AABB[]{Auxiliaries.getPixeledAABB(5.0, 5.75, 5.0, 11.0, 11.75, 11.0), Auxiliaries.getPixeledAABB(6.0, 11.75, 6.0, 10.0, 12.75, 10.0), Auxiliaries.getPixeledAABB(7.0, 12.0, 7.0, 9.0, 16.0, 9.0)}));
        Registries.addBlock("rustic_chain", () -> new StandardBlocks.AxisAlignedWaterLoggable(65L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 6.0f).m_60918_(SoundType.f_56728_).m_60955_(), new AABB[]{Auxiliaries.getPixeledAABB(7.0, 7.0, 0.0, 9.0, 9.0, 16.0)}));
        Registries.addBlock("rustic_iron_framed_window", () -> new SimpleBlocks.WindowBlock(33L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56743_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.5, 16.0, 16.0, 8.5)));
        Registries.addBlock("rustic_iron_framed_window_asym", () -> new SimpleBlocks.WindowBlock(33L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56743_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.5, 16.0, 16.0, 8.5)));
        Registries.addBlock("rustic_iron_framed_window_diag", () -> new SimpleBlocks.WindowBlock(33L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56743_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.5, 16.0, 16.0, 8.5)));
        Registries.addBlock("rustic_iron_framed_window_wide", () -> new SimpleBlocks.WindowBlock(33L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 3.0f).m_60918_(SoundType.f_56743_).m_60955_(), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.5, 16.0, 16.0, 8.5)));
        Registries.addBlock("rustic_stone_iron_fence", () -> new VariantWallBlock(1L, BlockBehaviour.Properties.m_284310_().m_60913_(0.3f, 10.0f).m_60918_(SoundType.f_56742_).m_60922_(detail::disallowSpawn), 1.5, 16.0, 1.0, 10.0, 14.0, 16.0, 3.0, 24.0, 3.0, 0.0, 24.0, 24.0, true));
        Registries.addBlock("chimney", () -> new SimpleBlocks.ChimneyBlock(1L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 3.0f).m_60918_(SoundType.f_56742_), new AABB[]{Auxiliaries.getPixeledAABB(2.0, 0.0, 2.0, 14.0, 11.0, 14.0), Auxiliaries.getPixeledAABB(0.0, 11.0, 0.0, 16.0, 16.0, 16.0)}), SimpleBlocks.ChimneyBlock.ChimneyBlockEntity::new);
        Registries.addBlock("weathered_stone_brick_block", () -> new StandardBlocks.BaseBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 7.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        Registries.addBlock("weathered_stone_brick_slab", () -> new VariantSlabBlock(0L, BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 7.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        Registries.addBlock("weathered_stone_brick_stairs", () -> new StandardStairsBlock(0L, () -> Registries.getBlock("weathered_stone_brick_block").m_49966_(), BlockBehaviour.Properties.m_284310_().m_60913_(1.5f, 7.0f).m_60918_(SoundType.f_56742_).m_60999_()));
        Registries.addBlock("calloty", () -> new SpecialFlowerBlock(0L, BlockBehaviour.Properties.m_284310_().m_60910_().m_60966_().m_60918_(SoundType.f_56740_).m_60977_()));
        Registries.addBlock("ariadne_coal_block", () -> new AriadneCoalBlock(4L, BlockBehaviour.Properties.m_284310_().m_60913_(0.2f, 2.0f).m_60918_(SoundType.f_56742_).m_60910_().m_222994_()));
    }

    public static void initItems() {
        Registries.addItem("rusty_iron_ingot", () -> new ModItem(detail.default_item_properties()));
        Registries.addItem("rusty_iron_nugget", () -> new ModItem(detail.default_item_properties()));
        Registries.addItem("prospecting_dowser", () -> new ProspectingDowserItem(detail.default_item_properties()));
        Registries.addItem("wand_of_backfilling", () -> new BackfillWandItem(detail.default_item_properties()));
        Registries.addItem("redia_tool", () -> new RediaToolItem(detail.default_item_properties()));
        Registries.addItem("plated_netherite_helmet", () -> new Armors.HelmetArmorItem(Armors.CFG_DEFAULT, detail.reinforced_armor_material(), detail.default_item_properties().m_41486_()));
        Registries.addItem("plated_netherite_chestplate", () -> new Armors.ChestPlateArmorItem(Armors.CFG_MAKES_PIGLINS_NEUTRAL, detail.reinforced_armor_material(), detail.default_item_properties().m_41486_()));
        Registries.addItem("plated_netherite_leggings", () -> new Armors.LeggingsArmorItem(Armors.CFG_MAKES_PIGLINS_NEUTRAL, detail.reinforced_armor_material(), detail.default_item_properties().m_41486_()));
        Registries.addItem("plated_netherite_boots", () -> new Armors.BootsArmorItem(Armors.CFG_DEFAULT, detail.reinforced_armor_material(), detail.default_item_properties().m_41486_()));
        Registries.addItem("peculiar_ring", () -> new Trinkets.TrinketItem(0L, detail.default_item_properties().m_41486_().setNoRepair().m_41497_(Rarity.RARE).m_41499_(1000).m_41503_(1000)));
        Registries.addItem("ariadne_coal", () -> new AriadneCoalItem(detail.default_item_properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
        Registries.addItem("charged_lapis", () -> new ChargedLapisItem(detail.default_item_properties().m_41497_(Rarity.UNCOMMON)));
        Registries.addItem("charged_amethyst", () -> new ChargedLapisItem(detail.default_item_properties().m_41497_(Rarity.UNCOMMON)));
        Registries.addItem("charged_lapis_squeezer", () -> new ChargedLapisSqueezerItem(detail.default_item_properties().m_41497_(Rarity.UNCOMMON)));
        Registries.addItem("crushing_hammer", () -> new CrushingHammerItem(detail.default_item_properties().m_41487_(1).m_41497_(Rarity.UNCOMMON)));
        Registries.addItem("crushed_iron", () -> new GritItem(detail.default_item_properties()));
        Registries.addItem("crushed_gold", () -> new GritItem(detail.default_item_properties()));
        Registries.addItem("crushed_copper", () -> new GritItem(detail.default_item_properties()));
        Registries.addItem("tracking_compass", () -> new TrackerItem(detail.default_item_properties()));
    }

    public static void initEntities() {
        Registries.addEntityType("et_chair", () -> EntityType.Builder.m_20704_(Chair.EntityChair::new, (MobCategory)MobCategory.MISC).m_20719_().m_20699_(0.001f, 0.001f).m_20716_().setShouldReceiveVelocityUpdates(false).setUpdateInterval(4).setCustomClientFactory(Chair.EntityChair::customClientFactory).m_20712_(new ResourceLocation(Auxiliaries.modid(), "et_chair").toString()));
    }

    public static void initPaintings() {
        Registries.addPainting("painting_melon_16x16", 16, 16);
        Registries.addPainting("painting_poppy_meadow_16x32", 16, 32);
        Registries.addPainting("painting_sunflower_64x48", 64, 48);
        Registries.addPainting("painting_valley_64x32", 64, 32);
        Registries.addPainting("painting_mushroom_16x16", 16, 16);
        Registries.addPainting("painting_lillypads_32x16", 32, 16);
        Registries.addPainting("painting_holyrood_park_abstract_32x32", 32, 32);
        Registries.addPainting("painting_flower_abstract_32x32", 32, 32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerMenuGuis(FMLClientSetupEvent event) {
        MenuScreens.m_96206_(Registries.getMenuTypeOfBlock("crafting_table"), ExtCraftingTable.CraftingTableGui::new);
        MenuScreens.m_96206_(Registries.getMenuTypeOfBlock("crate"), LabeledCrate.LabeledCrateGui::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerBlockEntityRenderers(FMLClientSetupEvent event) {
        BlockEntityRenderers.m_173590_(Registries.getBlockEntityTypeOfBlock("crafting_table"), ModRenderers.CraftingTableTer::new);
        BlockEntityRenderers.m_173590_(Registries.getBlockEntityTypeOfBlock("crate"), ModRenderers.LabeledCrateTer::new);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processContentClientSide(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_(Registries.getEntityType("et_chair"), ModRenderers.InvisibleEntityRenderer::new);
    }

    private static class detail {
        public static String MODID = "";
        private static Materials.CustomArmorMaterial reinforced_armor_material_ = null;

        private detail() {
        }

        public static Boolean disallowSpawn(BlockState state, BlockGetter reader, BlockPos pos, EntityType<?> entity) {
            return false;
        }

        public static Materials.CustomArmorMaterial reinforced_armor_material() {
            if (reinforced_armor_material_ == null) {
                reinforced_armor_material_ = new Materials.CustomArmorMaterial(MODID + ":plated_netherite", SoundEvents.f_11679_, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_}), new int[]{4, 8, 10, 4}, new int[]{546, 630, 672, 462}, 15, 4.0f, 0.2f);
            }
            return reinforced_armor_material_;
        }

        public static Item.Properties default_item_properties() {
            return new Item.Properties();
        }
    }
}

