/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection;

import com.mojang.logging.LogUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import wile.wilescollection.ModConfig;
import wile.wilescollection.ModContent;
import wile.wilescollection.blocks.ExtLadderBlock;
import wile.wilescollection.detail.ModRenderers;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Networking;
import wile.wilescollection.libmc.OptionalRecipeCondition;
import wile.wilescollection.libmc.Overlay;
import wile.wilescollection.libmc.Registries;

@Mod(value="wilescollection")
public class ModWilesCollection {
    public static final String MODID = "wilescollection";
    public static final String MODNAME = "WilE's Collection";
    public static final int VERSION_DATAFIXER = 0;
    private static final Logger LOGGER = LogUtils.getLogger();

    public ModWilesCollection() {
        Auxiliaries.init(MODID, LOGGER, ModConfig::getServerConfig);
        Auxiliaries.logGitVersion(MODNAME);
        Registries.init(MODID, "rustic_iron_lantern", reg -> reg.register(FMLJavaModLoadingContext.get().getModEventBus()));
        ModContent.init(MODID);
        OptionalRecipeCondition.init(MODID, LOGGER);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.COMMON_CONFIG_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onClientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onRegisterModels);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onCreativeModeTabContents);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static Logger logger() {
        return LOGGER;
    }

    private void onSetup(FMLCommonSetupEvent event) {
        CraftingHelper.register((IConditionSerializer)OptionalRecipeCondition.Serializer.INSTANCE);
        Networking.init(MODID);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        Overlay.TextOverlayGui.on_config(0.75, 0xFFAA00, 0x55333333, 0x55333333, 0x55444444);
        Networking.OverlayTextMessage.setHandler(Overlay.TextOverlayGui::show);
        ModContent.registerMenuGuis(event);
        ModContent.registerBlockEntityRenderers(event);
        ModContent.processContentClientSide(event);
    }

    private void onRegisterModels(ModelEvent.RegisterAdditional event) {
        ModRenderers.CraftingTableTer.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ModRenderers.LabeledCrateTer.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ModRenderers.TrackerIster.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
        ModRenderers.ProspectingDowserIster.registerModels().forEach(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    private void onCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
    }

    @SubscribeEvent
    public void onPlayerEvent(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_6147_()) {
            ExtLadderBlock.onPlayerUpdateEvent(player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @Mod.EventBusSubscriber(value={Dist.CLIENT})
    public static class ForgeClientEvents {
        @SubscribeEvent
        public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
            Overlay.TextOverlayGui.INSTANCE.onRenderGui(event.getGuiGraphics());
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public static void onRenderWorldOverlay(RenderLevelStageEvent event) {
            if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
                Overlay.TextOverlayGui.INSTANCE.onRenderWorldOverlay(event.getPoseStack(), event.getPartialTick());
            }
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ForgeEvents {
        @SubscribeEvent
        public static void onConfigLoad(ModConfigEvent.Loading event) {
            ModConfig.apply();
        }

        @SubscribeEvent
        public static void onConfigReload(ModConfigEvent.Reloading event) {
            try {
                ModConfig.apply();
            }
            catch (Throwable e) {
                ModWilesCollection.logger().error("Failed to load changed config: " + e.getMessage());
            }
        }
    }
}

