/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import wile.wilescollection.libmc.Auxiliaries;
import wile.wilescollection.libmc.Registries;
import wile.wilescollection.libmc.blocks.StandardBlocks;
import wile.wilescollection.libmc.blocks.StandardEntityBlocks;

public class SimpleBlocks {

    public static class VariantVineBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardBlocks.IStandardBlock {
        public static final IntegerProperty VARIANT = IntegerProperty.m_61631_((String)"variant", (int)0, (int)7);

        public VariantVineBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.TRANSLUCENT;
        }

        @Override
        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            return true;
        }

        public boolean m_7923_(BlockState state) {
            return true;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{VARIANT});
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockState state = super.m_5573_(context);
            return state;
        }
    }

    public static class ChimneyBlock
    extends StandardBlocks.WaterLoggable
    implements StandardEntityBlocks.IStandardEntityBlock<ChimneyBlockEntity> {
        public ChimneyBlock(long conf, BlockBehaviour.Properties properties, AABB[] aabbs) {
            super(conf, properties, aabbs);
        }

        @Override
        public boolean isBlockEntityClientTicking(Level world, BlockState state) {
            return true;
        }

        public static class ChimneyBlockEntity
        extends StandardEntityBlocks.StandardBlockEntity {
            public ChimneyBlockEntity(BlockPos pos, BlockState state) {
                super(Registries.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
            }

            @Override
            public void tick() {
                Level world = this.m_58904_();
                RandomSource rnd = world.m_213780_();
                int num_particles = rnd.m_188503_(4) - 1;
                if (num_particles <= 0 || !world.m_5776_() || (world.m_46467_() & 7L) != 0L) {
                    return;
                }
                if (!(world.m_8055_(this.m_58899_()).m_60734_() instanceof ChimneyBlock)) {
                    return;
                }
                BlockPos pos = this.m_58899_();
                for (int i = num_particles; i >= 0; --i) {
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, (double)pos.m_123341_() + 0.5 + rnd.m_188500_() / 3.0 * (double)(rnd.m_188499_() ? 1 : -1), (double)pos.m_123342_() + 0.9 + rnd.m_188500_(), (double)pos.m_123343_() + 0.5 + rnd.m_188500_() / 3.0 * (double)(rnd.m_188499_() ? 1 : -1), 0.0, 0.07, 0.0);
                }
            }
        }
    }

    public static class OmniLanternBlock
    extends StandardBlocks.DirectedWaterLoggable
    implements StandardBlocks.IStandardBlock {
        public OmniLanternBlock(long config, BlockBehaviour.Properties builder, AABB[] wallAABBs, AABB[] standingAABBs, AABB[] handingAABBs) {
            super(config, builder, () -> {
                boolean is_horizontal = false;
                return new ArrayList<VoxelShape>(Arrays.asList(Auxiliaries.getUnionShape(standingAABBs), Auxiliaries.getUnionShape(handingAABBs), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(wallAABBs, Direction.NORTH, false)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(wallAABBs, Direction.SOUTH, false)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(wallAABBs, Direction.WEST, false)), Auxiliaries.getUnionShape(Auxiliaries.getRotatedAABB(wallAABBs, Direction.EAST, false)), Shapes.m_83144_(), Shapes.m_83144_()));
            });
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            BlockPos pos;
            BlockState state = super.m_5573_(context);
            if (state == null) {
                return state;
            }
            Direction facing = context.m_43719_().m_122424_();
            Level world = context.m_43725_();
            return world.m_8055_((pos = context.m_8083_()).m_121945_(facing)).m_60795_() ? null : state;
        }

        @Override
        public PushReaction getPistonPushReaction(BlockState state) {
            return PushReaction.DESTROY;
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            return Block.m_49863_((LevelReader)world, (BlockPos)pos.m_121945_(facing), (Direction)facing.m_122424_());
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            return this.m_7898_(state = super.m_7417_(state, facing, facingState, world, pos, facingPos), (LevelReader)world, pos) && state.m_60713_((Block)this) ? state : state.m_60819_().m_76188_();
        }
    }

    public static class WindowBlock
    extends StandardBlocks.DirectedWaterLoggable {
        public WindowBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public StandardBlocks.IStandardBlock.RenderTypeHint getRenderTypeHint() {
            return StandardBlocks.IStandardBlock.RenderTypeHint.TRANSLUCENT;
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            Direction facing = context.m_8125_();
            if (Math.abs(context.m_43723_().m_20154_().f_82480_) > 0.9) {
                facing = context.m_7820_();
            } else {
                for (Direction f : Direction.values()) {
                    BlockState st = context.m_43725_().m_8055_(context.m_8083_().m_121945_(f));
                    if (st.m_60734_() != this) continue;
                    facing = (Direction)st.m_61143_((Property)FACING);
                    break;
                }
            }
            return (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)facing);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
            if (player.m_21120_(hand).m_41720_() != this.m_5456_()) {
                return InteractionResult.PASS;
            }
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (facing.m_122434_() != hit.m_82434_().m_122434_()) {
                return InteractionResult.PASS;
            }
            Arrays.stream(Direction.m_122382_((Entity)player)).filter(d -> d.m_122434_() != facing.m_122434_()).filter(d -> world.m_8055_(pos.m_121945_(d)).m_60629_((BlockPlaceContext)new DirectionalPlaceContext(world, pos.m_121945_(d), facing.m_122424_(), player.m_21120_(hand), facing))).findFirst().ifPresent(d -> {
                BlockState st = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.m_8055_(pos.m_121945_(d)).m_60819_().m_76152_() == Fluids.f_76193_));
                world.m_7731_(pos.m_121945_(d), st, 3);
                world.m_5594_(player, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_21120_(hand).m_41774_(1);
            });
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }

        @Override
        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            return true;
        }

        public boolean m_7923_(BlockState state) {
            return true;
        }
    }

    public static class TableBlock
    extends StandardBlocks.HorizontalFourWayWaterLoggable
    implements StandardBlocks.IStandardBlock {
        public TableBlock(long config, BlockBehaviour.Properties builder, AABB base_aabb, AABB[] side_aabb) {
            super(config, builder.m_60977_(), base_aabb, side_aabb, 0);
        }

        private BlockState getAdaptedState(BlockState state, LevelAccessor world, BlockPos pos) {
            boolean w;
            boolean n = world.m_8055_(pos.m_121945_(Direction.NORTH)).m_60734_() == this;
            boolean e = world.m_8055_(pos.m_121945_(Direction.EAST)).m_60734_() == this;
            boolean s = world.m_8055_(pos.m_121945_(Direction.SOUTH)).m_60734_() == this;
            boolean bl = w = world.m_8055_(pos.m_121945_(Direction.WEST)).m_60734_() == this;
            return state == null ? null : (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)StandardBlocks.HorizontalFourWayWaterLoggable.NORTH, (Comparable)Boolean.valueOf(!n && !e))).m_61124_((Property)StandardBlocks.HorizontalFourWayWaterLoggable.EAST, (Comparable)Boolean.valueOf(!e && !s))).m_61124_((Property)StandardBlocks.HorizontalFourWayWaterLoggable.SOUTH, (Comparable)Boolean.valueOf(!s && !w))).m_61124_((Property)StandardBlocks.HorizontalFourWayWaterLoggable.WEST, (Comparable)Boolean.valueOf(!w && !n));
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return this.getAdaptedState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            return this.getAdaptedState(super.m_7417_(state, facing, facingState, world, pos, facingPos), world, pos);
        }
    }
}

