/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.libmc.Effects;
import wile.wilescollection.libmc.blocks.StandardBlocks;

public class SpecialFlowerBlock
extends FlowerBlock
implements StandardBlocks.IStandardBlock {
    public static final IntegerProperty MOOD = IntegerProperty.m_61631_((String)"mood", (int)0, (int)3);
    public static final int MOOD_NORMAL = 0;
    public static final int MOOD_FRIGHTENED = 1;
    public static final int MOOD_HAPPY = 2;
    public static final int MOOD_ANGRY = 3;

    public SpecialFlowerBlock(long config, BlockBehaviour.Properties properties) {
        super(MobEffects.f_19603_, 10, properties);
        this.m_49959_((BlockState)super.m_49966_().m_61124_((Property)MOOD, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public long config() {
        return 1L;
    }

    @Override
    public boolean hasDynamicDropList() {
        return true;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{MOOD});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return this.getAdaptedState(super.m_5573_(context), (LevelAccessor)context.m_43725_(), context.m_8083_());
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
        return this.getAdaptedState(super.m_7417_(state, facing, facingState, world, pos, facingPos), world, pos);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Float r = (Float)builder.m_287159_(LootContextParams.f_81464_);
        return this.dropList(state, (Level)builder.m_287258_(), null, r != null && r.floatValue() > 0.0f);
    }

    private BlockState getAdaptedState(BlockState state, LevelAccessor access, BlockPos pos) {
        Level world;
        if (!(access instanceof Level) || (world = (Level)access).m_5776_()) {
            return state;
        }
        int mood = 0;
        if (world.m_46803_(pos) < 5) {
            mood = 1;
        }
        return (BlockState)state.m_61124_((Property)MOOD, (Comparable)Integer.valueOf(mood));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        switch ((Integer)state.m_61143_((Property)MOOD)) {
            case 0: {
                if (rand.m_188503_(10) != 0) {
                    return;
                }
                Vec3 p = Vec3.m_82512_((Vec3i)pos).m_82549_(state.m_60824_((BlockGetter)world, pos)).m_82520_(0.0, 0.2, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123757_, p.m_7096_(), p.m_7098_(), p.m_7094_(), rand.m_188583_() * 0.005, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005);
                break;
            }
            case 1: {
                if (rand.m_188503_(10) != 0) {
                    return;
                }
                Vec3 p = Vec3.m_82512_((Vec3i)pos).m_82549_(state.m_60824_((BlockGetter)world, pos)).m_82492_(0.0, 0.1, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123772_, p.m_7096_(), p.m_7098_(), p.m_7094_(), rand.m_188583_() * 0.005, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005);
                break;
            }
            case 2: {
                Vec3 p = Vec3.m_82512_((Vec3i)pos).m_82549_(state.m_60824_((BlockGetter)world, pos)).m_82520_(0.0, 0.2, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123790_, p.m_7096_(), p.m_7098_(), p.m_7094_(), rand.m_188583_() * 0.005, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005);
                break;
            }
            case 3: {
                if (rand.m_188503_(4) != 0) {
                    return;
                }
                Vec3 p = Vec3.m_82512_((Vec3i)pos).m_82549_(state.m_60824_((BlockGetter)world, pos)).m_82520_(0.0, 0.2, 0.0);
                world.m_7106_((ParticleOptions)ParticleTypes.f_123792_, p.m_7096_(), p.m_7098_(), p.m_7094_(), rand.m_188583_() * 0.005, rand.m_188583_() * 0.005, rand.m_188583_() * 0.005);
            }
        }
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
        if (!world.m_45976_(LivingEntity.class, AABB.m_82333_((Vec3)Vec3.m_82528_((Vec3i)pos))).isEmpty()) {
            return;
        }
        BlockState new_state = this.getAdaptedState(state, (LevelAccessor)world, pos);
        if (new_state != state) {
            world.m_7731_(pos, new_state, 3);
        }
    }

    public float m_49964_() {
        return 1.75f;
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        return (Integer)state.m_61143_((Property)MOOD) == 3 ? 15 : 4;
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_21255_()) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)MOOD, (Comparable)Integer.valueOf(2)), 3);
                if (player.m_36325_() && (world.m_46467_() & 0xFL) == 0L) {
                    player.m_5634_(0.25f);
                }
                Effects.assign((LivingEntity)player, MobEffects.f_19596_, 200);
                Effects.assign((LivingEntity)player, MobEffects.f_19591_, 60);
            } else if ((Integer)state.m_61143_((Property)MOOD) != 2) {
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)MOOD, (Comparable)Integer.valueOf(1)), 3);
            }
        } else if (entity instanceof Monster) {
            Monster monster = (Monster)entity;
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)MOOD, (Comparable)Integer.valueOf(3)), 3);
            if ((world.f_46441_.m_188502_() & 0xF) < 4) {
                monster.m_7311_(80);
                Effects.assign((LivingEntity)monster, MobEffects.f_19597_, 200);
                Effects.assign((LivingEntity)monster, MobEffects.f_19604_, 200);
            }
        }
        if (!world.m_183326_().m_183582_(pos, (Object)this)) {
            world.m_186464_(pos, (Block)this, 100, TickPriority.LOW);
        }
    }
}

