/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.blocks;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import wile.wilescollection.libmc.Inventories;
import wile.wilescollection.libmc.blocks.StandardBlocks;

public class StraightPoleBlock
extends StandardBlocks.DirectedWaterLoggable {
    private final StraightPoleBlock default_pole;

    public StraightPoleBlock(long config, BlockBehaviour.Properties builder, AABB unrotatedAABB, @Nullable StraightPoleBlock defaultPole) {
        super(config, builder, unrotatedAABB);
        this.default_pole = defaultPole == null ? this : defaultPole;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos;
        Level world;
        Direction facing = context.m_43719_();
        BlockState state = (BlockState)super.m_5573_(context).m_61124_((Property)FACING, (Comparable)facing);
        if ((this.config & 0x100L) != 0L && (world = context.m_43725_()).m_8055_((pos = context.m_8083_()).m_121945_(facing.m_122424_())).m_60734_() instanceof StraightPoleBlock) {
            state = (BlockState)state.m_61124_((Property)FACING, (Comparable)((Direction)state.m_61143_((Property)FACING)).m_122424_());
        }
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        DirectionalPlaceContext ctx;
        if (hit.m_82434_().m_122434_() == ((Direction)state.m_61143_((Property)FACING)).m_122434_()) {
            return InteractionResult.PASS;
        }
        ItemStack held_stack = player.m_21120_(hand);
        if (held_stack.m_41619_() || !(held_stack.m_41720_() instanceof BlockItem)) {
            return InteractionResult.PASS;
        }
        if (!(((BlockItem)held_stack.m_41720_()).m_40614_() instanceof StraightPoleBlock)) {
            return InteractionResult.PASS;
        }
        if (held_stack.m_41720_() != this.default_pole.m_5456_()) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        Block held_block = ((BlockItem)held_stack.m_41720_()).m_40614_();
        Direction block_direction = (Direction)state.m_61143_((Property)FACING);
        Vec3 block_vec = Vec3.m_82528_((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122436_());
        double colinearity = 1.0 - block_vec.m_82537_(player.m_20154_()).m_82553_();
        Direction placement_direction = Arrays.stream(Direction.m_122382_((Entity)player)).filter(d -> d.m_122434_() == block_direction.m_122434_()).findFirst().orElse(Direction.NORTH);
        BlockPos adjacent_pos = pos.m_121945_(placement_direction);
        BlockState adjacent = world.m_8055_(adjacent_pos);
        if (!adjacent.m_60629_((BlockPlaceContext)(ctx = new DirectionalPlaceContext(world, adjacent_pos, placement_direction, player.m_21120_(hand), placement_direction.m_122424_())))) {
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        }
        BlockState new_state = held_block.m_5573_((BlockPlaceContext)ctx);
        if (new_state == null) {
            return InteractionResult.FAIL;
        }
        if (!world.m_7731_(adjacent_pos, new_state, 3)) {
            return InteractionResult.FAIL;
        }
        world.m_5594_(player, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.m_7500_()) {
            held_stack.m_41774_(1);
            Inventories.setItemInPlayerHand(player, hand, held_stack);
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }
}

