/*
 * Decompiled with CFR 0.152.
 */
package wile.wilescollection.detail;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.wilescollection.blocks.ExtCraftingTable;
import wile.wilescollection.blocks.LabeledCrate;
import wile.wilescollection.items.TrackerItem;
import wile.wilescollection.libmc.Auxiliaries;

public class ModRenderers {

    @OnlyIn(value=Dist.CLIENT)
    public static class TrackerIster
    extends BlockEntityWithoutLevelRenderer {
        public static List<ModelResourceLocation> registerModels() {
            return List.of(new ModelResourceLocation(new ResourceLocation(Auxiliaries.modid(), "tracking_compass_pointer_model"), "inventory"));
        }

        public TrackerIster() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext idc, PoseStack mx, MultiBufferSource buf, int combinedLight, int combinedOverlay) {
            if (idc == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || idc == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND) {
                return;
            }
            Optional<Tuple<Integer, Integer>> rotations = TrackerItem.getUiAngles(stack);
            mx.m_85836_();
            ItemRenderer ir = Minecraft.m_91087_().m_91291_();
            VertexConsumer vb = ItemRenderer.m_115211_((MultiBufferSource)buf, (RenderType)RenderType.m_110463_(), (boolean)true, (boolean)false);
            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(new ResourceLocation(Auxiliaries.modid(), "tracking_compass_pointer_model"), "inventory"));
            mx.m_85837_(0.5, 0.5, 0.5);
            if (rotations.isEmpty()) {
                mx.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            } else {
                mx.m_252781_(Axis.f_252436_.m_252977_((float)((Integer)rotations.get().m_14419_()).intValue()));
                mx.m_252781_(Axis.f_252529_.m_252977_((float)((Integer)rotations.get().m_14418_()).intValue()));
            }
            mx.m_85841_(0.6f, 0.6f, 0.6f);
            mx.m_85837_(-0.5, -0.5, -0.5);
            ir.m_115189_(model, stack, combinedLight, combinedOverlay, mx, vb);
            mx.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ProspectingDowserIster
    extends BlockEntityWithoutLevelRenderer {
        public static List<ModelResourceLocation> registerModels() {
            return List.of(new ModelResourceLocation(new ResourceLocation("wilescollection", "prospecting_dowser_model"), "inventory"), new ModelResourceLocation(new ResourceLocation("wilescollection", "prospecting_dowser_model_e"), "inventory"));
        }

        public ProspectingDowserIster() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext idc, PoseStack mx, MultiBufferSource buf, int combinedLight, int combinedOverlay) {
            mx.m_85836_();
            ItemRenderer ir = Minecraft.m_91087_().m_91291_();
            VertexConsumer vb = ItemRenderer.m_115211_((MultiBufferSource)buf, (RenderType)RenderType.m_110463_(), (boolean)true, (boolean)false);
            BakedModel base_model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(new ResourceLocation("wilescollection", "prospecting_dowser_model"), "inventory"));
            ir.m_115189_(base_model, stack, combinedLight, combinedOverlay, mx, vb);
            int rotation = !stack.m_41782_() ? 0 : stack.m_41783_().m_128451_("rotation");
            BakedModel active_model = Minecraft.m_91087_().m_91304_().m_119422_(new ModelResourceLocation(new ResourceLocation("wilescollection", "prospecting_dowser_model_e"), "inventory"));
            mx.m_85837_(0.5, 0.5, 0.5);
            mx.m_252781_(Axis.f_252403_.m_252977_(-45.0f));
            mx.m_252781_(Axis.f_252436_.m_252977_((float)rotation));
            mx.m_252781_(Axis.f_252403_.m_252977_(45.0f));
            mx.m_85837_(-0.5, -0.5, -0.5);
            ir.m_115189_(active_model, stack, combinedLight, combinedOverlay, mx, vb);
            mx.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class LabeledCrateTer
    implements BlockEntityRenderer<LabeledCrate.LabeledCrateTileEntity> {
        private static int tesr_error_counter = 16;
        private static final float scaler = 0.35f;
        private static final double[][] tr = new double[][]{{0.25, -0.25, 0.484375, 180.0}, {-0.484375, -0.25, 0.25, 90.0}, {-0.25, -0.25, -0.484375, 0.0}, {0.484375, -0.25, -0.25, 270.0}};
        private final BlockEntityRendererProvider.Context renderer_;

        public static List<ModelResourceLocation> registerModels() {
            ArrayList<ModelResourceLocation> resources_to_register = new ArrayList<ModelResourceLocation>();
            return resources_to_register;
        }

        public LabeledCrateTer(BlockEntityRendererProvider.Context renderer) {
            this.renderer_ = renderer;
        }

        public void render(LabeledCrate.LabeledCrateTileEntity te, float unused1, PoseStack mxs, MultiBufferSource buf, int i5, int overlayTexture) {
            block5: {
                if (tesr_error_counter <= 0) {
                    return;
                }
                try {
                    ItemStack stack = te.getItemFrameStack();
                    if (stack.m_41619_()) {
                        return;
                    }
                    BlockState state = te.m_58904_().m_8055_(te.m_58899_());
                    if (!(state.m_60734_() instanceof LabeledCrate.LabeledCrateBlock)) {
                        return;
                    }
                    int di = Mth.m_14045_((int)((Direction)state.m_61143_((Property)LabeledCrate.LabeledCrateBlock.HORIZONTAL_FACING)).m_122416_(), (int)0, (int)3);
                    double ox = tr[di][0];
                    double oy = tr[di][1];
                    double oz = tr[di][2];
                    float ry = (float)tr[di][3];
                    mxs.m_85836_();
                    mxs.m_85837_(0.5 + ox, 0.5 + oy, 0.5 + oz);
                    mxs.m_252781_(Axis.f_252436_.m_252977_(ry));
                    mxs.m_85841_(0.35f, 0.35f, 0.35f);
                    Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, i5, overlayTexture, mxs, buf, te.m_58904_(), 0);
                    mxs.m_85849_();
                }
                catch (Throwable e) {
                    if (--tesr_error_counter > 0) break block5;
                    Auxiliaries.logger().error("TER was disabled (because broken), exception was: " + e.getMessage());
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CraftingTableTer
    implements BlockEntityRenderer<ExtCraftingTable.CraftingTableTileEntity> {
        private static int tesr_error_counter = 4;
        private static final float scaler = 0.1f;
        private static final float gap = 0.19f;
        private static final float[] yrotations = new float[]{0.0f, 90.0f, 180.0f, 270.0f};
        private static final float[][][] offsets = new float[][][]{new float[][]{{-1.0f, -1.0f}, {0.0f, -1.0f}, {1.0f, -1.0f}, {-1.0f, 0.0f}, {0.0f, 0.0f}, {1.0f, 0.0f}, {-1.0f, 1.0f}, {0.0f, 1.0f}, {1.0f, 1.0f}}, new float[][]{{1.0f, -1.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, -1.0f}, {0.0f, 0.0f}, {0.0f, 1.0f}, {-1.0f, -1.0f}, {-1.0f, 0.0f}, {-1.0f, 1.0f}}, new float[][]{{1.0f, 1.0f}, {0.0f, 1.0f}, {-1.0f, 1.0f}, {1.0f, 0.0f}, {0.0f, 0.0f}, {-1.0f, 0.0f}, {1.0f, -1.0f}, {0.0f, -1.0f}, {-1.0f, -1.0f}}, new float[][]{{-1.0f, 1.0f}, {-1.0f, 0.0f}, {-1.0f, -1.0f}, {0.0f, 1.0f}, {0.0f, 0.0f}, {0.0f, -1.0f}, {1.0f, 1.0f}, {1.0f, 0.0f}, {1.0f, -1.0f}}};
        private final BlockEntityRendererProvider.Context renderer_;

        public static List<ModelResourceLocation> registerModels() {
            ArrayList<ModelResourceLocation> resources_to_register = new ArrayList<ModelResourceLocation>();
            return resources_to_register;
        }

        public CraftingTableTer(BlockEntityRendererProvider.Context renderer) {
            this.renderer_ = renderer;
        }

        public void render(ExtCraftingTable.CraftingTableTileEntity te, float unused1, PoseStack mxs, MultiBufferSource buf, int i5, int overlayTexture) {
            block6: {
                if (tesr_error_counter <= 0) {
                    return;
                }
                try {
                    BlockState state = te.m_58904_().m_8055_(te.m_58899_());
                    if (!(state.m_60734_() instanceof ExtCraftingTable.CraftingTableBlock)) {
                        return;
                    }
                    int di = Mth.m_14045_((int)((Direction)state.m_61143_((Property)ExtCraftingTable.CraftingTableBlock.HORIZONTAL_FACING)).m_122416_(), (int)0, (int)3);
                    long posrnd = te.m_58899_().m_121878_();
                    posrnd = posrnd >> 16 ^ posrnd << 1;
                    for (int i = 0; i < 9; ++i) {
                        ItemStack stack = te.mainInventory().m_8020_(i);
                        if (stack.m_41619_()) continue;
                        float prnd = (float)(Integer.rotateRight(stack.m_41720_().hashCode() ^ (int)posrnd, stack.m_41613_() + i & 0x1F) & 0x3FF) / 1024.0f;
                        float rndo = 0.19f * (prnd * 0.1f - 0.05f);
                        float ox = 0.19f * offsets[di][i][0];
                        float oz = 0.19f * offsets[di][i][1];
                        float oy = 0.5f;
                        float ry = (yrotations[di] + 180.0f + (prnd * 60.0f - 30.0f)) % 360.0f;
                        if (stack.m_41619_()) {
                            return;
                        }
                        mxs.m_85836_();
                        mxs.m_85837_(0.5 + (double)ox, 0.5 + (double)oy, 0.5 + (double)oz);
                        mxs.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                        mxs.m_252781_(Axis.f_252403_.m_252977_(ry));
                        mxs.m_252880_(rndo, rndo, 0.0f);
                        mxs.m_85841_(0.1f, 0.1f, 0.1f);
                        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.FIXED, i5, overlayTexture, mxs, buf, te.m_58904_(), 0);
                        mxs.m_85849_();
                    }
                }
                catch (Throwable e) {
                    if (--tesr_error_counter > 0) break block6;
                    Auxiliaries.logger().error("TER was disabled because broken, exception was: " + e.getMessage());
                    Auxiliaries.logger().error(Arrays.stream(e.getStackTrace()).map(l -> l.toString()).collect(Collectors.joining("\n,")));
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class InvisibleEntityRenderer<T extends Entity>
    extends EntityRenderer<T> {
        private final Minecraft mc = Minecraft.m_91087_();

        public InvisibleEntityRenderer(EntityRendererProvider.Context context) {
            super(context);
        }

        public void m_7392_(T entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        }

        public Vec3 m_7860_(T entity, float partialTicks) {
            return Vec3.f_82478_;
        }

        public ResourceLocation m_5478_(T entity) {
            return TextureAtlas.f_118259_;
        }

        protected boolean m_6512_(T entity) {
            return false;
        }

        protected void m_7649_(T entity, Component displayName, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        }
    }
}

